/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.models.XSAllCM;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.models.XSDFACM;
import org.apache.xerces.impl.xs.models.XSEmptyCM;
import org.apache.xerces.impl.xs.models.XSSimpleCM;
import org.apache.xerces.xni.QName;

public class CMBuilder {
    private final QName fQName1 = new QName();
    private final QName fQName2 = new QName();
    private XSDeclarationPool fDeclPool = null;
    private int fLeafCount;

    public CMBuilder(XSDeclarationPool pool) {
        this.fDeclPool = pool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl typeDecl) {
        short contentType = typeDecl.fContentType;
        if (contentType == 1 || contentType == 0) {
            return null;
        }
        XSCMValidator cmValidator = null;
        XSParticleDecl particle = typeDecl.fParticle;
        if (particle != null) {
            particle = this.expandParticleTree(particle);
        }
        if (particle == null) {
            cmValidator = new XSEmptyCM();
        } else if (contentType == 2) {
            cmValidator = this.createChildModel(particle, true);
        } else if (contentType == 3) {
            cmValidator = this.createChildModel(particle, false);
        } else {
            throw new RuntimeException("Unknown content type for a element decl in getElementContentModelValidator() in Grammar class");
        }
        return cmValidator;
    }

    private XSParticleDecl expandParticleTree(XSParticleDecl particle) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        if (type == 2 || type == 1) {
            return this.expandContentModel(particle, minOccurs, maxOccurs);
        }
        if (type == 3 || type == 5 || type == 4) {
            Object left = particle.fValue;
            Object right = particle.fOtherValue;
            left = this.expandParticleTree((XSParticleDecl)left);
            if (right != null) {
                right = this.expandParticleTree((XSParticleDecl)right);
            }
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return this.expandContentModel((XSParticleDecl)right, minOccurs, maxOccurs);
            }
            if (right == null) {
                return this.expandContentModel((XSParticleDecl)left, minOccurs, maxOccurs);
            }
            XSParticleDecl newParticle = new XSParticleDecl();
            newParticle.fType = particle.fType;
            newParticle.fValue = left;
            newParticle.fOtherValue = right;
            return this.expandContentModel(newParticle, minOccurs, maxOccurs);
        }
        if (type == 0) {
            return null;
        }
        return particle;
    }

    private XSCMValidator createChildModel(XSParticleDecl particle, boolean isMixed) {
        short type = particle.fType;
        if (type != 2) {
            XSParticleDecl left;
            if (isMixed) {
                if (type == 5) {
                    XSAllCM allContent = new XSAllCM(false);
                    this.gatherAllLeaves((XSParticleDecl)particle.fValue, allContent);
                    this.gatherAllLeaves((XSParticleDecl)particle.fOtherValue, allContent);
                    return allContent;
                }
                if (type == 6) {
                    left = (XSParticleDecl)particle.fValue;
                    if (type == 5) {
                        XSAllCM allContent = new XSAllCM(true);
                        this.gatherAllLeaves(left, allContent);
                        return allContent;
                    }
                }
            } else {
                if (type == 1) {
                    if (particle.fValue == null && particle.fOtherValue == null) {
                        throw new RuntimeException("ImplementationMessages.VAL_NPCD");
                    }
                    return new XSSimpleCM(type, (XSElementDecl)particle.fValue);
                }
                if (type == 3 || type == 4) {
                    left = (XSParticleDecl)particle.fValue;
                    XSParticleDecl right = (XSParticleDecl)particle.fOtherValue;
                    if (right.fType == 1 && left.fType == 1) {
                        return new XSSimpleCM(type, (XSElementDecl)left.fValue, (XSElementDecl)right.fValue);
                    }
                } else {
                    if (type == 5) {
                        XSParticleDecl left2 = (XSParticleDecl)particle.fValue;
                        XSParticleDecl right = (XSParticleDecl)particle.fOtherValue;
                        XSAllCM allContent = new XSAllCM(false);
                        this.gatherAllLeaves(left2, allContent);
                        this.gatherAllLeaves(right, allContent);
                        return allContent;
                    }
                    if (type == 6 || type == 7 || type == 8) {
                        left = (XSParticleDecl)particle.fValue;
                        if (left.fType == 1) {
                            return new XSSimpleCM(type, (XSElementDecl)left.fValue);
                        }
                        if (left.fType == 5) {
                            XSAllCM allContent = new XSAllCM(true);
                            this.gatherAllLeaves(left, allContent);
                            return allContent;
                        }
                    } else {
                        throw new RuntimeException("ImplementationMessages.VAL_CST");
                    }
                }
            }
        }
        this.fLeafCount = 0;
        CMNode node = this.buildSyntaxTree(particle);
        return new XSDFACM(node, this.fLeafCount, isMixed);
    }

    private XSParticleDecl expandContentModel(XSParticleDecl particle, int minOccurs, int maxOccurs) {
        XSParticleDecl leafParticle = particle;
        XSParticleDecl optional = null;
        if (minOccurs == 1 && maxOccurs == 1) {
            return particle;
        }
        if (minOccurs == 0 && maxOccurs == 1) {
            return this.createParticle((short)6, particle, null);
        }
        if (minOccurs == 0 && maxOccurs == -1) {
            return this.createParticle((short)7, particle, null);
        }
        if (minOccurs == 1 && maxOccurs == -1) {
            return this.createParticle((short)8, particle, null);
        }
        if (maxOccurs == -1) {
            if (minOccurs < 2) {
                // empty if block
            }
            particle = this.createParticle((short)8, particle, null);
            int i = 0;
            while (i < minOccurs - 1) {
                particle = this.createParticle((short)4, leafParticle, particle);
                ++i;
            }
            return particle;
        }
        if (minOccurs == 0) {
            particle = optional = this.createParticle((short)6, leafParticle, null);
            int i = 0;
            while (i < maxOccurs - minOccurs - 1) {
                particle = this.createParticle((short)4, particle, optional);
                ++i;
            }
        } else {
            int i = 0;
            while (i < minOccurs - 1) {
                particle = this.createParticle((short)4, particle, leafParticle);
                ++i;
            }
            optional = this.createParticle((short)6, leafParticle, null);
            int i2 = 0;
            while (i2 < maxOccurs - minOccurs) {
                particle = this.createParticle((short)4, particle, optional);
                ++i2;
            }
        }
        return particle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherAllLeaves(XSParticleDecl particle, XSAllCM allContent) {
        Object left = particle.fValue;
        Object right = particle.fOtherValue;
        short type = particle.fType;
        if (type == 5) {
            this.gatherAllLeaves((XSParticleDecl)left, allContent);
            this.gatherAllLeaves((XSParticleDecl)particle.fOtherValue, allContent);
            return;
        } else if (type == 1) {
            allContent.addElement((XSElementDecl)left, false);
            return;
        } else {
            if (type != 6) throw new RuntimeException("ImplementationMessages.VAL_CSTA");
            if (((XSParticleDecl)left).fType != 1) throw new RuntimeException("ImplementationMessages.VAL_CST");
            allContent.addElement((XSElementDecl)((XSParticleDecl)left).fValue, true);
        }
    }

    private XSParticleDecl createParticle(short type, XSParticleDecl left, XSParticleDecl right) {
        XSParticleDecl newParticle = new XSParticleDecl();
        newParticle.fType = type;
        newParticle.fValue = left;
        newParticle.fOtherValue = right;
        return newParticle;
    }

    private final CMNode buildSyntaxTree(XSParticleDecl startNode) {
        CMNode nodeRet = null;
        if (startNode.fType == 2) {
            nodeRet = new XSCMLeaf(startNode, this.fLeafCount++);
        } else if (startNode.fType == 1) {
            nodeRet = new XSCMLeaf(startNode, this.fLeafCount++);
        } else {
            XSParticleDecl leftNode = (XSParticleDecl)startNode.fValue;
            XSParticleDecl rightNode = (XSParticleDecl)startNode.fOtherValue;
            if (startNode.fType == 3 || startNode.fType == 4) {
                nodeRet = new XSCMBinOp(startNode.fType, this.buildSyntaxTree(leftNode), this.buildSyntaxTree(rightNode));
            } else if (startNode.fType == 7 || startNode.fType == 6 || startNode.fType == 8) {
                nodeRet = new XSCMUniOp(startNode.fType, this.buildSyntaxTree(leftNode));
            } else {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return nodeRet;
    }
}

