/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;

public class SchemaGrammar
implements Grammar {
    private SymbolTable fSymbolTable;
    public String fTargetNamespace;
    SymbolHash fGlobalAttrDecls;
    SymbolHash fGlobalAttrGrpDecls;
    SymbolHash fGlobalElemDecls;
    SymbolHash fGlobalGroupDecls;
    SymbolHash fGlobalNotationDecls;
    SymbolHash fGlobalIDConstraintDecls;
    Hashtable fGlobalTypeDecls;
    XSDDescription fGrammarDescription = null;
    private static final int BASICSET_COUNT = 29;
    private static final int FULLSET_COUNT = 46;
    private static final int INITIAL_SIZE = 16;
    private static final int INC_SIZE = 16;
    private int fCTCount = 0;
    private XSComplexTypeDecl[] fComplexTypeDecls = new XSComplexTypeDecl[16];
    private SimpleLocator[] fCTLocators = new SimpleLocator[16];
    private static final int REDEFINED_GROUP_INIT_SIZE = 2;
    private int fRGCount = 0;
    private XSGroupDecl[] fRedefinedGroupDecls = new XSGroupDecl[2];
    private SimpleLocator[] fRGLocators = new SimpleLocator[1];
    boolean fFullChecked = false;
    private int fSubGroupCount = 0;
    private XSElementDecl[] fSubGroups = new XSElementDecl[16];
    public static final XSComplexTypeDecl fAnyType = new XSComplexTypeDecl();
    public static final SchemaGrammar SG_SchemaNS;
    public static final XSSimpleType fAnySimpleType;

    public SchemaGrammar(SymbolTable symbolTable, String targetNamespace, XSDDescription grammarDesc) {
        this.fSymbolTable = symbolTable;
        this.fTargetNamespace = targetNamespace;
        this.fGrammarDescription = grammarDesc;
        this.fGlobalAttrDecls = new SymbolHash();
        this.fGlobalAttrGrpDecls = new SymbolHash();
        this.fGlobalElemDecls = new SymbolHash();
        this.fGlobalGroupDecls = new SymbolHash();
        this.fGlobalNotationDecls = new SymbolHash();
        this.fGlobalTypeDecls = new Hashtable();
        this.fGlobalIDConstraintDecls = new SymbolHash();
    }

    protected SchemaGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
        this.fGrammarDescription = new XSDDescription();
        this.fGlobalAttrDecls = new SymbolHash(1);
        this.fGlobalAttrGrpDecls = new SymbolHash(1);
        this.fGlobalElemDecls = new SymbolHash(1);
        this.fGlobalGroupDecls = new SymbolHash(1);
        this.fGlobalNotationDecls = new SymbolHash(1);
        this.fGlobalIDConstraintDecls = new SymbolHash(1);
        SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();
        this.fGlobalTypeDecls = schemaFactory.getBuiltInTypes();
        this.addGlobalTypeDecl(fAnyType);
    }

    public XMLGrammarDescription getGrammarDescription() {
        return this.fGrammarDescription;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public final String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public final void addGlobalAttributeDecl(XSAttributeDecl decl) {
        this.fGlobalAttrDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalAttributeGroupDecl(XSAttributeGroupDecl decl) {
        this.fGlobalAttrGrpDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalElementDecl(XSElementDecl decl) {
        this.fGlobalElemDecls.put(decl.fName, (Object)decl);
        if (decl.fSubGroup != null) {
            if (this.fSubGroupCount == this.fSubGroups.length) {
                this.fSubGroups = SchemaGrammar.resize(this.fSubGroups, this.fSubGroupCount + 16);
            }
            this.fSubGroups[this.fSubGroupCount++] = decl;
        }
    }

    public final void addGlobalGroupDecl(XSGroupDecl decl) {
        this.fGlobalGroupDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalNotationDecl(XSNotationDecl decl) {
        this.fGlobalNotationDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalTypeDecl(XSTypeDecl decl) {
        this.fGlobalTypeDecls.put(decl.getTypeName(), decl);
    }

    public final void addIDConstraintDecl(XSElementDecl elmDecl, IdentityConstraint decl) {
        elmDecl.addIDConstaint(decl);
        this.fGlobalIDConstraintDecls.put(decl.getIdentityConstraintName(), (Object)decl);
    }

    public final XSAttributeDecl getGlobalAttributeDecl(String declName) {
        return (XSAttributeDecl)this.fGlobalAttrDecls.get(declName);
    }

    public final XSAttributeGroupDecl getGlobalAttributeGroupDecl(String declName) {
        return (XSAttributeGroupDecl)this.fGlobalAttrGrpDecls.get(declName);
    }

    public final XSElementDecl getGlobalElementDecl(String declName) {
        return (XSElementDecl)this.fGlobalElemDecls.get(declName);
    }

    public final XSGroupDecl getGlobalGroupDecl(String declName) {
        return (XSGroupDecl)this.fGlobalGroupDecls.get(declName);
    }

    public final XSNotationDecl getNotationDecl(String declName) {
        return (XSNotationDecl)this.fGlobalNotationDecls.get(declName);
    }

    public final XSTypeDecl getGlobalTypeDecl(String declName) {
        return (XSTypeDecl)this.fGlobalTypeDecls.get(declName);
    }

    public final IdentityConstraint getIDConstraintDecl(String declName) {
        return (IdentityConstraint)this.fGlobalIDConstraintDecls.get(declName);
    }

    public final void addComplexTypeDecl(XSComplexTypeDecl decl, SimpleLocator locator) {
        if (this.fCTCount == this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount + 16);
            this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount + 16);
        }
        this.fCTLocators[this.fCTCount] = locator;
        this.fComplexTypeDecls[this.fCTCount++] = decl;
    }

    public final void addRedefinedGroupDecl(XSGroupDecl derived, XSGroupDecl base, SimpleLocator locator) {
        if (this.fRGCount == this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount << 1);
            this.fRGLocators = SchemaGrammar.resize(this.fRGLocators, this.fRGCount);
        }
        this.fRGLocators[this.fCTCount / 2] = locator;
        this.fRedefinedGroupDecls[this.fRGCount++] = derived;
        this.fRedefinedGroupDecls[this.fRGCount++] = base;
    }

    final XSComplexTypeDecl[] getUncheckedComplexTypeDecls() {
        if (this.fCTCount < this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
            this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount);
        }
        return this.fComplexTypeDecls;
    }

    final SimpleLocator[] getUncheckedCTLocators() {
        if (this.fCTCount < this.fCTLocators.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
            this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount);
        }
        return this.fCTLocators;
    }

    final XSGroupDecl[] getRedefinedGroupDecls() {
        if (this.fRGCount < this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount);
            this.fRGLocators = SchemaGrammar.resize(this.fRGLocators, this.fRGCount / 2);
        }
        return this.fRedefinedGroupDecls;
    }

    final SimpleLocator[] getRGLocators() {
        if (this.fRGCount < this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount);
            this.fRGLocators = SchemaGrammar.resize(this.fRGLocators, this.fRGCount / 2);
        }
        return this.fRGLocators;
    }

    final void setUncheckedTypeNum(int newSize) {
        this.fCTCount = newSize;
        this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
        this.fCTLocators = SchemaGrammar.resize(this.fCTLocators, this.fCTCount);
    }

    final XSElementDecl[] getSubstitutionGroups() {
        if (this.fSubGroupCount < this.fSubGroups.length) {
            this.fSubGroups = SchemaGrammar.resize(this.fSubGroups, this.fSubGroupCount);
        }
        return this.fSubGroups;
    }

    static final XSComplexTypeDecl[] resize(XSComplexTypeDecl[] oldArray, int newSize) {
        XSComplexTypeDecl[] newArray = new XSComplexTypeDecl[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    static final XSGroupDecl[] resize(XSGroupDecl[] oldArray, int newSize) {
        XSGroupDecl[] newArray = new XSGroupDecl[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    static final XSElementDecl[] resize(XSElementDecl[] oldArray, int newSize) {
        XSElementDecl[] newArray = new XSElementDecl[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    static final SimpleLocator[] resize(SimpleLocator[] oldArray, int newSize) {
        SimpleLocator[] newArray = new SimpleLocator[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    static {
        SchemaGrammar.fAnyType.fName = "anyType";
        SchemaGrammar.fAnyType.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
        SchemaGrammar.fAnyType.fBaseType = fAnyType;
        SchemaGrammar.fAnyType.fDerivedBy = (short)2;
        SchemaGrammar.fAnyType.fContentType = (short)2;
        XSWildcardDecl wildcard = new XSWildcardDecl();
        XSParticleDecl particle = new XSParticleDecl();
        particle.fMinOccurs = 0;
        particle.fMaxOccurs = -1;
        particle.fType = (short)2;
        particle.fValue = wildcard;
        SchemaGrammar.fAnyType.fParticle = particle;
        SchemaGrammar.fAnyType.fAttrGrp.fAttributeWC = wildcard;
        SG_SchemaNS = new SchemaGrammar(null);
        fAnySimpleType = (XSSimpleType)SG_SchemaNS.getGlobalTypeDecl("anySimpleType");
    }
}

