/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.output.OutputBase;
import org.apache.xalan.xsltc.runtime.output.SAXOutput;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXXMLOutput
extends SAXOutput {
    private static final char[] BEGCDATA = "<![CDATA[".toCharArray();
    private static final char[] ENDCDATA = "]]>".toCharArray();
    private static final char[] CNTCDATA = "]]]]><![CDATA[>".toCharArray();

    public SAXXMLOutput(ContentHandler handler, String encoding) throws IOException {
        super(handler, encoding);
        this.initCDATA();
        this.initNamespaces();
    }

    public SAXXMLOutput(ContentHandler handler, LexicalHandler lex, String encoding) throws IOException {
        super(handler, lex, encoding);
        this.initCDATA();
        this.initNamespaces();
    }

    public void endDocument() throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            } else if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            this._saxHandler.endDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void startElement(String elementName) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            } else if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            if (this._firstElement) {
                if (this._doctypeSystem != null) {
                    this._lexHandler.startDTD(elementName, this._doctypePublic, this._doctypeSystem);
                }
                this._firstElement = false;
            }
            ++this._depth;
            this._elementName = elementName;
            this._attributes.clear();
            this._startTagOpen = true;
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void attribute(String name, String value) throws TransletException {
        int index;
        String patchedName = OutputBase.patchName(name);
        String localName = OutputBase.getLocalName(patchedName);
        String uri = this.getNamespaceURI(patchedName, false);
        int n = index = localName == null ? this._attributes.getIndex(name) : this._attributes.getIndex(uri, localName);
        if (!this._startTagOpen) {
            BasisLibrary.runTimeError(10, patchedName);
        }
        if (index >= 0) {
            this._attributes.setAttribute(index, uri, localName, patchedName, "CDATA", value);
        } else {
            this._attributes.addAttribute(uri, localName, patchedName, "CDATA", value);
        }
    }

    public void characters(char[] ch, int off, int len) throws TransletException {
        try {
            Integer I;
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            if ((I = (Integer)this._cdataStack.peek()) == this._depth && !this._cdataTagOpen) {
                this.startCDATA(ch, off, len);
            } else {
                this._saxHandler.characters(ch, off, len);
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void endElement(String elementName) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            } else if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            this._saxHandler.endElement(this.getNamespaceURI(elementName, true), OutputBase.getLocalName(elementName), elementName);
            this.popNamespaces();
            if ((Integer)this._cdataStack.peek() == this._depth) {
                this._cdataStack.pop();
            }
            --this._depth;
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void namespace(String prefix, String uri) throws TransletException {
        if (this._startTagOpen) {
            this.pushNamespace(prefix, uri);
        } else {
            if (prefix == "" && uri == "") {
                return;
            }
            BasisLibrary.runTimeError(11, prefix, uri);
        }
    }

    public void processingInstruction(String target, String data) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            } else if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            this._saxHandler.processingInstruction(target, data);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    protected boolean pushNamespace(String prefix, String uri) {
        try {
            if (super.pushNamespace(prefix, uri)) {
                this._saxHandler.startPrefixMapping(prefix, uri);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    protected boolean popNamespace(String prefix) {
        try {
            if (super.popNamespace(prefix)) {
                this._saxHandler.endPrefixMapping(prefix);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    protected void closeStartTag() throws TransletException {
        try {
            this._startTagOpen = false;
            String localName = OutputBase.getLocalName(this._elementName);
            String uri = this.getNamespaceURI(this._elementName, true);
            this._saxHandler.startElement(uri, localName, this._elementName, this._attributes);
            if (this._cdata != null) {
                StringBuffer expandedName;
                StringBuffer stringBuffer = expandedName = uri == "" ? new StringBuffer(this._elementName) : new StringBuffer(uri).append(':').append(localName);
                if (this._cdata.containsKey(expandedName.toString())) {
                    this._cdataStack.push(new Integer(this._depth));
                }
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    protected void closeCDATA() throws SAXException {
        this._saxHandler.characters(ENDCDATA, 0, ENDCDATA.length);
        this._cdataTagOpen = false;
    }

    private void startCDATA(char[] ch, int off, int len) throws SAXException {
        int limit = off + len;
        int offset = off;
        this._saxHandler.characters(BEGCDATA, 0, BEGCDATA.length);
        int i = offset;
        while (i < limit - 2) {
            if (ch[i] == ']' && ch[i + 1] == ']' && ch[i + 2] == '>') {
                this._saxHandler.characters(ch, offset, i - offset);
                this._saxHandler.characters(CNTCDATA, 0, CNTCDATA.length);
                offset = i + 3;
                i += 2;
            }
            ++i;
        }
        if (offset < limit) {
            this._saxHandler.characters(ch, offset, limit - offset);
        }
        this._cdataTagOpen = true;
    }
}

