/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.util.Stack;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.Constants;
import org.apache.xalan.xsltc.runtime.Hashtable;

public abstract class OutputBase
implements TransletOutputHandler,
Constants {
    protected String _doctypeSystem = null;
    protected String _doctypePublic = null;
    protected int _depth = 0;
    protected Hashtable _namespaces;
    protected Stack _nodeStack;
    protected Stack _prefixStack;
    protected Hashtable _cdata = null;
    protected Stack _cdataStack;
    protected boolean _cdataTagOpen = false;
    protected boolean _startTagOpen = false;
    protected boolean _firstElement = true;

    protected void initCDATA() {
        this._cdataStack = new Stack();
        this._cdataStack.push(new Integer(-1));
    }

    protected void initNamespaces() {
        this._namespaces = new Hashtable();
        this._nodeStack = new Stack();
        this._prefixStack = new Stack();
        Stack<String> stack = new Stack<String>();
        this._namespaces.put("", stack);
        stack.push("");
        this._prefixStack.push("");
        stack = new Stack();
        this._namespaces.put("xml", stack);
        stack.push("http://www.w3.org/XML/1998/namespace");
        this._prefixStack.push("xml");
        this._nodeStack.push(new Integer(-1));
        this._depth = 0;
    }

    public void setDoctype(String system, String pub) {
        this._doctypeSystem = system;
        this._doctypePublic = pub;
    }

    public void setCdataElements(Hashtable elements) {
        this._cdata = elements;
    }

    protected static String patchName(String qname) throws TransletException {
        int firstColon;
        int lastColon = qname.lastIndexOf(58);
        if (lastColon > 0 && (firstColon = qname.indexOf(58)) != lastColon) {
            return qname.substring(0, firstColon) + qname.substring(lastColon);
        }
        return qname;
    }

    protected boolean pushNamespace(String prefix, String uri) {
        if (prefix.startsWith("xml")) {
            return false;
        }
        Stack<String> stack = (Stack<String>)this._namespaces.get(prefix);
        if (stack == null) {
            stack = new Stack<String>();
            this._namespaces.put(prefix, stack);
        }
        if (!stack.empty() && uri.equals(stack.peek())) {
            return false;
        }
        stack.push(uri);
        this._prefixStack.push(prefix);
        this._nodeStack.push(new Integer(this._depth));
        return true;
    }

    protected boolean popNamespace(String prefix) {
        if (prefix.startsWith("xml")) {
            return false;
        }
        Stack stack = (Stack)this._namespaces.get(prefix);
        if (stack != null) {
            stack.pop();
            return true;
        }
        return false;
    }

    protected void popNamespaces() {
        while (!this._nodeStack.isEmpty()) {
            Integer i = (Integer)this._nodeStack.peek();
            if (i != this._depth) {
                return;
            }
            this._nodeStack.pop();
            this.popNamespace((String)this._prefixStack.pop());
        }
        return;
    }

    protected String lookupNamespace(String prefix) {
        Stack stack = (Stack)this._namespaces.get(prefix);
        return stack != null && !stack.isEmpty() ? (String)stack.peek() : null;
    }

    protected static String getLocalName(String qname) {
        int col = qname.lastIndexOf(58);
        return col > 0 ? qname.substring(col + 1) : qname;
    }

    protected String getNamespaceURI(String qname, boolean isElement) throws TransletException {
        String prefix;
        String uri = "";
        int col = qname.lastIndexOf(58);
        String string = prefix = col > 0 ? qname.substring(0, col) : "";
        if ((prefix != "" || isElement) && (uri = this.lookupNamespace(prefix)) == null && !prefix.equals("xmlns")) {
            BasisLibrary.runTimeError(12, qname.substring(0, col));
        }
        return uri;
    }

    public void namespace(String prefix, String uri) throws TransletException {
    }

    public void setType(int type) {
    }

    public void setIndent(boolean indent) {
    }

    public void omitHeader(boolean value) {
    }

    public boolean setEscaping(boolean escape) throws TransletException {
        return true;
    }

    public void setMediaType(String mediaType) {
    }

    public void setStandalone(String standalone) {
    }

    public void setVersion(String version2) {
    }

    public void close() {
    }

    public abstract void processingInstruction(String var1, String var2) throws TransletException;

    public abstract void comment(String var1) throws TransletException;

    public abstract void attribute(String var1, String var2) throws TransletException;

    public abstract void characters(char[] var1, int var2, int var3) throws TransletException;

    public abstract void characters(String var1) throws TransletException;

    public abstract void endElement(String var1) throws TransletException;

    public abstract void startElement(String var1) throws TransletException;

    public abstract void endDocument() throws TransletException;

    public abstract void startDocument() throws TransletException;
}

