/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.xmldocument;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public final class Document {
    private File file;
    private boolean elementNamesCaseInsensitive = true;

    public Document(File file) {
        Assert.errorParam(file == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "file"));
        Assert.errorParam(!file.exists(), new ResourceTextPointer((Object)ResourceTextIdentifiers.FILE_DOES_NOT_EXIST, file.getPath()));
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public boolean elementNamesCaseInsensitive() {
        return this.elementNamesCaseInsensitive;
    }

    private Document load() {
        XmlElement xmlElement = null;
        try {
            xmlElement = XmlElementFactory.load(this.file);
        }
        catch (UnexpectedErrorException unexpectedErrorException) {
            throw unexpectedErrorException;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return this;
    }
}

