/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.xmldocument;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.xml.XmlElement;
import com.jronimo.xmldocument.Constants;
import com.jronimo.xmldocument.Element;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement
implements Element {
    protected Constants.ElementType elementType;
    protected XmlElement xmlElement;
    protected String name;
    protected Boolean isParentElement;
    protected String text;
    protected Set<Element> elements = CollectionUtils.getOrderedSet(5);

    public AbstractElement(Constants.ElementType elementType, XmlElement xmlElement) {
        Assert.errorParam(elementType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "elementType"));
        Assert.errorParam(xmlElement == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "xmlElement"));
        this.elementType = elementType;
        this.xmlElement = xmlElement;
        this.init();
    }

    public AbstractElement(Constants.ElementType elementType, String string, boolean bl) {
        Assert.errorParam(elementType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "elementType"));
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "name"));
        this.elementType = elementType;
        this.name = string;
        this.isParentElement = bl;
        this.init();
    }

    private void init() {
    }

    @Override
    public Constants.ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public XmlElement getXmlElement() {
        return this.xmlElement;
    }

    @Override
    public boolean isParentElement() {
        return this.isParentElement;
    }

    public boolean isMetaElement() {
        return this.elementType == Constants.ElementType.META_ELEMENT;
    }

    @Override
    public boolean isTemplateRoot() {
        return this.elementType == Constants.ElementType.TEMPLATE_ROOT;
    }

    @Override
    public boolean isTemplateElement() {
        return this.elementType == Constants.ElementType.TEMPLATE_ELEMENT;
    }

    public boolean isSubTemplateRoot() {
        return this.elementType == Constants.ElementType.SUB_TEMPLATE_ROOT;
    }

    public boolean isSubTemplateElement() {
        return this.elementType == Constants.ElementType.SUB_TEMPLATE_ELEMENT;
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setText(String string) {
    }

    @Override
    public String getText() {
        return this.xmlElement.getText();
    }

    private Element getElement(String string) {
        Element element = null;
        for (Element element2 : this.elements) {
            if (!element2.getName().equals(string)) continue;
        }
        return element;
    }

    @Override
    public boolean hasElement(String string) {
        return true;
    }

    @Override
    public boolean addElement(String string, boolean bl) {
        boolean bl2 = false;
        return bl2;
    }

    @Override
    public boolean removeElement(String string) {
        boolean bl = false;
        bl = this.elements.remove(this.getElement(string));
        return bl;
    }

    @Override
    public Set<Element> getElements() {
        return CollectionUtils.copyOrderedSet(this.elements);
    }
}

