/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.xml;

import com.jronimo.collections.NullFreeImmutableList;
import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.collection.types.nullfree.NullFreeImmutableCollection;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlException;
import java.io.StringWriter;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static final Logger logger = Logger.getLogger(XmlUtils.class);

    private XmlUtils() {
    }

    public static NullFreeImmutableCollection<String> getTextFromElements(com.jronimo.collections.collection.types.Collection<XmlElement> collection) {
        NullFreeImmutableList<String> nullFreeImmutableList = null;
        NullFreeMutableList<String> nullFreeMutableList = null;
        nullFreeMutableList = new NullFreeMutableList<String>(collection.size());
        for (XmlElement xmlElement : collection) {
            nullFreeMutableList.add(xmlElement.getText());
        }
        nullFreeImmutableList = new NullFreeImmutableList<String>((Collection<String>)nullFreeMutableList);
        return nullFreeImmutableList;
    }

    static void throwException(Class clazz, String string) {
        throw (RuntimeException)Methods.instantiateViaReflection(clazz, String.class, string);
    }

    static String nodeToString(Node node, boolean bl) {
        String string = null;
        StringWriter stringWriter = null;
        DOMSource dOMSource = null;
        StreamResult streamResult = null;
        TransformerFactory transformerFactory = null;
        Transformer transformer = null;
        int n = 0;
        try {
            stringWriter = new StringWriter();
            dOMSource = new DOMSource(node);
            streamResult = new StreamResult(stringWriter);
            transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            if (bl) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.transform(dOMSource, streamResult);
            string = stringWriter.toString();
            if (string.startsWith("<?")) {
                n = string.indexOf("?>");
                string = string.substring(n + 2).trim();
            }
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
        return string;
    }

    static boolean hasCDataSection(Element element) {
        return XmlUtils.getCDataNode(element) != null;
    }

    static Node getCDataNode(Element element) {
        Node node = null;
        for (Node node2 : XmlUtils.getChildNodes(element)) {
            if (!(node2 instanceof CDATASection)) continue;
            node = node2;
            break;
        }
        return node;
    }

    static NullFreeMutableList<Node> getChildNodes(Node node) {
        NullFreeMutableList<Node> nullFreeMutableList = null;
        NodeList nodeList = null;
        Node node2 = null;
        nodeList = node.getChildNodes();
        nullFreeMutableList = new NullFreeMutableList<Node>(nodeList.getLength());
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node2 = nodeList.item(i);
            nullFreeMutableList.add(node2);
        }
        return nullFreeMutableList;
    }

    static NullFreeMutableList<Element> getChildElements(Node node) {
        NullFreeMutableList<Element> nullFreeMutableList = null;
        NodeList nodeList = null;
        Node node2 = null;
        nodeList = node.getChildNodes();
        nullFreeMutableList = new NullFreeMutableList<Element>(nodeList.getLength());
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            nullFreeMutableList.add((Element)node2);
        }
        return nullFreeMutableList;
    }

    static NullFreeMutableList<Attr> getAttributes(Element element) {
        NullFreeMutableList<Attr> nullFreeMutableList = null;
        NamedNodeMap namedNodeMap = null;
        Node node = null;
        namedNodeMap = element.getAttributes();
        nullFreeMutableList = new NullFreeMutableList<Attr>(namedNodeMap.getLength());
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            node = namedNodeMap.item(i);
            nullFreeMutableList.add(element.getAttributeNode(node.getNodeName()));
        }
        return nullFreeMutableList;
    }

    static Attr getAttribute(Element element, String string) {
        Attr attr = null;
        NamedNodeMap namedNodeMap = null;
        Node node = null;
        namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            node = namedNodeMap.item(i);
            if (!node.getNodeName().equals(string)) continue;
            attr = element.getAttributeNode(node.getNodeName());
        }
        return attr;
    }
}

