/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.xml;

import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.xml.ResourceTextIdentifiers;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementImpl;
import com.jronimo.xml.XmlException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class XmlElementFactory {
    private static final Logger logger = Logger.getLogger(XmlElementFactory.class);

    public static XmlElement load(URL uRL) {
        return XmlElementFactory.load(uRL, XmlException.class);
    }

    public static XmlElement load(URL uRL, Class clazz) {
        return XmlElementFactory.load(XmlElementFactory.getInputStream(uRL), true, clazz);
    }

    public static XmlElement load(File file) {
        return XmlElementFactory.load(file, XmlException.class);
    }

    public static XmlElement load(File file, Class clazz) {
        return XmlElementFactory.load(XmlElementFactory.getInputStream(file), true, clazz);
    }

    public static XmlElement load(byte[] byArray) {
        return XmlElementFactory.load(byArray, XmlException.class);
    }

    public static XmlElement load(byte[] byArray, Class clazz) {
        return XmlElementFactory.load(XmlElementFactory.getInputStream(byArray), true, clazz);
    }

    public static XmlElement load(String string) {
        return XmlElementFactory.load(string, XmlException.class);
    }

    public static XmlElement load(String string, Class clazz) {
        return XmlElementFactory.load(XmlElementFactory.getInputStream(string.getBytes()), true, clazz);
    }

    public static XmlElement load(Class clazz, String string) {
        return XmlElementFactory.load(clazz, string, XmlException.class);
    }

    public static XmlElement load(Class clazz, String string, Class clazz2) {
        return XmlElementFactory.load(Methods.getClassPathResourceAsStream(clazz, string), true, clazz2);
    }

    public static XmlElement load(InputStream inputStream) {
        return XmlElementFactory.load(inputStream, XmlException.class);
    }

    public static XmlElement load(InputStream inputStream, Class clazz) {
        return XmlElementFactory.load(inputStream, false, clazz);
    }

    private static XmlElement load(InputStream inputStream, boolean bl, Class clazz) {
        XmlElementImpl xmlElementImpl = null;
        Document document = null;
        Assert.errorParam(inputStream == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "inputStream"));
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "exceptionClass"));
        Assert.errorParam(Methods.hasSuperClass(clazz, RuntimeException.class), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_SUBCLASS_RUNTIME_EXCEPTION, "exceptionClass"));
        document = XmlElementFactory.getDocument(inputStream, bl);
        xmlElementImpl = new XmlElementImpl(document, clazz, document.getFirstChild());
        return xmlElementImpl;
    }

    public static XmlElement create(String string) {
        XmlElementImpl xmlElementImpl = null;
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.appendChild(document.createElement(string));
            xmlElementImpl = new XmlElementImpl(document, XmlException.class, document.getFirstChild());
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
        return xmlElementImpl;
    }

    public static XmlElement create(String string, XmlElement xmlElement) {
        XmlElement xmlElement2 = null;
        xmlElement2 = XmlElementFactory.create(string);
        xmlElement2.addElement(xmlElement);
        return xmlElement2;
    }

    private static Document getDocument(InputStream inputStream, boolean bl) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
        finally {
            if (bl) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return document;
    }

    private static InputStream getInputStream(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = XmlElementFactory.getInputStream(new File(uRL.toURI()));
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
        return inputStream;
    }

    private static InputStream getInputStream(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
        return fileInputStream;
    }

    private static InputStream getInputStream(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
        return byteArrayInputStream;
    }
}

