/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.util.Logger;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.webdata.objectmodel.TextElement;
import com.jronimo.webdata.objectmodel.TextGroup;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TextGroups {
    private static final Logger logger = Logger.getLogger(TextGroups.class);
    private System system;
    private Map<Long, TextElement> index = new HashMap<Long, TextElement>(1000);
    private Map<String, TextGroup> textGroups;

    private TextGroups(System system) {
        this.system = system;
    }

    public System getSystem() {
        return this.system;
    }

    public TextGroup getTextGroup(String string) {
        return this.textGroups.get(string);
    }

    public TextElement getTextElement(String string) {
        TextElement textElement = null;
        int n = 0;
        TextGroup textGroup = null;
        n = string.lastIndexOf(".");
        textGroup = this.getTextGroup(string.substring(0, n));
        textElement = textGroup.getTextElement(string.substring(n + 1));
        return textElement;
    }

    public TextElement getTextElement(long l) {
        return this.index.get(l);
    }

    static TextGroups createInstance(System system, File file) {
        TextGroups textGroups = null;
        File[] fileArray = null;
        TextGroup textGroup = null;
        fileArray = file.listFiles();
        textGroups = new TextGroups(system);
        textGroups.textGroups = CollectionUtils.getOrderedMap(new HashMap(fileArray.length));
        for (File file2 : fileArray) {
            if (!file2.isFile()) continue;
            textGroup = TextGroup.createInstance(XmlElementFactory.load(file2));
            textGroups.textGroups.put(textGroup.getIdentifier(), textGroup);
            for (TextElement textElement : textGroup.getTextElements().values()) {
                textGroups.index.put(textElement.getId(), textElement);
            }
        }
        return textGroups;
    }
}

