/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.util.Logger;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.core.SystemFieldType;
import com.jronimo.webdata.core.TypeDefinition;
import com.jronimo.webdata.objectmodel.Entity;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;

public class SystemField {
    private static final Logger logger = Logger.getLogger(SystemField.class);
    private System system;
    private Entity entity;
    private Constants.SystemFieldIdentifier identifier;
    private String name;
    private String persistenceName;
    private TypeDefinition typeDefinition;

    private SystemField(System system) {
        this.system = system;
    }

    public System getSystem() {
        return this.system;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Constants.SystemFieldIdentifier getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistenceName() {
        return this.persistenceName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isRecordStatusField() {
        return this.identifier.isRecordStatus();
    }

    public boolean isRecordVersionField() {
        return this.identifier.isRecordVersion();
    }

    public boolean isCreateUserIdField() {
        return this.identifier.isAuditCreateUserId();
    }

    public boolean isCreateUsernameField() {
        return this.identifier.isAuditCreateUsername();
    }

    public boolean isCreateTimestampField() {
        return this.identifier.isAuditCreateTimestamp();
    }

    public boolean isUpdateUserIdField() {
        return this.identifier.isAuditUpdateUserId();
    }

    public boolean isUpdateUsernameField() {
        return this.identifier.isAuditUpdateUsername();
    }

    public boolean isUpdateTimestampField() {
        return this.identifier.isAuditUpdateTimestamp();
    }

    SystemField cloneInstance(Entity entity, XmlElement xmlElement) {
        SystemField systemField = null;
        systemField = new SystemField(this.system);
        systemField.entity = entity;
        systemField.identifier = this.identifier;
        systemField.name = this.name;
        systemField.persistenceName = this.persistenceName;
        systemField.typeDefinition = this.typeDefinition;
        if (xmlElement != null) {
            systemField.name = xmlElement.getOptionalText("name", systemField.name);
            systemField.persistenceName = xmlElement.getOptionalText("persistence-name", systemField.persistenceName);
            if (xmlElement.hasElement("data-type-name")) {
                systemField.typeDefinition = SystemFieldType.get(systemField.identifier).getTypeDefinition(xmlElement.getText("data-type-name"));
            } else if (xmlElement.hasElement("type")) {
                systemField.typeDefinition = TypeDefinition.createInstance(xmlElement.getElement("type"));
            }
        }
        return systemField;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    static SystemField createInstance(System system, XmlElement xmlElement) {
        SystemField systemField = null;
        Constants.SystemFieldIdentifier systemFieldIdentifier = null;
        SystemFieldType systemFieldType = null;
        systemFieldIdentifier = Constants.SystemFieldIdentifier.get(xmlElement.getText("identifier"));
        systemFieldType = SystemFieldType.get(systemFieldIdentifier);
        systemField = new SystemField(system);
        systemField.identifier = systemFieldIdentifier;
        systemField.name = xmlElement.getOptionalText("name", systemFieldType.getDefaultFieldName());
        systemField.persistenceName = xmlElement.getOptionalText("persistence-", systemFieldType.getDefaultPersistenceName());
        systemField.typeDefinition = xmlElement.hasElement("data-type-name") ? systemFieldType.getTypeDefinition(xmlElement.getText("data-type-name")) : (xmlElement.hasElement("type") ? TypeDefinition.createInstance(xmlElement.getElement("type")) : systemFieldType.getDefaultTypeDefinition());
        return systemField;
    }
}

