/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.NullFreeImmutableList;
import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlUtils;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldConstraints {
    private static final Logger logger = Logger.getLogger(FieldConstraints.class);
    private System system;
    private String fieldName;
    private boolean hasNotNullConstraint;
    private NullFreeImmutableSet<Constraint> constraints;

    private FieldConstraints(System system, String string) {
        this.system = system;
        this.fieldName = string;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public NullFreeImmutableSet<Constraint> getConstraints() {
        return this.constraints;
    }

    public boolean hasNotNullConstraint() {
        return this.hasNotNullConstraint;
    }

    public int hashCode() {
        return this.fieldName.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        FieldConstraints fieldConstraints = null;
        if (object instanceof FieldConstraints) {
            fieldConstraints = (FieldConstraints)object;
            bl = fieldConstraints.fieldName.equals(this.fieldName);
        }
        return bl;
    }

    private Constraint getConstraintInstance(String string, NullFreeImmutableList<String> nullFreeImmutableList) {
        return new Constraint(string, nullFreeImmutableList);
    }

    public static FieldConstraints createInstance(System system, XmlElement xmlElement) {
        FieldConstraints fieldConstraints = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        NullFreeMutableSet<Constraint> nullFreeMutableSet = null;
        Constraint constraint = null;
        fieldConstraints = new FieldConstraints(system, xmlElement.getText("field-name"));
        nullFreeCollection = xmlElement.getOptionalElements("constraints/constraint");
        nullFreeMutableSet = new NullFreeMutableSet<Constraint>(nullFreeCollection.size());
        for (XmlElement xmlElement2 : nullFreeCollection) {
            constraint = FieldConstraints.createConstraintInstance(fieldConstraints, xmlElement2);
            if (constraint.isNotNullConstraint()) {
                fieldConstraints.hasNotNullConstraint = true;
            }
            nullFreeMutableSet.add(constraint);
        }
        fieldConstraints.constraints = new NullFreeImmutableSet(nullFreeMutableSet);
        return fieldConstraints;
    }

    private static Constraint createConstraintInstance(FieldConstraints fieldConstraints, XmlElement xmlElement) {
        Constraint constraint = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        NullFreeImmutableList<String> nullFreeImmutableList = null;
        nullFreeCollection = xmlElement.getOptionalElements("value");
        nullFreeImmutableList = new NullFreeImmutableList<String>((Collection<String>)XmlUtils.getTextFromElements(nullFreeCollection));
        constraint = fieldConstraints.getConstraintInstance(xmlElement.getText("name"), nullFreeImmutableList);
        return constraint;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Constraint {
        private String name;
        private NullFreeImmutableList<String> values;
        private NameFormat nameFormat;

        Constraint(String string, NullFreeImmutableList<String> nullFreeImmutableList) {
            this.name = string;
            this.values = nullFreeImmutableList;
            this.nameFormat = new NameFormat(string);
        }

        public FieldConstraints getFieldConstraints() {
            return FieldConstraints.this;
        }

        public String getName() {
            return this.name;
        }

        public NameFormat getNameFormat() {
            return this.nameFormat;
        }

        public NullFreeImmutableList<String> getValues() {
            return this.values;
        }

        public boolean isNotNullConstraint() {
            return this.nameFormat.getCamelCase().equals("NotNull");
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            Constraint constraint = null;
            if (object instanceof Constraint) {
                constraint = (Constraint)object;
                bl = constraint.name.equals(this.name);
            }
            return bl;
        }
    }
}

