/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.util.Logger;
import com.jronimo.webdata.core.CodeType;
import com.jronimo.webdata.core.DataType;
import com.jronimo.webdata.core.DatabaseType;
import com.jronimo.webdata.core.TypeDefinition;
import com.jronimo.webdata.objectmodel.DefaultValue;
import com.jronimo.webdata.objectmodel.Entity;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;

public class Field {
    private static final Logger logger = Logger.getLogger(Field.class);
    private System system;
    private Entity entity;
    private Long id;
    private String name;
    private String persistenceName;
    private TypeDefinition typeDefinition;
    private DefaultValue defaultValue;
    private String comments;
    private Long displayTextId;
    private String displayTextIdentifier;

    private Field(System system, Entity entity) {
        this.system = system;
        this.entity = entity;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getDisplayTextId() {
        return this.displayTextId;
    }

    public String getDisplayTextIdentifier() {
        return this.displayTextIdentifier;
    }

    public String getPersistenceName() {
        return this.persistenceName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean hasDefaultValue() {
        return !this.defaultValue.isNone();
    }

    public DefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    public String getComments() {
        return this.comments;
    }

    public DataType getDataType() {
        return this.typeDefinition.getDataType();
    }

    public CodeType getCodeType() {
        return this.typeDefinition.getCodeType();
    }

    public DatabaseType getDatabaseType() {
        return this.typeDefinition.getDatabaseType();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Field field = null;
        if (object instanceof Field) {
            field = (Field)object;
            bl = field.id == this.id;
        }
        return bl;
    }

    public static Field createInstance(System system, Entity entity, XmlElement xmlElement) {
        Field field = null;
        field = new Field(system, entity);
        field.id = xmlElement.getLong("id");
        field.name = xmlElement.getText("name");
        field.persistenceName = xmlElement.getText("persistence-name");
        field.typeDefinition = TypeDefinition.createInstance(xmlElement.getElement("type"));
        field.defaultValue = new DefaultValue(field.typeDefinition, xmlElement.getText("default-value"));
        field.comments = xmlElement.getOptionalText("comments", "");
        field.displayTextIdentifier = "entity." + entity.getName() + ".fields." + field.name;
        field.displayTextId = system.getTextGroups().getTextElement(field.displayTextIdentifier).getId();
        return field;
    }
}

