/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.webdata.objectmodel.ConstraintSet;
import com.jronimo.webdata.objectmodel.ConstraintSets;
import com.jronimo.webdata.objectmodel.Field;
import com.jronimo.webdata.objectmodel.Keys;
import com.jronimo.webdata.objectmodel.PrimaryKey;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.webdata.objectmodel.SystemFields;
import com.jronimo.xml.XmlElement;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
implements Comparable<Entity> {
    private static final Logger logger = Logger.getLogger(Entity.class);
    private System system;
    private Long id;
    private String name;
    private String persistenceName;
    private String comments;
    private Long displayTextId;
    private Long displayTextPluralId;
    private String displayTextIdentifier;
    private String displayTextPluralIdentifier;
    private Map<String, Field> fields;
    private SystemFields systemFields;
    private PrimaryKey primaryKey;
    private Keys keys;
    private ConstraintSets constraintSets;

    private Entity(System system, Long l, String string, String string2, String string3) {
        this.system = system;
        this.id = l;
        this.name = string;
        this.persistenceName = string2;
        this.comments = string3;
    }

    public System getSystem() {
        return this.system;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistenceName() {
        return this.persistenceName;
    }

    public Long getDisplayTextId() {
        return this.displayTextId;
    }

    public Long getDisplayTextPluralId() {
        return this.displayTextPluralId;
    }

    public String getDisplayTextIdentifier() {
        return this.displayTextIdentifier;
    }

    public String getDisplayTextPluralIdentifier() {
        return this.displayTextPluralIdentifier;
    }

    public String getComments() {
        return this.comments;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public boolean hasField(String string) {
        return this.fields.get(string) != null;
    }

    public Field getField(String string) {
        return this.fields.get(string);
    }

    public SystemFields getSystemFields() {
        return this.systemFields;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Keys getKeys() {
        return this.keys;
    }

    public ConstraintSets getConstraintSets() {
        return this.constraintSets;
    }

    public ConstraintSet getConstraintSet(String string) {
        return this.constraintSets.get(string);
    }

    @Override
    public int compareTo(Entity entity) {
        return this.name.compareTo(entity.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Entity entity = null;
        if (object instanceof Entity) {
            entity = (Entity)object;
            bl = entity.name.equals(this.name);
        }
        return bl;
    }

    static Entity createInstance(System system, XmlElement xmlElement) {
        Entity entity = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        Field field = null;
        entity = new Entity(system, xmlElement.getLong("id"), xmlElement.getText("name"), xmlElement.getText("persistence-name"), xmlElement.getOptionalText("comments", ""));
        entity.displayTextIdentifier = "entity." + entity.name + ".DisplayText";
        entity.displayTextId = system.getTextGroups().getTextElement(entity.displayTextIdentifier).getId();
        entity.displayTextPluralIdentifier = entity.displayTextIdentifier + "Plural";
        entity.displayTextPluralId = system.getTextGroups().getTextElement(entity.displayTextPluralIdentifier).getId();
        nullFreeCollection = xmlElement.getOptionalElements("fields/field");
        entity.fields = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            field = Field.createInstance(system, entity, xmlElement2);
            entity.fields.put(field.getName(), field);
        }
        entity.systemFields = SystemFields.createInstance(system, entity, xmlElement.getElement("system-field-exclusions"), xmlElement.getElement("system-field-additions"), xmlElement.getElement("system-field-amendments"));
        entity.primaryKey = PrimaryKey.createInstance(system, xmlElement.getElement("primary-key"));
        entity.keys = Keys.createInstance(system, xmlElement.getElement("keys"));
        entity.constraintSets = ConstraintSets.createInstance(system, xmlElement.getElement("constraint-sets"));
        return entity;
    }
}

