/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.webdata.objectmodel.ConstraintSet;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;
import java.util.HashMap;
import java.util.Map;

public class ConstraintSets {
    private static final Logger logger = Logger.getLogger(ConstraintSets.class);
    private System system;
    private ConstraintSet defaultConstraintSet;
    private Map<String, ConstraintSet> members;

    private ConstraintSets(System system) {
        this.system = system;
    }

    public System getSystem() {
        return this.system;
    }

    public ConstraintSet get(String string) {
        return this.members.get(string);
    }

    public ConstraintSet getDefault() {
        return this.defaultConstraintSet;
    }

    static ConstraintSets createInstance(System system, XmlElement xmlElement) {
        ConstraintSets constraintSets = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        ConstraintSet constraintSet = null;
        constraintSets = new ConstraintSets(system);
        nullFreeCollection = xmlElement.getElements("constraint-set");
        constraintSets.members = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            constraintSet = ConstraintSet.createInstance(system, xmlElement2);
            if (constraintSet.isDefault()) {
                constraintSets.defaultConstraintSet = constraintSet;
            }
            constraintSets.members.put(constraintSet.getName(), constraintSet);
        }
        return constraintSets;
    }
}

