/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine.originalhack;

import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class ReverseGenerateRefDataSkeleton {
    private static final Logger logger = Logger.getLogger(ReverseGenerateRefDataSkeleton.class);
    private File projectDirectory;
    private String refDataCategoryName;
    private File sourceFile;
    private File destinationFile;

    public ReverseGenerateRefDataSkeleton(File file, String string) {
        this.projectDirectory = file;
        this.refDataCategoryName = string;
        this.sourceFile = new File(file, "definition/B/ref-data/" + string + ".xml");
        this.destinationFile = new File(file, "definition/A/ref-data/" + string + ".xml");
    }

    public ReverseGenerateRefDataSkeleton execute() {
        boolean bl = true;
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        if (!this.sourceFile.exists()) {
            logger.warning("Source file not found. Cannot generate RefData skeleton: " + this.refDataCategoryName);
            bl = false;
        }
        if (this.destinationFile.exists()) {
            logger.warning("Destination exists. Cannot generate RefData skeleton: " + this.refDataCategoryName);
            bl = false;
        }
        if (bl) {
            xmlElement = XmlElementFactory.load("<ref-data></ref-data>");
            xmlElement2 = XmlElementFactory.load(this.sourceFile);
            for (XmlElement xmlElement3 : xmlElement2.getElements("category")) {
                this.processCategory(xmlElement, xmlElement3);
            }
            xmlElement.save(this.destinationFile);
        }
        return this;
    }

    private void processCategory(XmlElement xmlElement, XmlElement xmlElement2) {
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        xmlElement3 = xmlElement.addElement("category");
        xmlElement4 = xmlElement3.addElement("identifier");
        xmlElement4.setText(xmlElement2.getText("identifier"));
        xmlElement4 = xmlElement3.addElement("parent-identifier");
        xmlElement4.setText(xmlElement2.getOptionalText("parent-identifier"));
        if (xmlElement2.hasElement("properties")) {
            xmlElement4 = xmlElement3.addElement("properties");
            for (XmlElement xmlElement5 : xmlElement2.getOptionalElements("properties/property")) {
                this.processCategoryProperty(xmlElement4, xmlElement5);
            }
        }
        for (XmlElement xmlElement5 : xmlElement2.getOptionalElements("item")) {
            this.processItem(xmlElement3, xmlElement5);
        }
    }

    private void processCategoryProperty(XmlElement xmlElement, XmlElement xmlElement2) {
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        xmlElement3 = xmlElement.addElement("property");
        xmlElement4 = xmlElement3.addElement("name");
        xmlElement4.setText(xmlElement2.getText("name"));
        xmlElement4 = xmlElement3.addElement("type");
        xmlElement4.setText(xmlElement2.getText("type"));
    }

    private void processItem(XmlElement xmlElement, XmlElement xmlElement2) {
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        xmlElement3 = xmlElement.addElement("item");
        xmlElement4 = xmlElement3.addElement("identifier");
        xmlElement4.setText(xmlElement2.getText("identifier"));
        if (xmlElement2.hasElement("properties")) {
            xmlElement4 = xmlElement3.addElement("properties");
            for (XmlElement xmlElement5 : xmlElement2.getOptionalElements("properties/property")) {
                this.processItemProperty(xmlElement4, xmlElement5);
            }
        }
    }

    private void processItemProperty(XmlElement xmlElement, XmlElement xmlElement2) {
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        xmlElement3 = xmlElement.addElement("property");
        xmlElement4 = xmlElement3.addElement("name");
        xmlElement4.setText(xmlElement2.getText("name"));
        xmlElement4 = xmlElement3.addElement("value");
        xmlElement4.setText(xmlElement2.getText("value"));
    }
}

