/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine.generate;

import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.webdata.generate.xmlengine.Project;
import com.jronimo.webdata.generate.xmlengine.TextGroup;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class ProcessRelationships {
    private static final Logger logger = Logger.getLogger(ProcessRelationships.class);
    private Project project;
    private File sourceDirectory;
    private File destinationDirectory;
    private Collection<TextGroup> entityFieldsTextGroups = new NullFreeMutableSet<TextGroup>(2);

    public ProcessRelationships(Project project) {
        this.project = project;
        this.sourceDirectory = new File(project.getSourceDirectory(), "relationships");
        this.destinationDirectory = new File(project.getBuildDirectory(), "relationships");
    }

    public void execute() {
        for (File file : this.sourceDirectory.listFiles()) {
            this.processFile(file);
        }
    }

    private void processFile(File file) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        if (this.project.getProcessedFiles().isModified(file)) {
            logger.debug("Processing Relationship: " + FileMethods.extractNameFromFilename(file.getName()));
            xmlElement = XmlElementFactory.load(file);
            xmlElement2 = xmlElement.cloneElement();
            this.processRelationship(xmlElement2);
            this.saveRelationshipFiles(xmlElement2);
            this.project.getProcessedFiles().lodge(file);
        }
    }

    private void processRelationship(XmlElement xmlElement) {
        String string = null;
        String string2 = null;
        string = xmlElement.getText("referer");
        string2 = xmlElement.getText("referee");
        xmlElement.prependElement("name").setText(string + "_" + string2);
        if (xmlElement.hasElement("virtual-fields/referer-virtual-field")) {
            this.processVirtualField(string, xmlElement.getElement("virtual-fields/referer-virtual-field"));
        }
        if (xmlElement.hasElement("virtual-fields/referee-virtual-field")) {
            this.processVirtualField(string2, xmlElement.getElement("virtual-fields/referee-virtual-field"));
        }
    }

    private void processVirtualField(String string, XmlElement xmlElement) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TextGroup textGroup = null;
        string2 = xmlElement.getText("field-name");
        string3 = xmlElement.getOptionalText("display-text");
        if (xmlElement.hasElement("display-text")) {
            xmlElement.removeElement("display-text");
        }
        if (string3 == null) {
            string3 = new NameFormat(string2).getText();
        }
        string4 = "entity." + string + ".fields";
        string5 = string4 + "." + string2;
        textGroup = this.project.getTextGroups().getTextGroup(string4);
        textGroup.setTextElement(string5, string3);
        this.entityFieldsTextGroups.add(textGroup);
    }

    private void saveRelationshipFiles(XmlElement xmlElement) {
        String string = null;
        string = xmlElement.getText("name");
        xmlElement.save(new File(this.destinationDirectory, string + ".xml"));
        for (TextGroup textGroup : this.entityFieldsTextGroups) {
            textGroup.save();
        }
        this.entityFieldsTextGroups.clear();
    }
}

