/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine.generate;

import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.webdata.generate.xmlengine.Project;
import com.jronimo.webdata.generate.xmlengine.TextGroup;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class ProcessRefData {
    private static final Logger logger = Logger.getLogger(ProcessRefData.class);
    private Project project;
    private File sourceDirectory;
    private File destinationDirectory;
    private TextGroup refDataCategoriesTextGroup;
    private TextGroup refDataCategoryTextGroup;

    public ProcessRefData(Project project) {
        this.project = project;
        this.sourceDirectory = new File(project.getSourceDirectory(), "ref-data");
        this.destinationDirectory = new File(project.getBuildDirectory(), "ref-data");
        this.refDataCategoriesTextGroup = project.getTextGroups().getTextGroup("refdata.categories");
    }

    public void execute() {
        for (File file : this.sourceDirectory.listFiles()) {
            this.processFile(file);
        }
        this.refDataCategoriesTextGroup.save();
    }

    private void processFile(File file) {
        File file2 = null;
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        if (this.project.getProcessedFiles().isModified(file)) {
            logger.debug("Processing RefData: " + FileMethods.extractNameFromFilename(file.getName()));
            file2 = new File(this.destinationDirectory, file.getName());
            xmlElement = XmlElementFactory.load(file);
            xmlElement2 = XmlElementFactory.create("ref-data");
            for (XmlElement xmlElement3 : xmlElement.getElements("category")) {
                this.processCategory(xmlElement3, xmlElement2.addElement("category"));
            }
            xmlElement2.save(file2);
            this.project.getProcessedFiles().lodge(file);
        }
    }

    private void processCategory(XmlElement xmlElement, XmlElement xmlElement2) {
        String string = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        XmlElement xmlElement3 = null;
        string = xmlElement.getText("identifier");
        this.refDataCategoriesTextGroup.setTextElement(string, new NameFormat(string).getText());
        this.refDataCategoryTextGroup = this.project.getTextGroups().getTextGroup("refdata." + string + ".items");
        xmlElement2.addElement("id").setLong(this.project.retrieveProjectId("refdatacategory." + string));
        xmlElement2.addElement("identifier").setText(string);
        xmlElement2.addElement("parent-identifier").setText(xmlElement.getText("parent-identifier"));
        xmlElement2.addElement("status").setText("Active");
        nullFreeCollection = xmlElement.getOptionalElements("properties/property");
        if (!nullFreeCollection.isEmpty()) {
            xmlElement3 = xmlElement2.addElement("properties");
            for (XmlElement xmlElement4 : nullFreeCollection) {
                this.processCategoryProperty(xmlElement4, xmlElement3.addElement("property"));
            }
        }
        for (XmlElement xmlElement4 : xmlElement.getOptionalElements("item")) {
            this.processItem(string, xmlElement4, xmlElement2.addElement("item"));
        }
        this.refDataCategoryTextGroup.save();
    }

    private void processCategoryProperty(XmlElement xmlElement, XmlElement xmlElement2) {
        xmlElement2.addElement("name").setText(xmlElement.getText("name"));
        xmlElement2.addElement("type").setText(xmlElement.getText("type"));
    }

    private void processItem(String string, XmlElement xmlElement, XmlElement xmlElement2) {
        String string2 = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        XmlElement xmlElement3 = null;
        string2 = xmlElement.getText("identifier");
        this.refDataCategoryTextGroup.setTextElement(string2, new NameFormat(string2).getText());
        xmlElement2.addElement("id").setLong(this.project.retrieveRefDataItemId(string, string2));
        xmlElement2.addElement("identifier").setText(string2);
        xmlElement2.addElement("status").setText("Active");
        nullFreeCollection = xmlElement.getOptionalElements("properties/property");
        if (!nullFreeCollection.isEmpty()) {
            xmlElement3 = xmlElement2.addElement("properties");
            for (XmlElement xmlElement4 : nullFreeCollection) {
                this.processItemProperty(xmlElement4, xmlElement3.addElement("property"));
            }
        }
    }

    private void processItemProperty(XmlElement xmlElement, XmlElement xmlElement2) {
        xmlElement2.addElement("name").setText(xmlElement.getText("name"));
        xmlElement2.addElement("value").setText(xmlElement.getText("value"));
    }
}

