/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine.generate;

import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.util.StringWrapper;
import com.jronimo.webdata.core.DataType;
import com.jronimo.webdata.generate.xmlengine.Project;
import com.jronimo.webdata.generate.xmlengine.TextGroup;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class ProcessEntities {
    private static final Logger logger = Logger.getLogger(ProcessEntities.class);
    private Project project;
    private File sourceDirectory;
    private File destinationDirectory;
    private File destinationTextDirectory;
    private TextGroup entityTextGroup;
    private TextGroup entityFieldsTextGroup;

    public ProcessEntities(Project project) {
        this.project = project;
        this.sourceDirectory = new File(project.getSourceDirectory(), "entity");
        this.destinationDirectory = new File(project.getBuildDirectory(), "entity");
        this.destinationTextDirectory = new File(project.getBuildDirectory(), "text");
    }

    public void execute() {
        for (File file : this.sourceDirectory.listFiles()) {
            this.processFile(file);
        }
    }

    private void processFile(File file) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        if (this.project.getProcessedFiles().isModified(file)) {
            logger.debug("Processing Entity: " + FileMethods.extractNameFromFilename(file.getName()));
            xmlElement = XmlElementFactory.load(file);
            xmlElement2 = XmlElementFactory.load("<entity></entity>");
            this.processEntity(xmlElement, xmlElement2);
            this.saveEntityFiles(xmlElement2);
            this.project.getProcessedFiles().lodge(file);
        }
    }

    private void saveEntityFiles(XmlElement xmlElement) {
        String string = null;
        string = xmlElement.getText("name");
        xmlElement.save(new File(this.destinationDirectory, string + ".xml"));
        this.entityTextGroup.save();
        this.entityFieldsTextGroup.save();
    }

    private void processEntity(XmlElement xmlElement, XmlElement xmlElement2) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        NameFormat nameFormat = null;
        NameFormat nameFormat2 = null;
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        XmlElement xmlElement5 = null;
        XmlElement xmlElement6 = null;
        XmlElement xmlElement7 = null;
        string = xmlElement.getText("name");
        this.entityTextGroup = this.project.getTextGroups().getTextGroup("entity." + string);
        this.entityFieldsTextGroup = this.project.getTextGroups().getTextGroup("entity." + string + ".fields").clear();
        string2 = xmlElement.getOptionalText("display-text");
        string3 = xmlElement.getOptionalText("display-text-plural");
        string4 = xmlElement.getOptionalText("persistence-name");
        nameFormat = new NameFormat(string);
        nameFormat2 = nameFormat.getPlural();
        if (string2 == null) {
            string2 = nameFormat.getText();
        }
        if (string3 == null) {
            string3 = nameFormat2.getText();
        }
        if (string4 == null) {
            string4 = nameFormat2.getUpperCase();
        }
        this.entityTextGroup.setTextElement("DisplayText", string2);
        this.entityTextGroup.setTextElement("DisplayTextPlural", string3);
        xmlElement2.addElement("id").setLong(this.project.retrieveProjectId("entity." + string));
        xmlElement2.addElement("name").setText(string);
        xmlElement2.addElement("persistence-name").setText(string4);
        xmlElement3 = xmlElement2.addElement("fields");
        xmlElement5 = xmlElement2.addElement("primary-key");
        xmlElement5.addElement("type").setText("SystemManaged");
        xmlElement5.addElement("sequence-name").setText(string4);
        if (xmlElement.hasElement("keys")) {
            xmlElement4 = xmlElement2.addElement(xmlElement.getElement("keys"));
            this.processKeys(xmlElement4);
        } else {
            xmlElement4 = xmlElement2.addElement("keys");
        }
        xmlElement6 = xmlElement2.addElement("constraint-sets").addElement("constraint-set");
        xmlElement6.addElement("name").setText("Default");
        xmlElement7 = xmlElement6.addElement("fields");
        xmlElement2.addElement("comments").setText(xmlElement.getOptionalText("comments", ""));
        for (XmlElement xmlElement8 : xmlElement.getOptionalElements("fields/field")) {
            this.processField(string, xmlElement8, xmlElement3.addElement("field"), xmlElement7);
        }
    }

    private void processField(String string, XmlElement xmlElement, XmlElement xmlElement2, XmlElement xmlElement3) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        NameFormat nameFormat = null;
        String string5 = null;
        XmlElement xmlElement4 = null;
        string2 = xmlElement.getText("name");
        string3 = xmlElement.getOptionalText("display-text");
        string4 = xmlElement.getOptionalText("persistence-name");
        nameFormat = new NameFormat(string2);
        if (string3 == null) {
            string3 = nameFormat.getText();
        }
        if (string4 == null) {
            string4 = nameFormat.getUpperCase();
        }
        this.entityFieldsTextGroup.setTextElement(string2, string3);
        xmlElement2.addElement("id").setLong(this.project.retrieveProjectId("field." + string + "." + string2));
        xmlElement2.addElement("name").setText(string2);
        xmlElement2.addElement("persistence-name").setText(string4);
        this.processFieldType(xmlElement, xmlElement2.addElement(xmlElement.getElement("type")));
        string5 = xmlElement.hasElement("default-value") ? xmlElement.getText("default-value") : "${none}";
        xmlElement2.addElement("default-value").setText(string5);
        xmlElement2.addElement("comments").setText(xmlElement.getOptionalText("comments", ""));
        xmlElement4 = xmlElement3.addElement("field");
        xmlElement4.addElement("field-name").setText(string2);
        xmlElement4.addElement(xmlElement.getElement("constraints").cloneElement());
    }

    private void processFieldType(XmlElement xmlElement, XmlElement xmlElement2) {
        DataType dataType = null;
        String string = null;
        if (!xmlElement2.hasElement("capacity") && (dataType = DataType.get(xmlElement2.getText("data-type/name"))).supportsCapacity() && (string = this.extractMaxConstraint(xmlElement)) != null) {
            xmlElement2.getElement("data-type").addElement("capacity").setText(string);
        }
    }

    private void processKeys(XmlElement xmlElement) {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("key")) {
            this.processKey(xmlElement2);
        }
    }

    private void processKey(XmlElement xmlElement) {
        StringWrapper stringWrapper = null;
        if (!xmlElement.hasElement("name")) {
            stringWrapper = new StringWrapper();
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("fields/field-name")) {
                if (!stringWrapper.isEmpty()) {
                    stringWrapper.append("_");
                }
                stringWrapper.append(xmlElement2.getText());
            }
            xmlElement.prependElement("name").setText(stringWrapper.toString());
        }
        if (!xmlElement.hasElement("comments")) {
            xmlElement.addElement("comments");
        }
    }

    private String extractMaxConstraint(XmlElement xmlElement) {
        String string = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = xmlElement.getOptionalElements("constraints/constraint");
        for (XmlElement xmlElement2 : nullFreeCollection) {
            if (!new NameFormat(xmlElement2.getText("name")).getCamelCase().equals("Max")) continue;
            string = xmlElement2.getText("value");
        }
        return string;
    }
}

