/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine;

import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;

public class IdSource {
    private static final Logger logger = Logger.getLogger(IdSource.class);
    private String name;
    private long start;
    private Long end;
    private Long next;
    private byte increment;
    private XmlElement nextElement;

    IdSource(String string, long l, Long l2, Long l3, XmlElement xmlElement) {
        this.name = string;
        this.start = l;
        this.end = l2;
        this.next = l3;
        this.nextElement = xmlElement;
        if (this.next == null) {
            this.next = l;
        }
        this.increment = (byte)(l2 == null ? 1 : (l <= l2 ? 1 : -1));
    }

    public String getName() {
        return this.name;
    }

    public Long next() {
        Long l = null;
        l = this.next;
        IdSource idSource = this;
        idSource.next = idSource.next + (long)this.increment;
        if (this.nextElement != null) {
            this.nextElement.setLong(this.next);
        }
        return l;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        IdSource idSource = null;
        if (object instanceof IdSource) {
            idSource = (IdSource)object;
            if (idSource.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    static IdSource createInstance(XmlElement xmlElement) {
        IdSource idSource = null;
        String string = null;
        long l = 0L;
        Long l2 = null;
        Long l3 = null;
        string = xmlElement.getOptionalText("name");
        l = xmlElement.getLong("start");
        l2 = xmlElement.getOptionalLong("end");
        l3 = xmlElement.getOptionalLong("next");
        if (string == null) {
            string = xmlElement.getName();
        }
        idSource = new IdSource(string, l, l2, l3, xmlElement.getOptionalElement("next"));
        return idSource;
    }

    public static class TestProxy {
        private IdSource instance;

        public TestProxy(IdSource idSource) {
            this.instance = idSource;
        }

        public IdSource getInstance() {
            return this.instance;
        }

        public long getStart() {
            return this.instance.start;
        }

        public Long getEnd() {
            return this.instance.end;
        }

        public Long getNext() {
            return this.instance.next;
        }

        public byte getIncrement() {
            return this.instance.increment;
        }
    }
}

