/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.temporal.Timezone;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.CodeType;
import com.jronimo.webdata.core.DataType;
import com.jronimo.webdata.core.DatabaseEngine;
import com.jronimo.webdata.core.EngineDatabaseType;
import com.jronimo.webdata.core.TypeDefinition;
import com.jronimo.webdata.core.codetype.ByteArray;
import com.jronimo.webdata.core.codetype.IdHolder;
import com.jronimo.webdata.core.codetype.RefData;
import com.jronimo.webdata.core.codetype.TextElement;
import java.sql.Date;
import java.sql.Timestamp;

public final class MySqlUtils
implements DatabaseEngine.Utils {
    private static final Logger logger = Logger.getLogger(MySqlUtils.class);

    public Object getCodeValue(TypeDefinition typeDefinition, Object object) {
        Object object2 = null;
        DataType dataType = null;
        CodeType codeType = null;
        EngineDatabaseType engineDatabaseType = null;
        ValueStruct valueStruct = null;
        dataType = typeDefinition.getDataType();
        codeType = typeDefinition.getCodeType();
        engineDatabaseType = typeDefinition.getEngineDatabaseType(DatabaseEngine.get("MySql"));
        if (object != null) {
            if (codeType.isString()) {
                object2 = object.toString();
            } else if (codeType.isLong()) {
                object2 = Long.valueOf(object.toString());
            } else if (codeType.isInteger()) {
                object2 = Integer.valueOf(object.toString());
            } else if (codeType.isShort()) {
                object2 = Short.valueOf(object.toString());
            } else if (codeType.isByte()) {
                object2 = Byte.valueOf(object.toString());
            } else if (codeType.isDouble()) {
                object2 = Double.valueOf(object.toString());
            } else if (codeType.isFloat()) {
                object2 = Float.valueOf(object.toString());
            } else if (codeType.isDecimal()) {
                object2 = object;
            } else if (codeType.isBoolean()) {
                object2 = Integer.parseInt(object.toString()) == 1;
            } else if (codeType.isDate()) {
                object2 = new com.jronimo.temporal.Date(object.toString());
            } else if (codeType.isDateTime()) {
                if (dataType.isDateTime()) {
                    object2 = new DateTime(object.toString());
                } else if (dataType.isTimestamp()) {
                    object2 = new DateTime(Long.valueOf(object.toString()));
                }
            } else if (codeType.isTimeOfDay()) {
                if (engineDatabaseType.getDatabaseType().isTime()) {
                    object2 = new TimeOfDay(object.toString());
                } else if (engineDatabaseType.getDatabaseType().isWholeNumberBroadType()) {
                    valueStruct = new ValueStruct();
                    valueStruct.temporalValue = Long.valueOf(object.toString());
                    object2 = new TimeOfDay(valueStruct);
                }
            } else if (codeType.isTime()) {
                if (engineDatabaseType.getDatabaseType().isTime()) {
                    object2 = new Time(object.toString());
                } else if (engineDatabaseType.getDatabaseType().isWholeNumberBroadType()) {
                    valueStruct = new ValueStruct();
                    valueStruct.temporalValue = Long.valueOf(object.toString());
                    object2 = new Time(valueStruct);
                }
            }
            if (codeType.isTimezone()) {
                object2 = Timezone.getTimezone(Integer.valueOf(object.toString()));
            } else if (codeType.isByteArray()) {
                object2 = new ByteArray((byte[])object);
            } else if (codeType.isRefData()) {
                object2 = RefData.get(Long.valueOf(object.toString()));
            } else if (codeType.isTextElement()) {
                object2 = TextElement.get(Long.valueOf(object.toString()));
            }
        }
        return object2;
    }

    public Object getPersistenceSetValue(TypeDefinition typeDefinition, Object object, Object object2) {
        Object object3 = null;
        DataType dataType = null;
        EngineDatabaseType engineDatabaseType = null;
        String string = null;
        dataType = typeDefinition.getDataType();
        engineDatabaseType = typeDefinition.getEngineDatabaseType(DatabaseEngine.get("MySql"));
        if (object == null) {
            object3 = null;
        } else if (dataType.isAutoNumber()) {
            object3 = null;
        } else if (object2 != null) {
            object3 = object2;
        } else {
            if (dataType.isTimezone()) {
                object3 = (byte)((Timezone)object).getId();
            } else if (dataType.isWholeNumber1()) {
                object3 = Byte.valueOf(object.toString());
            } else if (dataType.isWholeNumber2()) {
                object3 = Short.valueOf(object.toString());
            } else if (dataType.isBlob()) {
                object3 = ((ByteArray)object).getBytes();
            } else if (dataType.isBoolean()) {
                object3 = (Boolean)object != false ? Byte.valueOf("1") : Byte.valueOf("0");
            } else if (dataType.isDate()) {
                object3 = Date.valueOf(object.toString());
            } else if (dataType.isDateTime()) {
                object3 = Timestamp.valueOf(object.toString());
            } else if (dataType.isTimestamp()) {
                object3 = ((DateTime)object).getTemporalValue();
            } else if (dataType.isTimeOfDay()) {
                if (engineDatabaseType.getDatabaseType().isTime()) {
                    object3 = java.sql.Time.valueOf(object.toString());
                } else if (engineDatabaseType.getDatabaseType().isWholeNumberBroadType()) {
                    object3 = ((TimeOfDay)object).getTemporalValue();
                }
            } else if (dataType.isTime()) {
                if (engineDatabaseType.getDatabaseType().isTime()) {
                    object3 = java.sql.Time.valueOf(object.toString());
                } else if (engineDatabaseType.getDatabaseType().isWholeNumberBroadType()) {
                    object3 = ((Time)object).getTemporalValue();
                }
            } else if (dataType.isRefData() || dataType.isTextElement()) {
                string = String.valueOf(((IdHolder)object).getId());
            } else if (dataType.isGroupingId()) {
                string = object.toString();
            }
            if (string == null) {
                object3 = object;
            } else if (engineDatabaseType.getDatabaseType().isBigInt()) {
                object3 = Long.valueOf(string);
            } else if (engineDatabaseType.getDatabaseType().isInt()) {
                object3 = Integer.valueOf(string);
            } else if (engineDatabaseType.getDatabaseType().isSmallInt()) {
                object3 = Short.valueOf(string);
            } else if (engineDatabaseType.getDatabaseType().isTinyInt()) {
                object3 = Byte.valueOf(string);
            }
        }
        return object3;
    }
}

