/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.CodeType;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.core.DataType;
import com.jronimo.webdata.core.DatabaseEngine;
import com.jronimo.webdata.core.Methods;
import com.jronimo.webdata.core.ResourceTextIdentifiers;
import com.jronimo.webdata.core.TypeDefinition;

public final class FieldValue {
    private static final Logger logger = Logger.getLogger(FieldValue.class);
    private TypeDefinition typeDefinition;
    private DatabaseEngine engine;
    private String stringValue;
    private Object codeValue;
    private Object persistenceSetValue;
    private Constants.ValueDirective nullDirective;

    private FieldValue(TypeDefinition typeDefinition, DatabaseEngine databaseEngine, String string, Object object, Object object2) {
        this.typeDefinition = typeDefinition;
        this.engine = databaseEngine;
        this.stringValue = string;
        this.codeValue = object;
        this.persistenceSetValue = object2;
        this.nullDirective = Constants.ValueDirective.get(string);
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public DataType getDataType() {
        return this.typeDefinition.getDataType();
    }

    public CodeType getCodeType() {
        return this.typeDefinition.getCodeType();
    }

    public FieldValue setEngine(DatabaseEngine databaseEngine) {
        Assert.errorParamMustNotBeNull("value", databaseEngine);
        if (this.engine != null) {
            this.engine = databaseEngine;
            this.persistenceSetValue = this.engine.getPersistenceSetValue(this.typeDefinition, this.codeValue, null);
        }
        return this;
    }

    public boolean hasEngine() {
        return this.engine != null;
    }

    public DatabaseEngine getEngine() {
        return this.engine;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Object getCodeValue() {
        return this.codeValue;
    }

    public Object getPersistenceSetValue() {
        Assert.errorState(this.engine == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.ENGINE_NOT_SET));
        return this.persistenceSetValue;
    }

    public Object getPersistenceSetValue(DatabaseEngine databaseEngine) {
        Object object = null;
        Assert.errorParamMustNotBeNull("engine", databaseEngine);
        object = this.engine == null || !this.engine.equals(databaseEngine) ? databaseEngine.getPersistenceSetValue(this.typeDefinition, this.codeValue, null) : this.persistenceSetValue;
        return object;
    }

    public boolean isNull() {
        return this.codeValue == null;
    }

    public Constants.ValueDirective getNullDirective() {
        return this.nullDirective;
    }

    public boolean isNullDirective() {
        return this.nullDirective != null;
    }

    public boolean isNullDirectiveNull() {
        return this.nullDirective == Constants.ValueDirective.NULL;
    }

    public boolean isNullDirectiveNotNull() {
        return this.nullDirective == Constants.ValueDirective.NOT_NULL;
    }

    public String getDirectSqlValue() {
        Assert.errorState(this.engine == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.ENGINE_NOT_SET));
        return this.typeDefinition.getEngineDatabaseType(this.engine).getDirectSqlValue(this.persistenceSetValue);
    }

    public String getDirectSqlValue(DatabaseEngine databaseEngine) {
        Assert.errorParamMustNotBeNull("engine", databaseEngine);
        return this.typeDefinition.getEngineDatabaseType(databaseEngine).getDirectSqlValue(this.persistenceSetValue);
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        FieldValue fieldValue = null;
        if (object instanceof FieldValue) {
            fieldValue = (FieldValue)object;
            bl = Methods.bothEqual(this.stringValue, fieldValue.stringValue);
        }
        return bl;
    }

    public String toString() {
        return this.isNull() ? "null" : this.stringValue;
    }

    public static FieldValue createInstance(TypeDefinition typeDefinition, String string) {
        return FieldValue.createInstance(typeDefinition, null, string);
    }

    public static FieldValue createInstance(TypeDefinition typeDefinition, DatabaseEngine databaseEngine, String string) {
        FieldValue fieldValue = null;
        Object object = null;
        Object object2 = null;
        object = typeDefinition.getCodeType().getCodeValue(string);
        if (databaseEngine != null) {
            object2 = databaseEngine.getPersistenceSetValue(typeDefinition, object, null);
        }
        fieldValue = new FieldValue(typeDefinition, databaseEngine, string, object, object2);
        return fieldValue;
    }

    public static FieldValue createInstance(TypeDefinition typeDefinition, DatabaseEngine databaseEngine, Object object) {
        FieldValue fieldValue = null;
        String string = null;
        Object object2 = null;
        Object object3 = null;
        object2 = databaseEngine.getCodeValue(typeDefinition, object);
        string = typeDefinition.getCodeType().getStringValue(object2);
        object3 = databaseEngine.getPersistenceSetValue(typeDefinition, object2, object);
        fieldValue = new FieldValue(typeDefinition, databaseEngine, string, object2, object3);
        return fieldValue;
    }
}

