/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.temporal.Date;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.webdata.core.DatabaseType;
import com.jronimo.xml.XmlElement;
import java.math.BigDecimal;
import java.util.Map;

public final class EngineDatabaseType {
    private static final Logger logger = Logger.getLogger(EngineDatabaseType.class);
    private static Map<String, EngineDatabaseType> members;
    private String name;
    private DatabaseType databaseType;
    private Long rangeStart;
    private Long rangeEnd;
    private boolean supportsCapacity;
    private boolean supportsPrecisionScale;
    private boolean supportsCharacterSet;
    private boolean supportsCollation;
    private String comments;

    private EngineDatabaseType(String string, DatabaseType databaseType) {
        this.name = string;
        this.databaseType = databaseType;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public boolean hasRangeStart() {
        return this.rangeStart != null;
    }

    public Long getRangeStart() {
        return this.rangeStart;
    }

    public boolean hasRangeEnd() {
        return this.rangeEnd != null;
    }

    public Long getRangeEnd() {
        return this.rangeEnd;
    }

    public boolean supportsCapacity() {
        return this.supportsCapacity;
    }

    public boolean supportsPrecisionScale() {
        return this.supportsPrecisionScale;
    }

    public boolean supportsCharacterSet() {
        return this.supportsCharacterSet;
    }

    public boolean supportsCollation() {
        return this.supportsCollation;
    }

    public boolean hasComments() {
        return this.comments != null;
    }

    public String getComments() {
        return this.comments;
    }

    public String getDirectSqlValue(Object object) {
        String string = null;
        boolean bl = false;
        StringWrapper stringWrapper = null;
        if (object == null) {
            string = "NULL";
        } else if (object instanceof Boolean) {
            string = object.toString().toUpperCase();
        } else if (object instanceof BigDecimal) {
            string = ((BigDecimal)object).toPlainString();
        } else if (object instanceof Date) {
            string = ((Date)object).getString(new StringFormat(new StringFormat.TimezoneFormat()));
            bl = true;
        } else if (object instanceof DateTime) {
            string = ((DateTime)object).getString(new StringFormat(new StringFormat.TimezoneFormat()));
            bl = true;
        } else if (object instanceof TimeOfDay) {
            string = ((TimeOfDay)object).getString(new StringFormat(new StringFormat.TimezoneFormat()));
            bl = true;
        } else if (object instanceof String || object instanceof Time) {
            string = object.toString();
            bl = true;
        } else {
            string = object.toString();
        }
        stringWrapper = new StringWrapper(string).sqlEscape();
        if (bl) {
            stringWrapper.surround("'");
        }
        string = stringWrapper.toString();
        return string;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        EngineDatabaseType engineDatabaseType = null;
        if (object instanceof EngineDatabaseType) {
            engineDatabaseType = (EngineDatabaseType)object;
            if (engineDatabaseType.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    static EngineDatabaseType createInstance(XmlElement xmlElement) {
        EngineDatabaseType engineDatabaseType = null;
        engineDatabaseType = new EngineDatabaseType(xmlElement.getText("name"), DatabaseType.get(xmlElement.getText("database-type")));
        engineDatabaseType.rangeStart = xmlElement.getOptionalLong("range-start");
        engineDatabaseType.rangeEnd = xmlElement.getOptionalLong("range-end");
        engineDatabaseType.supportsCapacity = xmlElement.getOptionalBoolean("supports-capacity", "false");
        engineDatabaseType.supportsPrecisionScale = xmlElement.getOptionalBoolean("supports-precision-scale", "false");
        engineDatabaseType.supportsCharacterSet = xmlElement.getOptionalBoolean("supports-character-set", "false");
        engineDatabaseType.supportsCollation = xmlElement.getOptionalBoolean("supports-collation", "false");
        return engineDatabaseType;
    }
}

