/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.util.NameFormat;
import com.jronimo.webdata.core.DatabaseType;
import com.jronimo.webdata.core.EngineDatabaseType;
import com.jronimo.webdata.core.TypeDefinition;
import com.jronimo.webdata.core.resources.PackageMarker;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashMap;
import java.util.Map;

public final class DatabaseEngine {
    private static final Logger logger = Logger.getLogger(DatabaseEngine.class);
    private static Map<String, DatabaseEngine> members;
    private String name;
    private boolean active;
    private Utils utils;
    private Map<String, EngineDatabaseType> engineDatabaseTypes;

    private DatabaseEngine(String string, boolean bl) {
        this.name = string;
        this.active = bl;
        if (bl) {
            this.utils = (Utils)Methods.safeNewInstance("com.jronimo.webdata.core." + new NameFormat(string).getCamelCase());
        }
    }

    public static DatabaseEngine get(String string) {
        return members.get(new NameFormat(string).getUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public Object getCodeValue(TypeDefinition typeDefinition, Object object) {
        return this.utils.getCodeValue(typeDefinition, object);
    }

    public Object getPersistenceSetValue(TypeDefinition typeDefinition, Object object, Object object2) {
        return this.utils.getPersistenceSetValue(typeDefinition, object, object2);
    }

    public EngineDatabaseType getEngineDatabaseType(DatabaseType databaseType) {
        EngineDatabaseType engineDatabaseType = null;
        if (this.engineDatabaseTypes != null) {
            for (EngineDatabaseType engineDatabaseType2 : this.engineDatabaseTypes.values()) {
                if (!engineDatabaseType2.getDatabaseType().equals(databaseType)) continue;
                engineDatabaseType = engineDatabaseType2;
                break;
            }
        }
        return engineDatabaseType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DatabaseEngine databaseEngine = null;
        if (object instanceof DatabaseEngine) {
            databaseEngine = (DatabaseEngine)object;
            if (databaseEngine.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    private static void load() {
        XmlElement xmlElement = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        DatabaseEngine databaseEngine = null;
        xmlElement = XmlElementFactory.load(PackageMarker.class, "DatabaseEngines.xml");
        nullFreeCollection = xmlElement.getOptionalElements("engine");
        members = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement object : nullFreeCollection) {
            databaseEngine = new DatabaseEngine(object.getText("name"), object.getBoolean("active"));
            members.put(databaseEngine.getName(), databaseEngine);
        }
        for (DatabaseEngine databaseEngine2 : members.values()) {
            if (!databaseEngine2.isActive()) continue;
            DatabaseEngine.loadEngineDatabaseTypes(databaseEngine2);
        }
    }

    private static void loadEngineDatabaseTypes(DatabaseEngine databaseEngine) {
        String string = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        EngineDatabaseType engineDatabaseType = null;
        string = new NameFormat(databaseEngine.getName()).getCamelCase() + "Types.xml";
        nullFreeCollection = XmlElementFactory.load(PackageMarker.class, string).getOptionalElements("type");
        databaseEngine.engineDatabaseTypes = new HashMap<String, EngineDatabaseType>(nullFreeCollection.size());
        for (XmlElement xmlElement : nullFreeCollection) {
            engineDatabaseType = EngineDatabaseType.createInstance(xmlElement);
            databaseEngine.engineDatabaseTypes.put(engineDatabaseType.getName(), engineDatabaseType);
        }
    }

    static {
        DatabaseEngine.load();
    }

    public static interface Utils {
        public Object getCodeValue(TypeDefinition var1, Object var2);

        public Object getPersistenceSetValue(TypeDefinition var1, Object var2, Object var3);
    }
}

