/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.decorations.NullFreeImmutableSet_U;
import com.jronimo.collections.collection.decorationtypes.NullFreeSetCollection_U;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.collections.collection.types.nullfree.NullFreeImmutableCollection;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.CodeType;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.core.DatabaseType;
import com.jronimo.webdata.core.resources.PackageMarker;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import com.jronimo.xml.XmlUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataType {
    private static final Logger logger = Logger.getLogger(DataType.class);
    public static final String AUTO_NUMBER = "AutoNumber";
    public static final String FIXED_LENGTH_TEXT = "FixedLengthText";
    public static final String VARIABLE_LENGTH_TEXT = "VariableLengthText";
    public static final String CLOB = "Clob";
    public static final String BLOB = "Blob";
    public static final String WHOLE_NUMBER_1 = "WholeNumber1";
    public static final String WHOLE_NUMBER_2 = "WholeNumber2";
    public static final String WHOLE_NUMBER_4 = "WholeNumber4";
    public static final String WHOLE_NUMBER_8 = "WholeNumber8";
    public static final String DECIMAL_NUMBER_4 = "DecimalNumber4";
    public static final String DECIMAL_NUMBER_8 = "DecimalNumber8";
    public static final String DECIMAL_NUMBER_PS = "DecimalNumberPS";
    public static final String BOOLEAN = "Boolean";
    public static final String TIMEZONE = "Timezone";
    public static final String DATE = "Date";
    public static final String DATE_TIME = "DateTime";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TIME_OF_DAY = "TimeOfDay";
    public static final String TIME = "Time";
    public static final String YEAR = "Year";
    public static final String YEAR_MILLIONS = "YearMillions";
    public static final String YEAR_BILLIONS = "YearBillions";
    public static final String GROUPING_ID = "GroupingId";
    public static final String REF_DATA = "RefData";
    public static final String TEXT_ELEMENT = "TextElement";
    private static Map<String, DataType> members;
    private int id;
    private String name;
    private String comments;
    private Constants.BroadType broadType;
    private TypeOptions codeTypes;
    private TypeOptions databaseTypes;
    private boolean supportsCapacity;
    private boolean supportsPrecisionScale;
    private boolean supportsCharacterSet;
    private boolean supportsCollation;
    private com.jronimo.collections.collection.types.Collection<Parameter> parameters;

    DataType(int n, String string, String string2, Constants.BroadType broadType, TypeOptions typeOptions, TypeOptions typeOptions2, boolean bl, boolean bl2, boolean bl3, boolean bl4, com.jronimo.collections.collection.types.Collection<Parameter> collection) {
        this.id = n;
        this.name = string;
        this.comments = string2;
        this.broadType = broadType;
        this.codeTypes = typeOptions;
        this.databaseTypes = typeOptions2;
        this.supportsCapacity = bl;
        this.supportsPrecisionScale = bl2;
        this.supportsCharacterSet = bl3;
        this.supportsCollation = bl4;
        this.parameters = collection;
    }

    public static DataType get(String string) {
        return members.get(string);
    }

    public static DataType get(int n) {
        DataType dataType = null;
        for (DataType dataType2 : members.values()) {
            if (dataType2.getId() != n) continue;
            dataType = dataType2;
            break;
        }
        return dataType;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public Constants.BroadType getBroadType() {
        return this.broadType;
    }

    public TypeOptions getCodeTypes() {
        return this.codeTypes;
    }

    public CodeType getDefaultCodeType() {
        return CodeType.get(this.codeTypes.getDefault());
    }

    public TypeOptions getDatabaseTypes() {
        return this.databaseTypes;
    }

    public DatabaseType getDefaultDatabaseType() {
        return DatabaseType.get(this.databaseTypes.getDefault());
    }

    public boolean supportsCapacity() {
        return this.supportsCapacity;
    }

    public boolean supportsCharacterSet() {
        return this.supportsCharacterSet;
    }

    public boolean supportsCollation() {
        return this.supportsCollation;
    }

    public boolean supportsPrecisionScale() {
        return this.supportsPrecisionScale;
    }

    public NullFreeImmutableSet<Parameter> getParameters() {
        return new NullFreeImmutableSet<Parameter>((Collection<Parameter>)this.parameters);
    }

    public boolean isAutoNumber() {
        return this.name.equals(AUTO_NUMBER);
    }

    public boolean isFixedLengthText() {
        return this.name.equals(FIXED_LENGTH_TEXT);
    }

    public boolean isVariableLengthText() {
        return this.name.equals(VARIABLE_LENGTH_TEXT);
    }

    public boolean isClob() {
        return this.name.equals(CLOB);
    }

    public boolean isBlob() {
        return this.name.equals(BLOB);
    }

    public boolean isWholeNumber1() {
        return this.name.equals(WHOLE_NUMBER_1);
    }

    public boolean isWholeNumber2() {
        return this.name.equals(WHOLE_NUMBER_2);
    }

    public boolean isWholeNumber4() {
        return this.name.equals(WHOLE_NUMBER_4);
    }

    public boolean isWholeNumber8() {
        return this.name.equals(WHOLE_NUMBER_8);
    }

    public boolean isDecimalNumber4() {
        return this.name.equals(DECIMAL_NUMBER_4);
    }

    public boolean isDecimalNumber8() {
        return this.name.equals(DECIMAL_NUMBER_8);
    }

    public boolean isDecimalNumberPS() {
        return this.name.equals(DECIMAL_NUMBER_PS);
    }

    public boolean isDate() {
        return this.name.equals(DATE);
    }

    public boolean isDateTime() {
        return this.name.equals(DATE_TIME);
    }

    public boolean isTimestamp() {
        return this.name.equals(TIMESTAMP);
    }

    public boolean isTimeOfDay() {
        return this.name.equals(TIME_OF_DAY);
    }

    public boolean isTime() {
        return this.name.equals(TIME);
    }

    public boolean isTimezone() {
        return this.name.equals(TIMEZONE);
    }

    public boolean isYear() {
        return this.name.equals(YEAR);
    }

    public boolean isYearMillions() {
        return this.name.equals(YEAR_MILLIONS);
    }

    public boolean isYearBillions() {
        return this.name.equals(YEAR_BILLIONS);
    }

    public boolean isBoolean() {
        return this.name.equals(BOOLEAN);
    }

    public boolean isGroupingId() {
        return this.name.equals(GROUPING_ID);
    }

    public boolean isRefData() {
        return this.name.equals(REF_DATA);
    }

    public boolean isTextElement() {
        return this.name.equals(TEXT_ELEMENT);
    }

    public synchronized String toString() {
        return this.name;
    }

    private static void load() {
        XmlElement xmlElement = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        DataType dataType = null;
        try {
            xmlElement = XmlElementFactory.load(PackageMarker.class, "DataTypes.xml");
            nullFreeCollection = xmlElement.getElements("data-type");
            members = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
            for (XmlElement xmlElement2 : nullFreeCollection) {
                dataType = DataType.loadDataType(xmlElement2);
                members.put(dataType.getName(), dataType);
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    private static DataType loadDataType(XmlElement xmlElement) throws Exception {
        DataType dataType = null;
        int n = 0;
        String string = null;
        String string2 = null;
        Constants.BroadType broadType = null;
        TypeOptions typeOptions = null;
        TypeOptions typeOptions2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        com.jronimo.collections.collection.types.Collection<Parameter> collection = null;
        n = xmlElement.getInteger("id");
        string = xmlElement.getText("name");
        string2 = xmlElement.getOptionalText("comments", "");
        broadType = Constants.BroadType.get(xmlElement.getText("broad-type"));
        typeOptions = DataType.getCodeTypes(xmlElement.getElement("code-types"));
        typeOptions2 = DataType.getDatabaseTypes(xmlElement.getElement("database-types"));
        bl = xmlElement.getOptionalBoolean("supports-capacity", "false");
        bl3 = xmlElement.getOptionalBoolean("supports-character-set", "false");
        bl4 = xmlElement.getOptionalBoolean("supports-collation", "false");
        bl2 = xmlElement.getOptionalBoolean("supports-precision-scale", "false");
        collection = DataType.getParameters(xmlElement.getOptionalElements("parameters/parameter"));
        dataType = new DataType(n, string, string2, broadType, typeOptions, typeOptions2, bl, bl2, bl3, bl4, collection);
        return dataType;
    }

    private static TypeOptions getCodeTypes(XmlElement xmlElement) throws Exception {
        TypeOptions typeOptions = null;
        typeOptions = new TypeOptions(new NullFreeImmutableSet_U<String>((Collection<String>)XmlUtils.getTextFromElements(xmlElement.getElements("type", 1))), xmlElement.getText("default-type"));
        return typeOptions;
    }

    private static TypeOptions getDatabaseTypes(XmlElement xmlElement) throws Exception {
        TypeOptions typeOptions = null;
        typeOptions = new TypeOptions(new NullFreeImmutableSet_U<String>((Collection<String>)XmlUtils.getTextFromElements(xmlElement.getElements("type", 1))), xmlElement.getText("default-type"));
        return typeOptions;
    }

    private static com.jronimo.collections.collection.types.Collection<Parameter> getParameters(com.jronimo.collections.collection.types.Collection<XmlElement> collection) throws Exception {
        NullFreeMutableSet<Parameter> nullFreeMutableSet = null;
        String string = null;
        NullFreeImmutableCollection<String> nullFreeImmutableCollection = null;
        Parameter parameter = null;
        nullFreeMutableSet = new NullFreeMutableSet<Parameter>(collection.size());
        for (XmlElement xmlElement : collection) {
            string = xmlElement.getText("type");
            if (string.equals("LOV")) {
                nullFreeImmutableCollection = XmlUtils.getTextFromElements(xmlElement.getOptionalElements("lov/value"));
            }
            parameter = new Parameter(xmlElement.getText("name"), xmlElement.getBoolean("mandatory"), string, nullFreeImmutableCollection, xmlElement.getOptionalText("default-value"), xmlElement.getOptionalText("comments"));
            nullFreeMutableSet.add(parameter);
        }
        return nullFreeMutableSet;
    }

    static {
        DataType.load();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter {
        private String name;
        private boolean mandatory;
        private String type;
        private com.jronimo.collections.collection.types.Collection<String> lov;
        private String defaultValue;
        private String comments;

        Parameter(String string, boolean bl, String string2, com.jronimo.collections.collection.types.Collection<String> collection, String string3, String string4) {
            this.name = string;
            this.mandatory = bl;
            this.type = string2;
            this.lov = collection;
            this.defaultValue = string3;
            this.comments = string4;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String getType() {
            return this.type;
        }

        public com.jronimo.collections.collection.types.Collection<String> getLov() {
            return this.lov;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean hasComments() {
            return this.comments != null;
        }

        public String getComments() {
            return this.comments;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeOptions {
        public NullFreeImmutableSet_U<String> options;
        public String defaultOption;

        TypeOptions(NullFreeSetCollection_U<String> nullFreeSetCollection_U, String string) {
            this.options = new NullFreeImmutableSet_U<String>((Collection<String>)nullFreeSetCollection_U);
            this.defaultOption = string;
        }

        public NullFreeImmutableSet_U<String> getOptions() {
            return this.options;
        }

        public String getDefault() {
            return this.defaultOption;
        }
    }
}

