/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.util.NameFormat;

public class Constants
extends com.jronimo.util.Constants {
    public static final String SYSTEM_ROLE_ANYONE = "Anyone";
    public static final String SYSTEM_ROLE_AUTHENTICATED_USER = "AuthenticatedUser";
    public static final String BASE_CONSTRAINT_SET = "Base";

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SystemFieldIdentifier {
        SYSTEM_MANAGED_ID,
        RECORD_STATUS,
        RECORD_VERSION,
        AUDIT_CREATE_USER_ID,
        AUDIT_CREATE_USERNAME,
        AUDIT_CREATE_TIMESTAMP,
        AUDIT_UPDATE_USER_ID,
        AUDIT_UPDATE_USERNAME,
        AUDIT_UPDATE_TIMESTAMP;


        public boolean isSystemManagedId() {
            return this == SYSTEM_MANAGED_ID;
        }

        public boolean isRecordStatus() {
            return this == RECORD_STATUS;
        }

        public boolean isRecordVersion() {
            return this == RECORD_VERSION;
        }

        public boolean isAuditCreateUserId() {
            return this == AUDIT_CREATE_USER_ID;
        }

        public boolean isAuditCreateUsername() {
            return this == AUDIT_CREATE_USERNAME;
        }

        public boolean isAuditCreateTimestamp() {
            return this == AUDIT_CREATE_TIMESTAMP;
        }

        public boolean isAuditUpdateUserId() {
            return this == AUDIT_UPDATE_USER_ID;
        }

        public boolean isAuditUpdateUsername() {
            return this == AUDIT_UPDATE_USERNAME;
        }

        public boolean isAuditUpdateTimestamp() {
            return this == AUDIT_UPDATE_TIMESTAMP;
        }

        public static SystemFieldIdentifier get(String string) {
            SystemFieldIdentifier systemFieldIdentifier = null;
            string = new NameFormat(string).getUpperCase();
            for (SystemFieldIdentifier systemFieldIdentifier2 : SystemFieldIdentifier.values()) {
                if (!systemFieldIdentifier2.toString().equals(string)) continue;
                systemFieldIdentifier = systemFieldIdentifier2;
                break;
            }
            return systemFieldIdentifier;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        ENTITY,
        BUSINESS_OBJECT;


        public boolean isEntity() {
            return this == ENTITY;
        }

        public boolean isBusinessObject() {
            return this == BUSINESS_OBJECT;
        }

        public static OperationType get(String string) {
            OperationType operationType = null;
            string = new NameFormat(string).getUpperCase();
            for (OperationType operationType2 : OperationType.values()) {
                if (!operationType2.toString().equals(string)) continue;
                operationType = operationType2;
                break;
            }
            return operationType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE,
        EXPIRED,
        HIDDEN,
        DELETED;


        public boolean isActive() {
            return this == ACTIVE;
        }

        public boolean isExpired() {
            return this == EXPIRED;
        }

        public boolean isHidden() {
            return this == HIDDEN;
        }

        public boolean isDelete() {
            return this == DELETED;
        }

        public static Status get(String string) {
            Status status = null;
            string = new NameFormat(string).getUpperCase();
            for (Status status2 : Status.values()) {
                if (!status2.toString().equals(string)) continue;
                status = status2;
                break;
            }
            return status;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityOperation {
        LIST,
        GET,
        CREATE,
        UPDATE,
        DELETE;


        public boolean isList() {
            return this == LIST;
        }

        public boolean isGet() {
            return this == GET;
        }

        public boolean isCreate() {
            return this == CREATE;
        }

        public boolean isUpdate() {
            return this == UPDATE;
        }

        public boolean isDelete() {
            return this == DELETE;
        }

        public static EntityOperation get(String string) {
            EntityOperation entityOperation = null;
            string = new NameFormat(string).getUpperCase();
            for (EntityOperation entityOperation2 : EntityOperation.values()) {
                if (!entityOperation2.toString().equals(string)) continue;
                entityOperation = entityOperation2;
                break;
            }
            return entityOperation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelationshipType {
        OWNERSHIP,
        REFERENCE,
        ASSOCIATION;


        public boolean isOwnership() {
            return this == OWNERSHIP;
        }

        public boolean isReference() {
            return this == REFERENCE;
        }

        public boolean isAssociation() {
            return this == ASSOCIATION;
        }

        public static RelationshipType get(String string) {
            RelationshipType relationshipType = null;
            string = new NameFormat(string).getUpperCase();
            for (RelationshipType relationshipType2 : RelationshipType.values()) {
                if (!relationshipType2.toString().equals(string)) continue;
                relationshipType = relationshipType2;
                break;
            }
            return relationshipType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrimaryKeyType {
        NONE,
        SYSTEM_MANAGED,
        AUTO_NUMBER,
        COMPOUND_IMMUTABLE,
        COMPOUND_MUTABLE;


        public boolean isNone() {
            return this == NONE;
        }

        public boolean isSystemManaged() {
            return this == SYSTEM_MANAGED;
        }

        public boolean isAutoNumber() {
            return this == AUTO_NUMBER;
        }

        public boolean isCompoundImmutable() {
            return this == COMPOUND_IMMUTABLE;
        }

        public boolean isCompoundMutable() {
            return this == COMPOUND_MUTABLE;
        }

        public static PrimaryKeyType get(String string) {
            PrimaryKeyType primaryKeyType = null;
            string = new NameFormat(string).getUpperCase();
            for (PrimaryKeyType primaryKeyType2 : PrimaryKeyType.values()) {
                if (!primaryKeyType2.toString().equals(string)) continue;
                primaryKeyType = primaryKeyType2;
                break;
            }
            return primaryKeyType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SequenceType {
        TABLE,
        DATABASE;


        public boolean isTable() {
            return this == TABLE;
        }

        public boolean isDatabase() {
            return this == DATABASE;
        }

        public static SequenceType get(String string) {
            SequenceType sequenceType = null;
            string = new NameFormat(string).getUpperCase();
            for (SequenceType sequenceType2 : SequenceType.values()) {
                if (!sequenceType2.toString().equals(string)) continue;
                sequenceType = sequenceType2;
                break;
            }
            return sequenceType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataSourceType {
        RDBMS,
        LDAP,
        SYSTEM;


        public boolean isRdbms() {
            return this == RDBMS;
        }

        public boolean isLdap() {
            return this == LDAP;
        }

        public boolean isSystem() {
            return this == SYSTEM;
        }

        public static DataSourceType get(String string) {
            DataSourceType dataSourceType = null;
            string = new NameFormat(string).getUpperCase();
            for (DataSourceType dataSourceType2 : DataSourceType.values()) {
                if (!dataSourceType2.toString().equals(string)) continue;
                dataSourceType = dataSourceType2;
                break;
            }
            return dataSourceType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BroadType {
        TEXT,
        BINARY,
        WHOLE_NUMBER,
        DECIMAL_NUMBER,
        TEMPORAL,
        BOOLEAN,
        ID_HOLDER;


        public boolean isText() {
            return this == TEXT;
        }

        public boolean isBinary() {
            return this == BINARY;
        }

        public boolean isWholeNumber() {
            return this == WHOLE_NUMBER;
        }

        public boolean isDecimalNumber() {
            return this == DECIMAL_NUMBER;
        }

        public boolean isTemporal() {
            return this == TEMPORAL;
        }

        public boolean isBoolean() {
            return this == BOOLEAN;
        }

        public boolean isIdHolder() {
            return this == ID_HOLDER;
        }

        public static BroadType get(String string) {
            BroadType broadType = null;
            string = new NameFormat(string).getUpperCase();
            for (BroadType broadType2 : BroadType.values()) {
                if (!broadType2.toString().equals(string)) continue;
                broadType = broadType2;
                break;
            }
            return broadType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueDirective {
        UNRECOGNIZED(""),
        NONE("${none}"),
        NULL("${null}"),
        NOT_NULL("${not-null}"),
        EMPTY_STRING("${empty-string}"),
        SPACE("${space}");

        private String identifier;

        private ValueDirective(String string2) {
            this.identifier = string2;
        }

        public boolean isUnrecognized() {
            return this == UNRECOGNIZED;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public boolean isNull() {
            return this == NULL;
        }

        public boolean isNotNull() {
            return this == NOT_NULL;
        }

        public boolean isEmptyString() {
            return this == EMPTY_STRING;
        }

        public boolean isSpace() {
            return this == SPACE;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public static ValueDirective get(String string) {
            ValueDirective valueDirective = null;
            for (ValueDirective valueDirective2 : ValueDirective.values()) {
                if (!valueDirective2.identifier.equals(string)) continue;
                valueDirective = valueDirective2;
                break;
            }
            if (valueDirective == null) {
                valueDirective = UNRECOGNIZED;
            }
            return valueDirective;
        }

        public String toString() {
            return this.identifier;
        }
    }
}

