/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.temporal.Timezone;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.core.codetype.ByteArray;
import com.jronimo.webdata.core.codetype.RefData;
import com.jronimo.webdata.core.codetype.TextElement;
import com.jronimo.webdata.core.resources.PackageMarker;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public final class CodeType {
    private static final Logger logger = Logger.getLogger(CodeType.class);
    private static Map<String, CodeType> members;
    private String name;
    private String clazz;
    private String comments;

    private CodeType(String string, String string2, String string3) {
        this.name = string;
        this.clazz = string2;
        this.comments = string3;
    }

    public static CodeType get(String string) {
        return members.get(string);
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Class getClazzAsClass() {
        return Methods.safeClassForName(this.clazz);
    }

    public boolean hasComments() {
        return this.comments != null;
    }

    public String getComments() {
        return this.comments;
    }

    public boolean isString() {
        return this.name.equals("String");
    }

    public boolean isByte() {
        return this.name.equals("Byte");
    }

    public boolean isShort() {
        return this.name.equals("Short");
    }

    public boolean isInteger() {
        return this.name.equals("Integer");
    }

    public boolean isLong() {
        return this.name.equals("Long");
    }

    public boolean isFloat() {
        return this.name.equals("Float");
    }

    public boolean isDouble() {
        return this.name.equals("Double");
    }

    public boolean isDecimal() {
        return this.name.equals("Decimal");
    }

    public boolean isTimezone() {
        return this.name.equals("Timezone");
    }

    public boolean isDate() {
        return this.name.equals("Date");
    }

    public boolean isDateTime() {
        return this.name.equals("DateTime");
    }

    public boolean isTimestamp() {
        return this.name.equals("Timestamp");
    }

    public boolean isTimeOfDay() {
        return this.name.equals("TimeOfDay");
    }

    public boolean isTime() {
        return this.name.equals("Time");
    }

    public boolean isBoolean() {
        return this.name.equals("Boolean");
    }

    public boolean isByteArray() {
        return this.name.equals("ByteArray");
    }

    public boolean isRefData() {
        return this.name.equals("RefData");
    }

    public boolean isTextElement() {
        return this.name.equals("TextElement");
    }

    public String getStringValue(Object object) {
        String string = null;
        string = object == null ? Constants.ValueDirective.NULL.toString() : (this.isDecimal() ? ((BigDecimal)object).toPlainString() : (this.isTimezone() ? String.valueOf(((Timezone)object).getId()) : (this.isRefData() ? String.valueOf(((RefData)object).getId()) : (this.isTextElement() ? String.valueOf(((TextElement)object).getId()) : object.toString()))));
        return string;
    }

    public Object getCodeValue(String string) {
        Object object = null;
        if (string == null || Constants.ValueDirective.get(string) != null) {
            object = null;
        } else if (this.isString()) {
            object = string;
        } else if (this.isLong()) {
            object = Long.valueOf(string);
        } else if (this.isInteger()) {
            object = Integer.valueOf(string);
        } else if (this.isShort()) {
            object = Short.valueOf(string);
        } else if (this.isByte()) {
            object = Byte.valueOf(string);
        } else if (this.isDouble()) {
            object = Double.valueOf(string);
        } else if (this.isFloat()) {
            object = Float.valueOf(string);
        } else if (this.isDecimal()) {
            new BigDecimal(string);
        } else if (this.isBoolean()) {
            object = Boolean.valueOf(string);
        } else if (this.isDate()) {
            object = new Date(string);
        } else if (this.isDateTime()) {
            object = new DateTime(string);
        } else if (this.isTimestamp()) {
            object = new DateTime(string);
        } else if (this.isTimeOfDay()) {
            object = new TimeOfDay(string);
        } else if (this.isTime()) {
            object = new Time(string);
        } else if (this.isDate()) {
            object = new Date(string);
        } else if (this.isTimezone()) {
            object = Timezone.getTimezone(Integer.valueOf(string));
        } else if (this.isByteArray()) {
            object = new ByteArray(string);
        } else if (this.isRefData()) {
            object = RefData.get(Long.valueOf(string));
        } else if (this.isTextElement()) {
            object = TextElement.get(Long.valueOf(string));
        }
        return object;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        CodeType codeType = null;
        if (object instanceof CodeType) {
            codeType = (CodeType)object;
            if (codeType.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    private static void load() {
        XmlElement xmlElement = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        CodeType codeType = null;
        xmlElement = XmlElementFactory.load(PackageMarker.class, "CodeTypes.xml");
        nullFreeCollection = xmlElement.getOptionalElements("type");
        members = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            codeType = new CodeType(xmlElement2.getText("name"), xmlElement2.getText("class"), xmlElement2.getOptionalText("comments"));
            members.put(codeType.getName(), codeType);
        }
    }

    static {
        CodeType.load();
    }
}

