/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappserver.util;

import com.jronimo.util.FileMethods;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class CrossBrowserProcessor {
    private File cssDirectory;
    private File targetFile;
    private String templateText;
    private StringBuilder sbFlexDisplay = new StringBuilder();
    private StringBuilder sbFlexDirectionRow = new StringBuilder();
    private StringBuilder sbFlexDirectionColumn = new StringBuilder();
    private StringBuilder sbFlexJustifyContentStart = new StringBuilder();
    private StringBuilder sbFlexJustifyContentCenter = new StringBuilder();
    private StringBuilder sbFlexJustifyContentEnd = new StringBuilder();
    private StringBuilder sbFlexJustifyContentSpaceBetween = new StringBuilder();
    private StringBuilder sbFlexJustifyContentSpaceAround = new StringBuilder();
    private StringBuilder sbFlexAlignItemsStart = new StringBuilder();
    private StringBuilder sbFlexAlignItemsCenter = new StringBuilder();
    private StringBuilder sbFlexAlignItemsEnd = new StringBuilder();
    private StringBuilder sbFlexAlignItemsStretch = new StringBuilder();
    private StringBuilder sbFlexAlignItemsBaseline = new StringBuilder();
    private StringBuilder sbFlexAlignItems = new StringBuilder();
    private StringBuilder sbFlexZeroZero = new StringBuilder();
    private StringBuilder sbFlexZeroOne = new StringBuilder();
    private StringBuilder sbFlexOneZero = new StringBuilder();
    private StringBuilder sbFlexOneOne = new StringBuilder();
    private StringBuilder sbFlexZeroZero50 = new StringBuilder();
    private StringBuilder sbFlexZeroOne50 = new StringBuilder();
    private StringBuilder sbFlexOneZero50 = new StringBuilder();
    private StringBuilder sbFlexOneOne50 = new StringBuilder();
    private StringBuilder sbFlexWrap = new StringBuilder();
    private List<StringBuilder> stringBuilders = new ArrayList<StringBuilder>(19);
    boolean inComment;
    private List<String> fileLines;
    private List<String> selectors;

    public CrossBrowserProcessor(File file) {
        this.cssDirectory = file;
        this.targetFile = new File(file, "cross-browser-flex.css");
        this.templateText = FileMethods.readTextFile(CrossBrowserProcessor.class, "cross-browser-flex.css", true);
        this.stringBuilders.add(this.sbFlexDisplay);
        this.stringBuilders.add(this.sbFlexDirectionRow);
        this.stringBuilders.add(this.sbFlexDirectionColumn);
        this.stringBuilders.add(this.sbFlexJustifyContentStart);
        this.stringBuilders.add(this.sbFlexJustifyContentCenter);
        this.stringBuilders.add(this.sbFlexJustifyContentEnd);
        this.stringBuilders.add(this.sbFlexJustifyContentSpaceBetween);
        this.stringBuilders.add(this.sbFlexJustifyContentSpaceAround);
        this.stringBuilders.add(this.sbFlexAlignItemsStart);
        this.stringBuilders.add(this.sbFlexAlignItemsCenter);
        this.stringBuilders.add(this.sbFlexAlignItemsEnd);
        this.stringBuilders.add(this.sbFlexAlignItemsStretch);
        this.stringBuilders.add(this.sbFlexAlignItemsBaseline);
        this.stringBuilders.add(this.sbFlexAlignItems);
        this.stringBuilders.add(this.sbFlexZeroZero);
        this.stringBuilders.add(this.sbFlexZeroOne);
        this.stringBuilders.add(this.sbFlexOneZero);
        this.stringBuilders.add(this.sbFlexOneOne);
        this.stringBuilders.add(this.sbFlexZeroZero50);
        this.stringBuilders.add(this.sbFlexZeroOne50);
        this.stringBuilders.add(this.sbFlexOneZero50);
        this.stringBuilders.add(this.sbFlexOneOne50);
        this.stringBuilders.add(this.sbFlexWrap);
    }

    public void execute() {
        for (File file : this.cssDirectory.listFiles()) {
            this.processFile(file);
        }
        this.writeFile();
    }

    private void processFile(File file) {
        this.inComment = false;
        if (!file.equals(this.targetFile) && file.getName().endsWith(".css") && !file.getName().startsWith("cross-browser-")) {
            this.fileLines = FileMethods.readTextFileLines(file);
            int n = 0;
            int n2 = this.fileLines.size();
            while (n < n2) {
                n = this.processFileLine(this.fileLines.get(n).trim(), n);
            }
        }
    }

    private int processFileLine(String string, int n) {
        int n2 = n + 1;
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        this.assessForCommentCharacters(string);
        if (!(this.inComment || string.endsWith("*/") || string.startsWith("@") || !string.endsWith(",") && !string.endsWith("{"))) {
            this.selectors = new ArrayList<String>(2);
            int n3 = this.fileLines.size();
            for (int i = n = this.getSelectors(string, n); i < n3; ++i) {
                n2 = i;
                string = this.fileLines.get(i);
                this.assessForCommentCharacters(string);
                if (this.inComment) continue;
                if (string.endsWith("}")) break;
                if (!string.contains(":")) continue;
                arrayList.add(this.getPair(string));
            }
        }
        for (Pair pair : arrayList) {
            this.processPair(pair);
        }
        return n2;
    }

    private void assessForCommentCharacters(String string) {
        if (string.contains("/*")) {
            this.inComment = true;
        }
        if (string.contains("*/")) {
            this.inComment = false;
        }
        if (this.inComment) {
            // empty if block
        }
    }

    private int getSelectors(String string, int n) {
        int n2 = n + 1;
        boolean bl = false;
        bl = string.endsWith(",");
        this.selectors.add(string.substring(0, string.length() - 1).trim());
        if (bl) {
            n2 = this.getSelectors(this.fileLines.get(n2), n2);
        }
        return n2;
    }

    private Pair getPair(String string) {
        Pair pair = null;
        int n = 0;
        n = string.indexOf(":");
        pair = new Pair(string.substring(0, n), string.substring(n + 1, string.length() - 1));
        return pair;
    }

    private void processPair(Pair pair) {
        if (pair.getName().equals("display") && pair.getValue().equals("flex")) {
            this.add(this.sbFlexDisplay);
        } else if (pair.getName().equals("flex-direction")) {
            if (pair.getValue().equals("row")) {
                this.add(this.sbFlexDirectionRow);
            } else if (pair.getValue().equals("column")) {
                this.add(this.sbFlexDirectionColumn);
            }
        } else if (pair.getName().equals("justify-content")) {
            if (pair.getValue().equals("flex-start")) {
                this.add(this.sbFlexJustifyContentStart);
            } else if (pair.getValue().equals("center")) {
                this.add(this.sbFlexJustifyContentCenter);
            } else if (pair.getValue().equals("flex-end")) {
                this.add(this.sbFlexJustifyContentEnd);
            } else if (pair.getValue().equals("space-between")) {
                this.add(this.sbFlexJustifyContentSpaceBetween);
            } else if (pair.getValue().equals("space-around")) {
                this.add(this.sbFlexJustifyContentSpaceAround);
            }
        } else if (pair.getName().equals("align-items")) {
            if (pair.getValue().equals("flex-start")) {
                this.add(this.sbFlexAlignItemsStart);
            } else if (pair.getValue().equals("center")) {
                this.add(this.sbFlexAlignItemsCenter);
            } else if (pair.getValue().equals("flex-end")) {
                this.add(this.sbFlexAlignItemsEnd);
            } else if (pair.getValue().equals("stretch")) {
                this.add(this.sbFlexAlignItemsStretch);
            } else if (pair.getValue().equals("baseline")) {
                this.add(this.sbFlexAlignItemsBaseline);
            }
        } else if (pair.getName().equals("flex")) {
            if (pair.getValue().equals("0 0 auto")) {
                this.add(this.sbFlexZeroZero);
            } else if (pair.getValue().equals("0 1 auto")) {
                this.add(this.sbFlexZeroOne);
            } else if (pair.getValue().equals("1 0 auto")) {
                this.add(this.sbFlexOneZero);
            } else if (pair.getValue().equals("1 1 auto")) {
                this.add(this.sbFlexOneOne);
            } else if (pair.getValue().equals("0 0 50%")) {
                this.add(this.sbFlexZeroZero50);
            } else if (pair.getValue().equals("0 1 50%")) {
                this.add(this.sbFlexZeroOne50);
            } else if (pair.getValue().equals("1 0 50%")) {
                this.add(this.sbFlexOneZero50);
            } else if (pair.getValue().equals("1 1 50%")) {
                this.add(this.sbFlexOneOne50);
            }
        } else if (pair.getName().equals("flex-wrap")) {
            this.add(this.sbFlexWrap);
        }
    }

    private void add(StringBuilder stringBuilder) {
        for (String string : this.selectors) {
            stringBuilder.append(string).append(",\n");
        }
    }

    private void writeFile() {
        String string = null;
        for (StringBuilder stringBuilder : this.stringBuilders) {
            if (stringBuilder.length() <= 0) continue;
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        string = this.templateText;
        string = string.replaceAll("<flex-display>", this.sbFlexDisplay.toString());
        string = string.replaceAll("<flex-direction-row>", this.sbFlexDirectionRow.toString());
        string = string.replaceAll("<flex-direction-column>", this.sbFlexDirectionColumn.toString());
        string = string.replaceAll("<flex-justify-content-start>", this.sbFlexJustifyContentStart.toString());
        string = string.replaceAll("<flex-justify-content-center>", this.sbFlexJustifyContentCenter.toString());
        string = string.replaceAll("<flex-justify-content-end>", this.sbFlexJustifyContentEnd.toString());
        string = string.replaceAll("<flex-justify-content-space-between>", this.sbFlexJustifyContentSpaceBetween.toString());
        string = string.replaceAll("<flex-justify-content-space-around>", this.sbFlexJustifyContentSpaceAround.toString());
        string = string.replaceAll("<flex-align-items-start>", this.sbFlexAlignItemsStart.toString());
        string = string.replaceAll("<flex-align-items-center>", this.sbFlexAlignItemsCenter.toString());
        string = string.replaceAll("<flex-align-items-end>", this.sbFlexAlignItemsEnd.toString());
        string = string.replaceAll("<flex-align-items-stretch>", this.sbFlexAlignItemsStretch.toString());
        string = string.replaceAll("<flex-align-items-baseline>", this.sbFlexAlignItemsBaseline.toString());
        string = string.replaceAll("<flex-zero-zero>", this.sbFlexZeroZero.toString());
        string = string.replaceAll("<flex-zero-one>", this.sbFlexZeroOne.toString());
        string = string.replaceAll("<flex-one-zero>", this.sbFlexOneZero.toString());
        string = string.replaceAll("<flex-one-one>", this.sbFlexOneOne.toString());
        string = string.replaceAll("<flex-zero-zero-50>", this.sbFlexZeroZero50.toString());
        string = string.replaceAll("<flex-zero-one-50>", this.sbFlexZeroOne50.toString());
        string = string.replaceAll("<flex-one-zero-50>", this.sbFlexOneZero50.toString());
        string = string.replaceAll("<flex-one-one-50>", this.sbFlexOneOne50.toString());
        string = string.replaceAll("<flex-wrap>", this.sbFlexWrap.toString());
        FileMethods.writeTextFile(this.targetFile, string);
    }

    public static void main(String[] stringArray) {
        System.out.println("Goodbye");
    }

    private class Pair {
        private String name;
        private String value;

        private Pair(String string, String string2) {
            this.name = string.trim();
            this.value = string2.trim();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

