/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappserver.server;

import com.jronimo.util.BasicFileFilter;
import com.jronimo.util.Logger;
import com.jronimo.webappserver.server.WebAppFile;
import com.jronimo.webappserver.util.CrossBrowserProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebApp {
    private static final Logger logger = Logger.getLogger(WebApp.class);
    private String name;
    private String environment;
    private String path;
    private String cssPath;
    private int cacheDuration;
    private File location;
    private boolean authenticationRequired;
    private List<User> users;
    private boolean hasChanged;
    private List<WebAppFile> files = new ArrayList<WebAppFile>(0);

    public WebApp(String string, String string2, String string3, String string4, int n, File file, boolean bl, List<User> list) {
        this.name = string;
        this.environment = string2;
        this.path = string3;
        this.cssPath = string4;
        this.cacheDuration = n;
        this.location = file;
        this.authenticationRequired = bl;
        this.users = list;
        this.loadFiles();
        this.executeCrossBrowserProcessor();
    }

    public String getName() {
        return this.name;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean isDevelopment() {
        return this.environment.equals("development");
    }

    public boolean isPreview() {
        return this.environment.equals("preview");
    }

    public boolean isProduction() {
        return this.environment.equals("production");
    }

    public String getPath() {
        return this.path;
    }

    public String getCssPath() {
        return this.cssPath;
    }

    public File getCssDirectory() {
        return new File(this.location, this.cssPath);
    }

    public int getCacheDuration() {
        return this.cacheDuration;
    }

    public File getLocation() {
        return this.location;
    }

    public boolean authenticationRequired() {
        return this.authenticationRequired;
    }

    public boolean hasUsers() {
        return this.users != null;
    }

    public boolean hasUser(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null && this.hasUsers()) {
            for (User user : this.users) {
                if (!user.getUsername().equals(string)) continue;
                if (!user.getPassword().equals(string2)) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public synchronized boolean refresh() {
        boolean bl = false;
        bl = this.loadFiles();
        if (bl) {
            this.executeCrossBrowserProcessor();
        }
        return bl;
    }

    public synchronized WebAppFile getWebAppFile(String string) {
        return this.getWebAppFile(new File(this.location.getPath() + string));
    }

    public synchronized WebAppFile getWebAppFile(File file) {
        WebAppFile webAppFile = null;
        for (WebAppFile webAppFile2 : this.files) {
            if (!webAppFile2.getFile().equals(file)) continue;
            webAppFile = webAppFile2;
            break;
        }
        return webAppFile;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        WebApp webApp = null;
        if (object instanceof WebApp) {
            webApp = (WebApp)object;
            if (webApp.location.equals(this.location)) {
                bl = true;
            }
        }
        return bl;
    }

    private void executeCrossBrowserProcessor() {
        try {
            new CrossBrowserProcessor(this.getCssDirectory()).execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean loadFiles() {
        ArrayList<WebAppFile> arrayList = new ArrayList<WebAppFile>(100);
        boolean bl = false;
        this.hasChanged = false;
        this.loadFiles(arrayList, this.location);
        if (!this.files.isEmpty()) {
            this.hasChanged = true;
        }
        this.files = arrayList;
        bl = this.hasChanged;
        return bl;
    }

    private void loadFiles(List<WebAppFile> list, File file) {
        WebAppFile webAppFile = null;
        for (File file2 : file.listFiles(new BasicFileFilter(true, false))) {
            webAppFile = this.getWebAppFile(file2);
            if (webAppFile == null) {
                webAppFile = new WebAppFile(file2);
                this.hasChanged = true;
            } else if (webAppFile.hasChanged()) {
                this.hasChanged = true;
            }
            this.files.remove(webAppFile);
            list.add(webAppFile);
        }
        for (File file2 : file.listFiles(new BasicFileFilter(false, true))) {
            this.loadFiles(list, file2);
        }
    }

    public static class User {
        private String username;
        private String password;

        public User(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

