/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappserver.server;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.webappserver.util.Methods;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HostRedirect
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(HostRedirect.class);
    private List<Pairing> pairings = new ArrayList<Pairing>(4);

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info("Start: Init for HostRedirect...");
        try {
            this.marshalPairings(servletConfig.getInitParameter("pairings"));
        }
        catch (Throwable throwable) {
            logger.error(throwable);
        }
        logger.info("End: Init for HostRedirect.");
    }

    private void marshalPairings(String string) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        String string2 = null;
        String string3 = null;
        for (String string4 : new StringWrapper(string).split(",")) {
            nullFreeMutableList = new StringWrapper(string4).split("=");
            string2 = (String)nullFreeMutableList.getFirst();
            string3 = (String)nullFreeMutableList.getLast();
            this.pairings.add(new Pairing("www." + string2, "www." + string3));
            this.pairings.add(new Pairing(string2, string3));
        }
    }

    public void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (Methods.getString(httpServletRequest.getPathInfo()).endsWith("/ping")) {
            this.processPing(httpServletResponse);
        }
    }

    private void processPing(HttpServletResponse httpServletResponse) throws ServletException {
        httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
        try {
            httpServletResponse.getOutputStream().flush();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (Methods.getString(httpServletRequest.getPathInfo()).endsWith("/ping")) {
            this.processPing(httpServletResponse);
        } else {
            this.processRequest(httpServletRequest, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        StringWrapper stringWrapper = null;
        Pairing pairing = null;
        String string = null;
        boolean bl = true;
        try {
            stringWrapper = new StringWrapper(httpServletRequest.getRequestURL());
            for (Pairing pairing2 : this.pairings) {
                if (!stringWrapper.contains(pairing2.getSource())) continue;
                pairing = pairing2;
                break;
            }
            if (pairing == null) {
                httpServletResponse.sendError(404);
            } else {
                stringWrapper.replace(pairing.getSource(), pairing.getTarget());
                string = httpServletRequest.getQueryString();
                if (string != null) {
                    stringWrapper.append("?").append(string);
                }
                logger.debug("url: " + stringWrapper.toString());
                httpServletResponse.sendRedirect(stringWrapper.toString());
            }
        }
        catch (Throwable throwable) {
            bl = false;
            logger.error(throwable);
        }
        if (!bl) {
            httpServletResponse.setStatus(500);
        }
        try {
            httpServletResponse.getOutputStream().flush();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class Pairing {
        private String source;
        private String target;

        private Pairing(String string, String string2) {
            this.source = string;
            this.target = string2;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

