/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.home;

import com.jronimo.exceptions.BaseException;
import com.jronimo.exceptions.BaseRuntimeException;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.LibraryLifecycle;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.BaseServlet;
import com.jronimo.webappengines.Constants;
import com.jronimo.webappengines.RequestPathPortions;
import com.jronimo.webappengines.exceptions.ServerStateNotReadyException;
import com.jronimo.webappengines.exceptions.SystemOfflineException;
import com.jronimo.webappengines.home.HomeDeployment;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RouterServlet
extends BaseServlet {
    private static final Logger logger = Logger.getLogger(RouterServlet.class);
    private HomeDeployment homeDeployment;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.debug("Home RouterServlet loading...");
        try {
            this.init(servletConfig, "Home.xml");
            this.homeDeployment = HomeDeployment.createInstance(this.externalRootDirectory);
            this.acceptRequests = true;
        }
        catch (BaseRuntimeException baseRuntimeException) {
            LibraryLifecycle.shutdown();
            throw new ServletException((Throwable)baseRuntimeException);
        }
        catch (Exception exception) {
            LibraryLifecycle.shutdown();
            logger.fatal(exception);
            throw new ServletException((Throwable)exception);
        }
        logger.debug("Home RouterServlet loaded.");
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RequestPathPortions requestPathPortions = null;
        XmlElement xmlElement = null;
        try {
            if (!this.acceptRequests) {
                throw new ServerStateNotReadyException();
            }
            requestPathPortions = new RequestPathPortions(httpServletRequest, this.homeDeployment);
            httpServletRequest.setAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString(), (Object)requestPathPortions);
            switch (requestPathPortions.getResourcePathConstant()) {
                case INDEX: {
                    this.processIndex(httpServletRequest, httpServletResponse);
                    break;
                }
                case SYSTEM_CORE_URL: {
                    xmlElement = this.processSystemCoreUrl(httpServletRequest);
                }
            }
        }
        catch (BaseRuntimeException baseRuntimeException) {
            xmlElement = XmlElementFactory.create("response", baseRuntimeException.getXml());
        }
        catch (BaseException baseException) {
            xmlElement = XmlElementFactory.create("response", baseException.getXml());
        }
        catch (Exception exception) {
            xmlElement = XmlElementFactory.create("response", new UnexpectedErrorException(exception).getXml());
        }
        if (xmlElement != null) {
            this.writeResponse(httpServletResponse, xmlElement);
        }
    }

    private void processIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = false;
        String string = null;
        String string2 = null;
        RequestDispatcher requestDispatcher = null;
        try {
            string = bl ? this.homeDeployment.getAppletUrl(httpServletRequest, httpServletResponse) : this.homeDeployment.getIndexUrl(httpServletRequest, httpServletResponse);
            httpServletRequest.setAttribute("url", (Object)string);
            string2 = "index.jsp";
        }
        catch (SystemOfflineException systemOfflineException) {
            httpServletRequest.setAttribute("systemName", (Object)systemOfflineException.getSystemName());
            httpServletRequest.setAttribute("backOnline", (Object)systemOfflineException.getBackOnline());
            string2 = "offline.jsp";
        }
        requestDispatcher = httpServletRequest.getRequestDispatcher(string2);
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    private XmlElement processSystemCoreUrl(HttpServletRequest httpServletRequest) throws Exception {
        XmlElement xmlElement = null;
        HomeDeployment.System system = null;
        String string = null;
        system = this.homeDeployment.getSystemByIdentifier(((RequestPathPortions)httpServletRequest.getAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString())).getSystemIdentifier());
        string = this.homeDeployment.getSystemUrl(httpServletRequest, system);
        xmlElement = XmlElementFactory.create("response");
        xmlElement.addElement("url").setText(string);
        xmlElement.addElement("https-available").setBoolean(system.isHttpsAvailable());
        return xmlElement;
    }

    public void destroy() {
        this.homeDeployment.destroy();
        super.destroy();
    }
}

