/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.home;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.http.HttpGet;
import com.jronimo.http.UrlParts;
import com.jronimo.temporal.Constants;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.text.ResourceText;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.Constants;
import com.jronimo.webappengines.RequestPathPortions;
import com.jronimo.webappengines.ResourceTextIdentifiers;
import com.jronimo.webappengines.SystemsInfoManager;
import com.jronimo.webappengines.exceptions.SystemOfflineException;
import com.jronimo.webappengines.exceptions.UnrecognizedSystemException;
import com.jronimo.webappengines.home.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HomeDeployment
implements SystemsInfoManager {
    private static final Logger logger = Logger.getLogger(HomeDeployment.class);
    private static HomeDeployment instance;
    private System defaultSystem;
    private Map<String, System> systemsByIdentifier = new HashMap<String, System>(1);
    private Map<String, System> systemsByName = new HashMap<String, System>(1);
    private Collection<UrlMonitor> urlMonitors;

    HomeDeployment(System system, Collection<System> collection, Collection<UrlMonitor> collection2) {
        this.defaultSystem = system;
        this.urlMonitors = collection2;
        for (System object : collection) {
            this.systemsByIdentifier.put(object.getIdentifier(), object);
            this.systemsByName.put(object.getName(), object);
        }
        for (UrlMonitor urlMonitor : collection2) {
            urlMonitor.start();
        }
    }

    static HomeDeployment getInstance() {
        return instance;
    }

    static synchronized HomeDeployment createInstance(File file) {
        XmlElement xmlElement = null;
        String string = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        HashSet<System> hashSet = null;
        System system = null;
        System system2 = null;
        HashSet<UrlMonitor> hashSet2 = null;
        if (instance == null) {
            xmlElement = XmlElementFactory.load(new File(file, "Home.xml"));
            string = xmlElement.getOptionalText("default-system");
            nullFreeCollection = xmlElement.getOptionalElements("systems/system");
            hashSet = new HashSet<System>(nullFreeCollection.size());
            hashSet2 = new HashSet<UrlMonitor>();
            for (XmlElement xmlElement2 : nullFreeCollection) {
                system = HomeDeployment.loadSystemElement(xmlElement2, hashSet2);
                hashSet.add(system);
                if (!system.getIdentifier().equals(string)) continue;
                system2 = system;
            }
            instance = new HomeDeployment(system2, hashSet, hashSet2);
        }
        return instance;
    }

    private static System loadSystemElement(XmlElement xmlElement, Collection<UrlMonitor> collection) {
        System system = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        int n = 0;
        String string5 = null;
        int n2 = 0;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        HashSet<Url> hashSet = null;
        UrlMonitorStruct urlMonitorStruct = null;
        String string6 = null;
        UrlMonitor urlMonitor = null;
        string = xmlElement.getText("identifier");
        string2 = xmlElement.getText("name");
        string3 = xmlElement.getText("display-name");
        bl = xmlElement.getBoolean("https-available");
        string4 = xmlElement.getText("index-page-protocol");
        n = xmlElement.getInteger("index-page-version");
        string5 = xmlElement.getText("applet-page-protocol");
        n2 = xmlElement.getInteger("applet-page-version");
        nullFreeCollection = xmlElement.getElements("urls/url");
        hashSet = new HashSet<Url>(nullFreeCollection.size());
        for (XmlElement object : nullFreeCollection) {
            hashSet.add(new Url(object.getText()));
        }
        urlMonitorStruct = new UrlMonitorStruct();
        urlMonitorStruct.protocol = xmlElement.getText("url-monitoring/protocol");
        urlMonitorStruct.requestPath = xmlElement.getText("url-monitoring/request-path");
        urlMonitorStruct.initialDelay = xmlElement.getLong("url-monitoring/initial-delay");
        urlMonitorStruct.interval = xmlElement.getByte("url-monitoring/interval") * Constants.UnitOfTime.MINUTE.getMilliseconds();
        urlMonitorStruct.offlineInterval = xmlElement.getLong("url-monitoring/offline-interval");
        urlMonitorStruct.connectionTimeout = xmlElement.getInteger("url-monitoring/connection-timeout");
        system = new System(string, string2, string3, bl, string4, n, string5, n2, hashSet);
        for (Url url : hashSet) {
            string6 = urlMonitorStruct.protocol + "://" + url.toString() + urlMonitorStruct.requestPath + "?si=" + system.getIdentifier();
            urlMonitor = new UrlMonitor(system, string6, urlMonitorStruct);
            collection.add(urlMonitor);
        }
        return system;
    }

    String getIndexUrl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = null;
        System system = null;
        system = this.getSystemByIdentifier(((RequestPathPortions)httpServletRequest.getAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString())).getSystemIdentifier());
        string = system.getIndexPageProtocol() + "://" + this.getSystemUrlForPage(httpServletRequest, httpServletResponse) + "/fileservice-file";
        string = Methods.addQueryStringElement(string, "si", system.getIdentifier());
        string = Methods.addQueryStringElement(string, "file", "/index.html?pv=" + system.getIndexPageVersion());
        return string;
    }

    String getAppletUrl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = null;
        System system = null;
        system = this.getSystemByIdentifier(((RequestPathPortions)httpServletRequest.getAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString())).getSystemIdentifier());
        string = system.getAppletPageProtocol() + "://" + this.getSystemUrlForPage(httpServletRequest, httpServletResponse) + "/fileservice-file";
        string = Methods.addQueryStringElement(string, "si", system.getIdentifier());
        string = Methods.addQueryStringElement(string, "file", "/applet.html?pv=" + system.getAppletPageVersion());
        return string;
    }

    private String getSystemUrlForPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = null;
        System system = null;
        Cookie cookie = null;
        system = this.getSystemByIdentifier(((RequestPathPortions)httpServletRequest.getAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString())).getSystemIdentifier());
        if (!system.isOnline() && (cookie = Methods.getCookie(httpServletRequest, Constants.CookieKeys.SYSTEM_URL.toString())) != null) {
            string = cookie.getValue();
        }
        if (string == null) {
            string = this.getSystemUrl(httpServletRequest, system, true);
            cookie = new Cookie(Constants.CookieKeys.SYSTEM_URL.toString(), string);
            cookie.setMaxAge(Integer.MAX_VALUE);
            httpServletResponse.addCookie(cookie);
        }
        return string;
    }

    String getSystemUrl(HttpServletRequest httpServletRequest, System system) throws Exception {
        return this.getSystemUrl(httpServletRequest, system, false);
    }

    private String getSystemUrl(HttpServletRequest httpServletRequest, System system, boolean bl) throws Exception {
        String string = null;
        Url url = null;
        StringFormat.TimeFormat timeFormat = null;
        String string2 = null;
        if (system.isOnline() && (url = system.getUrl(httpServletRequest, bl)) != null) {
            string = url.toString();
        }
        if (string == null) {
            if (system.getBackOnline() == null) {
                string2 = ResourceText.getText((Object)com.jronimo.text.ResourceTextIdentifiers.UNKNOWN);
            } else {
                timeFormat = new StringFormat.TimeFormat(true);
                timeFormat.setTimeFormatIfNull(Constants.TimeFormat.HHMMSS);
                string2 = system.getBackOnline().getString(new StringFormat(timeFormat));
            }
            string2 = ResourceText.getText((Object)ResourceTextIdentifiers.BACK_ONLINE_IN, (Object[])new String[]{string2});
            throw new SystemOfflineException(system.getName(), string2);
        }
        return string;
    }

    @Override
    public System getSystemByName(String string) {
        System system = null;
        if (string == null && this.defaultSystem != null) {
            string = this.defaultSystem.getName();
        }
        if ((system = this.systemsByName.get(string)) == null) {
            throw new UnrecognizedSystemException(string);
        }
        return system;
    }

    @Override
    public System getSystemByIdentifier(String string) {
        System system = null;
        if (string == null && this.defaultSystem != null) {
            string = this.defaultSystem.getIdentifier();
        }
        if ((system = this.systemsByIdentifier.get(string)) == null) {
            throw new UnrecognizedSystemException(string);
        }
        return system;
    }

    @Override
    public System getDefaultSystem() {
        return this.defaultSystem;
    }

    void destroy() {
        for (UrlMonitor urlMonitor : this.urlMonitors) {
            urlMonitor.finish();
        }
    }

    private static final class UrlMonitor
    extends Thread {
        private System system;
        private String url;
        private UrlMonitorStruct struct;
        private boolean finished;

        protected UrlMonitor(System system, String string, UrlMonitorStruct urlMonitorStruct) {
            this.system = system;
            this.url = string;
            this.struct = urlMonitorStruct;
        }

        public void run() {
            UrlInfo urlInfo = null;
            try {
                Methods.sleep(this.struct.initialDelay);
                urlInfo = UrlMonitor.unsynchronizedContactUrl(this.url);
                this.system.update(new Url(this.url, urlInfo));
                while (!this.finished) {
                    Thread.sleep(urlInfo.urlIsAvailable() ? this.struct.interval : this.struct.offlineInterval);
                    if (this.finished) continue;
                    urlInfo = UrlMonitor.synchronizedContactUrl(this.url);
                    this.system.update(new Url(this.url, urlInfo));
                }
            }
            catch (Exception exception) {
                this.finished = true;
            }
        }

        public void finish() {
            this.finished = true;
            this.interrupt();
        }

        public boolean isFinished() {
            return this.finished;
        }

        private static synchronized UrlInfo synchronizedContactUrl(String string) {
            return UrlMonitor.unsynchronizedContactUrl(string);
        }

        private static UrlInfo unsynchronizedContactUrl(String string) {
            UrlInfo urlInfo;
            block6: {
                urlInfo = null;
                HttpGet httpGet = null;
                XmlElement xmlElement = null;
                boolean bl = false;
                try {
                    string = Methods.addQueryStringElement(string, "v", String.valueOf(java.lang.System.currentTimeMillis()));
                    httpGet = new HttpGet(new UrlParts(string));
                    httpGet.execute();
                    if (httpGet.isHttpResponseOk()) {
                        xmlElement = XmlElementFactory.load(httpGet.getReturnedBytes());
                        if (xmlElement.getName().equals("response")) {
                            bl = xmlElement.getBoolean("available");
                            urlInfo = bl ? new UrlInfo(xmlElement.getOptionalInteger("cpu-usage"), xmlElement.getOptionalInteger("memory-usage")) : new UrlInfo(xmlElement.getOptionalTime("back-online"));
                            break block6;
                        }
                        try {
                            logger.error("Unexpected XML response: " + xmlElement.toBasicString());
                        }
                        catch (Exception exception) {
                            logger.error(exception);
                        }
                        urlInfo = new UrlInfo();
                        break block6;
                    }
                    urlInfo = new UrlInfo();
                }
                catch (Exception exception) {
                    urlInfo = new UrlInfo();
                }
            }
            return urlInfo;
        }
    }

    private static class UrlInfo {
        private boolean urlIsOnline;
        private boolean urlIsAvailable;
        private Time backOnline;
        private boolean urlHasUsageStats;
        private Integer cpuUsage;
        private Integer memoryUsage;

        UrlInfo() {
        }

        UrlInfo(Time time) {
            this.urlIsOnline = true;
            this.backOnline = time;
        }

        UrlInfo(Integer n, Integer n2) {
            this.urlIsOnline = true;
            this.urlIsAvailable = true;
            boolean bl = this.urlHasUsageStats = n != null && n2 != null;
            if (this.urlHasUsageStats) {
                this.cpuUsage = n;
                this.memoryUsage = n2;
            }
        }

        boolean urlIsOnline() {
            return this.urlIsOnline;
        }

        boolean urlIsAvailable() {
            return this.urlIsAvailable;
        }

        Time getBackOnline() {
            return this.backOnline;
        }

        boolean urlHasUsageStats() {
            return this.urlHasUsageStats;
        }

        int getCpuUsage() {
            return this.cpuUsage;
        }

        int getMemoryUsage() {
            return this.memoryUsage;
        }

        int getAverage() {
            return (int)Math.ceil((float)(this.cpuUsage + this.memoryUsage) / 2.0f);
        }

        public String toString() {
            StringBuilder stringBuilder = null;
            stringBuilder = new StringBuilder();
            stringBuilder.append("UrlInfo");
            stringBuilder.append("\n\t urlIsOnline: " + this.urlIsOnline);
            stringBuilder.append("\n\t urlIsAvailable: " + this.urlIsAvailable);
            stringBuilder.append("\n\t backOnline: " + this.backOnline);
            stringBuilder.append("\n\t urlHasUsageStats: " + this.urlHasUsageStats);
            stringBuilder.append("\n\t cpuUsage: " + this.cpuUsage);
            stringBuilder.append("\n\t memoryUsage: " + this.memoryUsage);
            return stringBuilder.toString();
        }
    }

    private static class Url {
        private String url;
        private UrlInfo urlInfo;

        Url(String string) {
            this.url = string;
        }

        Url(String string, UrlInfo urlInfo) {
            this.url = string;
            this.urlInfo = urlInfo;
            logger.debug(urlInfo);
        }

        void setUrlInfo(UrlInfo urlInfo) {
            this.urlInfo = urlInfo;
        }

        boolean hasUrlInfo() {
            return this.urlInfo != null;
        }

        UrlInfo getUrlInfo() {
            return this.urlInfo;
        }

        public String toString() {
            return this.url;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class System
    implements SystemsInfoManager.System {
        private String identifier;
        private String name;
        private String displayName;
        private boolean httpsAvailable;
        private String indexPageProtocol;
        private int indexPageVersion;
        private String appletPageProtocol;
        private int appletPageVersion;
        private Collection<Url> urls;
        private boolean isOnline;
        private Time backOnline;

        private System(String string, String string2, String string3, boolean bl, String string4, int n, String string5, int n2, Collection<Url> collection) {
            this.identifier = string;
            this.name = string2;
            this.displayName = string3;
            this.httpsAvailable = bl;
            this.indexPageProtocol = string4;
            this.indexPageVersion = n;
            this.appletPageProtocol = string5;
            this.appletPageVersion = n2;
            this.urls = collection;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isHttpsAvailable() {
            return this.httpsAvailable;
        }

        public String getIndexPageProtocol() {
            return this.indexPageProtocol;
        }

        int getIndexPageVersion() {
            return this.indexPageVersion;
        }

        public String getAppletPageProtocol() {
            return this.appletPageProtocol;
        }

        int getAppletPageVersion() {
            return this.appletPageVersion;
        }

        boolean isOnline() {
            return this.isOnline;
        }

        Time getBackOnline() {
            return this.backOnline;
        }

        Url getUrl(HttpServletRequest httpServletRequest, boolean bl) {
            Url url = null;
            Url url2 = null;
            UrlInfo urlInfo = null;
            int n = 100;
            HashSet<Url> hashSet = null;
            if (bl) {
                url = this.getCookieUrl(httpServletRequest);
            }
            if (url == null) {
                if (this.urls.size() == 1) {
                    url2 = (Url)CollectionUtils.getCollectionElement(this.urls, 0);
                    if (url2.hasUrlInfo() && (urlInfo = url2.getUrlInfo()).urlIsOnline() && urlInfo.urlIsAvailable()) {
                        url = url2;
                    }
                } else {
                    for (Url url3 : this.urls) {
                        if (!url3.hasUrlInfo() || !(urlInfo = url3.getUrlInfo()).urlIsOnline() || !urlInfo.urlIsAvailable() || !urlInfo.urlHasUsageStats() || urlInfo.getCpuUsage() >= 80 || urlInfo.getMemoryUsage() >= 80 || urlInfo.getAverage() >= n) continue;
                        url = url3;
                        n = urlInfo.getAverage();
                    }
                    if (url == null) {
                        n = 100;
                        for (Url url3 : this.urls) {
                            if (!url3.hasUrlInfo() || !(urlInfo = url3.getUrlInfo()).urlIsOnline() || !urlInfo.urlIsAvailable() || !urlInfo.urlHasUsageStats() || urlInfo.getAverage() >= n) continue;
                            url = url3;
                            n = urlInfo.getAverage();
                        }
                    }
                    if (url == null) {
                        hashSet = new HashSet<Url>(this.urls.size());
                        for (Url url3 : this.urls) {
                            if (!url3.hasUrlInfo() || !(urlInfo = url3.getUrlInfo()).urlIsOnline() || !urlInfo.urlIsAvailable()) continue;
                            hashSet.add(url3);
                        }
                        url = (Url)CollectionUtils.getRandomMember(hashSet);
                    }
                }
            }
            return url;
        }

        Url getCookieUrl(HttpServletRequest httpServletRequest) {
            Url url = null;
            Cookie cookie = null;
            UrlInfo urlInfo = null;
            cookie = Methods.getCookie(httpServletRequest, Constants.CookieKeys.SYSTEM_URL.toString());
            if (cookie != null) {
                for (Url url2 : this.urls) {
                    if (!url2.toString().equals(cookie.getValue())) continue;
                    if (!url2.hasUrlInfo() || !(urlInfo = url2.getUrlInfo()).urlHasUsageStats() || urlInfo.getCpuUsage() >= 80 || urlInfo.getMemoryUsage() >= 80) break;
                    url = url2;
                    break;
                }
            }
            return url;
        }

        synchronized void update(Url url) {
            UrlInfo urlInfo = null;
            boolean bl = false;
            Time time = null;
            Long l = null;
            ValueStruct valueStruct = null;
            for (Url url2 : this.urls) {
                if (url.toString().indexOf(url2.toString()) >= 0) {
                    url2.setUrlInfo(url.getUrlInfo());
                }
                if (!url2.hasUrlInfo() || !(urlInfo = url2.getUrlInfo()).urlIsOnline() || !urlInfo.urlIsAvailable()) continue;
                bl = true;
            }
            this.isOnline = bl;
            if (!bl) {
                for (Url url2 : this.urls) {
                    if (!url2.hasUrlInfo() || (time = (urlInfo = url2.getUrlInfo()).getBackOnline()) == null) continue;
                    if (l == null) {
                        l = time.getMillisecondValue();
                        continue;
                    }
                    l = Math.min(l, time.getMillisecondValue());
                }
                if (l == null) {
                    this.backOnline = null;
                } else {
                    valueStruct = new ValueStruct();
                    valueStruct.millisecondValue = l;
                    this.backOnline = new Time(valueStruct);
                }
            }
        }
    }

    private static class UrlMonitorStruct {
        public String protocol;
        public String requestPath;
        public long initialDelay;
        public long interval;
        public long offlineInterval;
        public int connectionTimeout;

        private UrlMonitorStruct() {
        }
    }
}

