/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.SystemsInfoManager;
import com.jronimo.webappengines.exceptions.UnrecognizedSystemException;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemsContainerDeployment
implements SystemsInfoManager {
    private static final Logger logger = Logger.getLogger(SystemsContainerDeployment.class);
    private static SystemsContainerDeployment instance;
    private File rootDirectory;
    private String webApplicationUrl;
    private boolean httpsAvailable;
    private System defaultSystem;
    private Collection<System> systems = null;
    private Map<String, System> systemsByIdentifier = new HashMap<String, System>(1);
    private Map<String, System> systemsByName = new HashMap<String, System>(1);
    private File fileServiceKernelRoot;

    SystemsContainerDeployment(File file, String string, boolean bl, System system, Collection<System> collection) {
        this.rootDirectory = file;
        this.webApplicationUrl = string;
        this.httpsAvailable = bl;
        this.defaultSystem = system;
        this.systems = collection;
        for (System system2 : collection) {
            this.systemsByIdentifier.put(system2.getIdentifier(), system2);
            this.systemsByName.put(system2.getName(), system2);
        }
        this.fileServiceKernelRoot = new File(file, "file-service-kernel-files");
    }

    public static SystemsContainerDeployment getInstance() {
        return instance;
    }

    static synchronized SystemsContainerDeployment createInstance(File file, String string) {
        XmlElement xmlElement = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        HashSet<System> hashSet = null;
        System system = null;
        System system2 = null;
        if (instance == null) {
            if (string.length() == 1) {
                string = "";
            }
            xmlElement = XmlElementFactory.load(new File(file, "SystemsContainer.xml"));
            string2 = xmlElement.getOptionalText("host") + string;
            bl = xmlElement.getBoolean("https-available");
            string3 = xmlElement.getOptionalText("default-system");
            nullFreeCollection = xmlElement.getOptionalElements("systems/system");
            hashSet = new HashSet<System>(nullFreeCollection.size());
            for (XmlElement xmlElement2 : nullFreeCollection) {
                system = SystemsContainerDeployment.loadSystemElement(xmlElement2);
                hashSet.add(system);
                if (!system.getIdentifier().equals(string3)) continue;
                system2 = system;
            }
            instance = new SystemsContainerDeployment(file, string2, bl, system2, hashSet);
        }
        return instance;
    }

    private static System loadSystemElement(XmlElement xmlElement) {
        System system = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        string = xmlElement.getText("identifier");
        string2 = xmlElement.getText("name");
        string3 = xmlElement.getText("display-name");
        system = new System(string, string2, string3);
        return system;
    }

    public Collection<System> getSystems() {
        return this.systems;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public boolean isHttpsAvailable() {
        return this.httpsAvailable;
    }

    public File getFileServiceKernelRoot() {
        return this.fileServiceKernelRoot;
    }

    public String getWebApplicationUrl() {
        return this.webApplicationUrl;
    }

    @Override
    public System getSystemByName(String string) {
        System system = null;
        if (string == null && this.defaultSystem != null) {
            string = this.defaultSystem.getName();
        }
        if ((system = this.systemsByName.get(string)) == null) {
            throw new UnrecognizedSystemException(string);
        }
        return system;
    }

    @Override
    public System getSystemByIdentifier(String string) {
        System system = null;
        if (string == null && this.defaultSystem != null) {
            string = this.defaultSystem.getIdentifier();
        }
        if ((system = this.systemsByIdentifier.get(string)) == null) {
            throw new UnrecognizedSystemException(string);
        }
        return system;
    }

    @Override
    public System getDefaultSystem() {
        return this.defaultSystem;
    }

    void destroy() {
    }

    static class System
    implements SystemsInfoManager.System {
        private String identifier;
        private String name;
        private String displayName;

        private System(String string, String string2, String string3) {
            this.identifier = string;
            this.name = string2;
            this.displayName = string3;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

