/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.engines.dataservice.DataService;
import com.jronimo.engines.dataservice.UserSecurityContext;
import com.jronimo.engines.fileservice.FileService;
import com.jronimo.internationalization.Language;
import com.jronimo.internationalization.Languages;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.temporal.Timezone;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.Constants;
import com.jronimo.webappengines.core.DataServiceRequest;
import com.jronimo.webappengines.core.FileServiceRequest;
import com.jronimo.webappengines.core.Session;
import com.jronimo.webappengines.core.SessionManager;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.Locale;

public class SystemDeployment {
    private static final Logger logger = Logger.getLogger(SystemDeployment.class);
    private String systemIdentifier;
    private Constants.SystemEnvironment environment;
    private int numberOfTickets;
    private Timezone systemTimezone;
    private Language defaultLanguage;
    private Locale defaultLocale;
    private String systemHomeUrl;
    private DataService dataService;
    private FileService fileService;
    private SessionManager sessionManager;

    SystemDeployment(String string, Constants.SystemEnvironment systemEnvironment, int n, Timezone timezone, Language language, Locale locale, String string2) {
        this.systemIdentifier = string;
        this.environment = systemEnvironment;
        this.numberOfTickets = n;
        this.systemTimezone = timezone;
        this.defaultLanguage = language;
        this.defaultLocale = locale;
        this.systemHomeUrl = string2;
        this.sessionManager = new SessionManager(this);
    }

    static SystemDeployment createInstance(File file) throws Exception {
        SystemDeployment systemDeployment = null;
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        String string = null;
        SimpleNameFormat simpleNameFormat = null;
        Constants.SystemEnvironment systemEnvironment = null;
        int n = 0;
        int n2 = 0;
        Timezone timezone = null;
        String string2 = null;
        String string3 = null;
        Language language = null;
        String[] stringArray = null;
        Locale locale = null;
        String string4 = null;
        DataService dataService = null;
        FileService fileService = null;
        xmlElement = XmlElementFactory.load(file);
        xmlElement2 = xmlElement.getElement("system");
        string = xmlElement2.getText("system-identifier");
        simpleNameFormat = new SimpleNameFormat(xmlElement2.getText("environment"));
        systemEnvironment = Constants.SystemEnvironment.valueOf(simpleNameFormat.getUpperCase());
        n = xmlElement2.getOptionalInteger("tickets", "0");
        n2 = xmlElement2.getOptionalInteger("system-timezone", "0");
        timezone = Timezone.getTimezone(n2);
        string2 = xmlElement2.getText("default-language");
        string3 = xmlElement2.getOptionalText("default-language-variation", null);
        language = string3 == null ? Languages.getInstance().getPrimary(string2) : Languages.getInstance().getVariation(string2, string3);
        stringArray = xmlElement2.getText("default-locale").split("_");
        locale = new Locale(stringArray[0], stringArray[1]);
        string4 = xmlElement2.getText("home-url");
        systemDeployment = new SystemDeployment(string, systemEnvironment, n, timezone, language, locale, string4);
        dataService = DataService.createInstance(systemDeployment, new File(file.getParent(), "DataService"));
        fileService = FileService.createInstance(systemDeployment, new File(file.getParent(), "FileService"));
        systemDeployment.dataService = dataService;
        systemDeployment.fileService = fileService;
        return systemDeployment;
    }

    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public Constants.SystemEnvironment getEnvironment() {
        return this.environment;
    }

    public int getNumberOfTickets() {
        return this.numberOfTickets;
    }

    public Timezone getSystemTimezone() {
        return this.systemTimezone;
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public String getSystemHomeUrl() {
        return this.systemHomeUrl;
    }

    SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public UserSecurityContext authenticate(String string, String string2) {
        UserSecurityContext userSecurityContext = null;
        userSecurityContext = this.dataService.authenticate(string, string2);
        return userSecurityContext;
    }

    public XmlElement processDataServiceRequest(Session session, DataServiceRequest dataServiceRequest) throws Exception {
        XmlElement xmlElement = null;
        xmlElement = this.dataService.processRequest(session, dataServiceRequest.getElement());
        return xmlElement;
    }

    public byte[] processFileServiceRequest(FileServiceRequest fileServiceRequest) throws Exception {
        byte[] byArray = null;
        byArray = this.fileService.processRequest(fileServiceRequest);
        return byArray;
    }
}

