/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.engines.dataservice.UserSecurityContext;
import com.jronimo.internationalization.Language;
import com.jronimo.internationalization.Languages;
import com.jronimo.util.EncryptionUtils;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.DataServiceRequest;
import com.jronimo.webappengines.core.Methods;
import com.jronimo.webappengines.core.Session;
import com.jronimo.webappengines.core.SystemDeployment;
import com.jronimo.webappengines.core.exceptions.UnrecognizedSessionIdException;
import com.jronimo.xml.XmlElement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

final class SessionManager {
    private static final Logger logger = Logger.getLogger(SessionManager.class);
    private SystemDeployment systemDeployment;
    private Map<String, Session> sessions = new HashMap<String, Session>(100);

    SessionManager(SystemDeployment systemDeployment) {
        this.systemDeployment = systemDeployment;
    }

    NewSessionReturnStruct createSession(DataServiceRequest dataServiceRequest) {
        NewSessionReturnStruct newSessionReturnStruct = null;
        NewSessionStruct newSessionStruct = null;
        UserSecurityContext userSecurityContext = null;
        Session session = null;
        newSessionStruct = this.getNewSessionStruct(dataServiceRequest.getElement());
        userSecurityContext = this.systemDeployment.authenticate(newSessionStruct.username, newSessionStruct.password);
        session = new Session(userSecurityContext, newSessionStruct.language, newSessionStruct.locale, this.systemDeployment.getNumberOfTickets(), dataServiceRequest.getIp(), this.systemDeployment.getSystemTimezone());
        this.sessions.put(session.getSessionId(), session);
        newSessionReturnStruct = new NewSessionReturnStruct();
        newSessionReturnStruct.session = session;
        newSessionReturnStruct.element = Methods.prepareNewSessionXml(session, newSessionStruct, this.systemDeployment.getNumberOfTickets());
        return newSessionReturnStruct;
    }

    void destroySession(Session session) {
        session.destroy();
        this.sessions.remove(session.getSessionId());
    }

    Session vetRequest(DataServiceRequest dataServiceRequest) throws Exception {
        Session session = null;
        session = this.sessions.get(dataServiceRequest.getSessionId());
        if (session == null) {
            throw new UnrecognizedSessionIdException();
        }
        session.vetRequest(dataServiceRequest);
        return session;
    }

    private NewSessionStruct getNewSessionStruct(XmlElement xmlElement) {
        NewSessionStruct newSessionStruct = null;
        XmlElement xmlElement2 = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl2 = false;
        String string7 = null;
        EncryptionUtils.DigestStruct digestStruct = null;
        String[] stringArray = null;
        int n = -1;
        xmlElement2 = xmlElement.getElement("new-session");
        string = xmlElement2.getText("credentials/username");
        string2 = xmlElement2.getText("credentials/password");
        bl = xmlElement2.getOptionalBoolean("password-hashed", "false");
        string3 = xmlElement2.getOptionalText("device-id", null);
        string4 = xmlElement2.getOptionalText("language", null);
        string5 = xmlElement2.getOptionalText("language-variation", null);
        string6 = xmlElement2.getOptionalText("locale", null);
        bl2 = xmlElement2.getOptionalBoolean("return-security-context", "false");
        string7 = xmlElement2.getOptionalText("permission-ids", null);
        if (!bl) {
            digestStruct = new EncryptionUtils.DigestStruct();
            digestStruct.encoding = EncryptionUtils.Encoding.HEX;
            digestStruct.string = string2;
            string2 = EncryptionUtils.createDigest(digestStruct);
        }
        newSessionStruct = new NewSessionStruct();
        newSessionStruct.username = string;
        newSessionStruct.password = string2;
        newSessionStruct.deviceId = string3;
        newSessionStruct.language = string4 == null ? this.systemDeployment.getDefaultLanguage() : (string5 == null ? Languages.getInstance().getPrimary(string4) : Languages.getInstance().getVariation(string4, string5));
        if (newSessionStruct.language == null) {
            newSessionStruct.language = this.systemDeployment.getDefaultLanguage();
        }
        if (string6 == null || string6.length() != 5 || string6.indexOf("_") != 2) {
            newSessionStruct.locale = this.systemDeployment.getDefaultLocale();
        } else {
            stringArray = string6.split("_");
            newSessionStruct.locale = new Locale(stringArray[0], stringArray[1]);
        }
        if (newSessionStruct.locale == null) {
            newSessionStruct.locale = this.systemDeployment.getDefaultLocale();
        }
        newSessionStruct.returnSecurityContext = bl2;
        if (string7 == null) {
            newSessionStruct.permissionIds = null;
        } else if (string7.length() == 0) {
            newSessionStruct.permissionIds = new long[0];
        } else {
            stringArray = string7.split(",");
            newSessionStruct.permissionIds = new long[stringArray.length];
            for (String string8 : stringArray) {
                newSessionStruct.permissionIds[++n] = Long.valueOf(string8);
            }
        }
        return newSessionStruct;
    }

    public static class NewSessionReturnStruct {
        public Session session;
        public XmlElement element;
    }

    public static class NewSessionStruct {
        public String username;
        public String password;
        public String deviceId;
        public Language language;
        public Locale locale;
        public boolean returnSecurityContext;
        public long[] permissionIds;
    }
}

