/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.engines.dataservice.UserSecurityContext;
import com.jronimo.internationalization.Language;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.Timezone;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.DataServiceRequest;
import com.jronimo.webappengines.core.Methods;
import com.jronimo.webappengines.core.exceptions.IpMismatchException;
import com.jronimo.webappengines.core.exceptions.UnrecognizedInteractionTicketException;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Session {
    private static final Logger logger = Logger.getLogger(Session.class);
    private static final int PREFERRED_TICKET_QUANTITY = 100;
    private String sessionId = Methods.getNewSessionId();
    private UserSecurityContext userSecurityContext;
    private Language language = null;
    private Locale locale = null;
    private int numberOfTicketsPerRequest;
    private String ip;
    private Timezone systemTimezone;
    private DateTime creationTimestamp;
    private DateTime lastTouchTimestamp;
    private Set<String> tickets;

    Session(UserSecurityContext userSecurityContext, Language language, Locale locale, int n, String string, Timezone timezone) {
        this.userSecurityContext = userSecurityContext;
        this.language = language;
        this.locale = locale;
        this.numberOfTicketsPerRequest = n;
        this.ip = string;
        this.systemTimezone = timezone;
        this.lastTouchTimestamp = this.creationTimestamp = DateTime.now(timezone.getId());
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UserSecurityContext getUserSecurityContext() {
        return this.userSecurityContext;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getIp() {
        return this.ip;
    }

    DateTime getLastTouchTimestamp() {
        return this.lastTouchTimestamp;
    }

    void destroy() {
    }

    UserSecurityContext vetRequest(DataServiceRequest dataServiceRequest) {
        UserSecurityContext userSecurityContext = null;
        boolean bl = false;
        if (!this.ip.equals(dataServiceRequest.getIp())) {
            throw new IpMismatchException(this);
        }
        if (this.numberOfTicketsPerRequest > 0) {
            if (dataServiceRequest.getInteractionTickets().size() < this.numberOfTicketsPerRequest) {
                bl = true;
            } else {
                for (String string : dataServiceRequest.getInteractionTickets()) {
                    if (this.tickets.remove(string)) continue;
                    bl = true;
                }
            }
            if (bl) {
                throw new UnrecognizedInteractionTicketException(this);
            }
        }
        this.lastTouchTimestamp = DateTime.now(this.systemTimezone.getId());
        userSecurityContext = this.userSecurityContext;
        return userSecurityContext;
    }

    Set<String> getNewTickets() {
        Set<String> set = null;
        if (this.numberOfTicketsPerRequest > 0) {
            if (this.tickets == null) {
                set = Methods.getInteractionTickets(this.numberOfTicketsPerRequest * 100);
                this.tickets = set;
            } else if (this.tickets.size() < (int)((double)(this.numberOfTicketsPerRequest * 100) * 0.3)) {
                set = Methods.getInteractionTickets(this.numberOfTicketsPerRequest * 100 - this.tickets.size());
                this.tickets.addAll(set);
            }
        }
        return set;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Session session = null;
        if (object instanceof Session) {
            session = (Session)object;
            if (session.sessionId.equals(this.sessionId)) {
                bl = true;
            }
        }
        return bl;
    }
}

