/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.ResourceTextIdentifiers;
import com.jronimo.webappengines.core.DataServiceRequest;
import com.jronimo.webappengines.core.ErrorRequest;
import com.jronimo.webappengines.core.FileServiceRequest;
import com.jronimo.webappengines.core.Methods;
import com.jronimo.webappengines.core.MisUseFilter;
import com.jronimo.webappengines.core.Session;
import com.jronimo.webappengines.core.SessionManager;
import com.jronimo.webappengines.core.SystemDeployment;
import com.jronimo.webappengines.core.SystemsContainerDeployment;
import com.jronimo.webappengines.core.exceptions.IllegalRequestFormatException;
import com.jronimo.webappengines.core.exceptions.SecurityFilterException;
import com.jronimo.webappengines.core.exceptions.UnrecognizedRequestTypeException;
import com.jronimo.webappengines.exceptions.ClientInteractionException;
import com.jronimo.webappengines.exceptions.UnrecognizedSystemException;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestDirector {
    private static final Logger logger = Logger.getLogger(RequestDirector.class);
    private static RequestDirector instance;
    private File systemsContainerRoot;
    private String defaultSystemIdentifier;
    private Map<String, SystemDeployment> systemDeployments;
    private MisUseFilter misUseFilter;

    private RequestDirector(File file, String string, Map<String, SystemDeployment> map) {
        this.systemsContainerRoot = file;
        this.defaultSystemIdentifier = string;
        this.systemDeployments = map;
        this.misUseFilter = new MisUseFilter();
    }

    static synchronized void createInstance() {
        SystemsContainerDeployment systemsContainerDeployment = null;
        File file = null;
        File file2 = null;
        HashMap<String, SystemDeployment> hashMap = null;
        SystemDeployment systemDeployment = null;
        String string = null;
        if (instance == null) {
            systemsContainerDeployment = SystemsContainerDeployment.getInstance();
            file = systemsContainerDeployment.getRootDirectory();
            file2 = new File(file, "systems");
            hashMap = new HashMap<String, SystemDeployment>(systemsContainerDeployment.getSystems().size());
            for (SystemsContainerDeployment.System system : systemsContainerDeployment.getSystems()) {
                try {
                    systemDeployment = SystemDeployment.createInstance(new File(new File(file2, system.getIdentifier()), "SystemDeployment.xml"));
                    hashMap.put(systemDeployment.getSystemIdentifier(), systemDeployment);
                }
                catch (Exception exception) {
                    logger.error(exception);
                    logger.error(ResourceText.getText((Object)ResourceTextIdentifiers.PROBLEM_LOADING_SYSTEMS_CONTAINER_SYSTEM));
                }
            }
            if (systemsContainerDeployment.getDefaultSystem() != null) {
                string = systemsContainerDeployment.getDefaultSystem().getIdentifier();
            }
            instance = new RequestDirector(file, string, hashMap);
        }
    }

    public static RequestDirector getInstance() {
        return instance;
    }

    String getDefaultSystemIdentifier() {
        return this.defaultSystemIdentifier;
    }

    public XmlElement processRequest(ErrorRequest errorRequest) {
        XmlElement xmlElement = null;
        try {
            xmlElement = XmlElementFactory.create("response");
            this.misUseFilter.vetRequest(errorRequest);
        }
        catch (Exception exception) {
            xmlElement.addElement(this.handleException(exception, errorRequest));
        }
        return xmlElement;
    }

    XmlElement processRequest(DataServiceRequest dataServiceRequest) {
        XmlElement xmlElement = null;
        SessionManager.NewSessionReturnStruct newSessionReturnStruct = null;
        XmlElement xmlElement2 = null;
        SystemDeployment systemDeployment = null;
        Session session = null;
        try {
            xmlElement = XmlElementFactory.create("response");
            this.misUseFilter.vetRequest(dataServiceRequest);
            systemDeployment = this.systemDeployments.get(dataServiceRequest.getSystemIdentifier());
            if (systemDeployment == null) {
                throw new UnrecognizedSystemException(dataServiceRequest.getSystemIdentifier());
            }
            if (dataServiceRequest.isNewSessionRequest()) {
                newSessionReturnStruct = systemDeployment.getSessionManager().createSession(dataServiceRequest);
                session = newSessionReturnStruct.session;
                xmlElement2 = newSessionReturnStruct.element;
            } else if (dataServiceRequest.isEndSessionRequest()) {
                session = systemDeployment.getSessionManager().vetRequest(dataServiceRequest);
                systemDeployment.getSessionManager().destroySession(session);
                xmlElement2 = XmlElementFactory.create("end-session").setBoolean(true);
            } else {
                session = systemDeployment.getSessionManager().vetRequest(dataServiceRequest);
                if (dataServiceRequest.isDataServiceRequest()) {
                    xmlElement2 = systemDeployment.processDataServiceRequest(session, dataServiceRequest);
                }
            }
            xmlElement.addElement(xmlElement2);
            xmlElement2 = Methods.getTicketsXml(session);
            if (xmlElement2 != null) {
                xmlElement.addElement(xmlElement2);
            }
        }
        catch (Exception exception) {
            xmlElement.addElement(this.handleException(exception, dataServiceRequest));
        }
        return xmlElement;
    }

    Object processRequest(FileServiceRequest fileServiceRequest) {
        Object object = null;
        SystemDeployment systemDeployment = null;
        try {
            this.misUseFilter.vetRequest(fileServiceRequest);
            systemDeployment = this.systemDeployments.get(fileServiceRequest.getSystemIdentifier());
            if (systemDeployment == null) {
                throw new UnrecognizedSystemException(fileServiceRequest.getSystemIdentifier());
            }
            object = systemDeployment.processFileServiceRequest(fileServiceRequest);
        }
        catch (Exception exception) {
            object = XmlElementFactory.create("response").addElement(this.handleException(exception, fileServiceRequest));
        }
        return object;
    }

    private XmlElement handleException(Exception exception, Object object) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        String string = null;
        String string2 = null;
        try {
            xmlElement = XmlElementFactory.create("error");
            xmlElement2 = xmlElement.addElement("exception");
            if (exception != null) {
                if (exception instanceof SecurityFilterException) {
                    this.misUseFilter.advisement((SecurityFilterException)exception, object);
                } else if (exception instanceof IllegalRequestFormatException) {
                    this.misUseFilter.advisement((IllegalRequestFormatException)exception, object);
                } else if (exception instanceof UnrecognizedRequestTypeException) {
                    this.misUseFilter.advisement((UnrecognizedRequestTypeException)exception, object);
                } else if (exception instanceof UnrecognizedSystemException) {
                    this.misUseFilter.advisement((UnrecognizedSystemException)exception, object);
                }
                if (exception instanceof ClientInteractionException) {
                    string = exception.getClass().getSimpleName();
                    string2 = exception.getMessage();
                    xmlElement2.addElement("type").setText(string == null ? "" : string);
                    xmlElement2.addElement("message").setText(string2 == null ? "" : string2);
                    logger.error(exception, false);
                } else {
                    string = exception.getClass().getSimpleName();
                    string2 = exception.getMessage();
                    xmlElement2.addElement("type").setText("com.jronimo.core.exceptions.UnexpectedServerErrorException");
                    xmlElement2.addElement("message").setText(new ResourceTextPointer((Object)ResourceTextIdentifiers.UNEXPECTED_SERVER_ERROR).getText());
                    logger.error(exception);
                }
            }
        }
        catch (Exception exception2) {
            logger.error(exception2);
        }
        return xmlElement;
    }

    void destroy() {
    }
}

