/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.util.DateUtils;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.Session;
import com.jronimo.webappengines.core.SessionManager;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Methods
extends com.jronimo.webappengines.Methods {
    private static final Logger logger = Logger.getLogger(Methods.class);

    protected Methods() {
    }

    public static String getNewSessionId() {
        String string = null;
        String string2 = null;
        string2 = String.valueOf(DateUtils.getUniqueTimestamp(true));
        string = Methods.getRandomString(string2.length());
        string = Methods.zipper(string, string2);
        return string;
    }

    public static Set<String> getInteractionTickets(int n) {
        HashSet<String> hashSet = null;
        hashSet = new HashSet<String>(n);
        for (int i = 1; i <= n; ++i) {
            hashSet.add(Methods.getRandomString(5));
        }
        return hashSet;
    }

    static XmlElement prepareNewSessionXml(Session session, SessionManager.NewSessionStruct newSessionStruct, int n) {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.create("new-session");
        xmlElement.addElement("session-id").setText(session.getSessionId());
        if (n > 0) {
            xmlElement.addElement("number-of-tickets").setInteger(n);
        }
        xmlElement.addElement("session-key").setText(Methods.getRandomString(64));
        if (newSessionStruct.returnSecurityContext) {
            xmlElement.addElement(session.getUserSecurityContext().getXml());
        }
        if (newSessionStruct.permissionIds != null) {
            // empty if block
        }
        return xmlElement;
    }

    static XmlElement getTicketsXml(Session session) {
        XmlElement xmlElement = null;
        Set<String> set = null;
        StringBuilder stringBuilder = null;
        set = session.getNewTickets();
        if (set != null) {
            stringBuilder = new StringBuilder(set.size() * 6);
            for (String string : set) {
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            xmlElement = XmlElementFactory.create("tickets");
            xmlElement.setText(stringBuilder.toString());
        }
        return xmlElement;
    }
}

