/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.util.Logger;
import com.jronimo.webappengines.Constants;
import com.jronimo.webappengines.RequestPathPortions;
import com.jronimo.webappengines.core.Constants;
import javax.servlet.http.HttpServletRequest;

public final class FileServiceRequest {
    private static final Logger logger = Logger.getLogger(FileServiceRequest.class);
    private String ip;
    private Constants.FileServiceRequestType requestType;
    private String systemIdentifier;
    private String version;
    private String rendition;
    private String wbwContext;
    private String file;
    private Exception exception;

    private FileServiceRequest(String string, Constants.FileServiceRequestType fileServiceRequestType, String string2, String string3, String string4, String string5) {
        this.ip = string;
        this.requestType = fileServiceRequestType;
        this.systemIdentifier = string2;
        this.version = string3;
        this.rendition = string4;
        this.wbwContext = string5;
    }

    private FileServiceRequest(String string, Constants.FileServiceRequestType fileServiceRequestType, String string2, String string3) {
        this.ip = string;
        this.requestType = fileServiceRequestType;
        this.systemIdentifier = string2;
        this.file = string3;
    }

    private FileServiceRequest(String string, Exception exception) {
        this.ip = string;
        this.exception = exception;
    }

    static FileServiceRequest createInstance(HttpServletRequest httpServletRequest) {
        FileServiceRequest fileServiceRequest = null;
        RequestPathPortions requestPathPortions = null;
        Constants.FileServiceRequestType fileServiceRequestType = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Exception exception = null;
        try {
            requestPathPortions = (RequestPathPortions)httpServletRequest.getAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString());
            switch (requestPathPortions.getResourcePathConstant()) {
                case FILE_SERVICE_VERSION_CHECK: {
                    fileServiceRequestType = Constants.FileServiceRequestType.VERSION_CHECK;
                    fileServiceRequest = new FileServiceRequest(httpServletRequest.getRemoteHost(), fileServiceRequestType, requestPathPortions.getSystemIdentifier(), requestPathPortions.getVersion(), requestPathPortions.getRendition(), requestPathPortions.getWbwContext());
                    break;
                }
                case FILE_SERVICE_FILE_REQUEST: {
                    fileServiceRequestType = Constants.FileServiceRequestType.FILE_REQUEST;
                    fileServiceRequest = new FileServiceRequest(httpServletRequest.getRemoteHost(), fileServiceRequestType, requestPathPortions.getSystemIdentifier(), requestPathPortions.getFile());
                }
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (fileServiceRequest == null) {
            fileServiceRequest = new FileServiceRequest(httpServletRequest.getRemoteHost(), exception);
        }
        return fileServiceRequest;
    }

    public boolean isVersionCheck() {
        return this.requestType == Constants.FileServiceRequestType.VERSION_CHECK;
    }

    public boolean isFileRequest() {
        return this.requestType == Constants.FileServiceRequestType.FILE_REQUEST;
    }

    String getIp() {
        return this.ip;
    }

    String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRendition() {
        return this.rendition;
    }

    public String getWbwContext() {
        return this.wbwContext;
    }

    public String getFile() {
        return this.file;
    }

    boolean hasException() {
        return this.exception != null;
    }

    Exception getException() {
        return this.exception;
    }
}

