/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.http.HttpRequestBodyReader;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.Constants;
import com.jronimo.webappengines.core.RequestDirector;
import com.jronimo.webappengines.core.exceptions.IllegalRequestFormatException;
import com.jronimo.webappengines.core.exceptions.UnrecognizedRequestTypeException;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataServiceRequest {
    private static final Logger logger = Logger.getLogger(DataServiceRequest.class);
    private static final HttpRequestBodyReader.ConfigStruct readerConfig = new HttpRequestBodyReader.ConfigStruct();
    private XmlElement element;
    private Constants.DataServiceRequestType requestType;
    private String systemIdentifier;
    private String sessionId;
    private Set<String> tickets = new HashSet<String>(2);
    private String ip;
    private Exception exception;

    private DataServiceRequest(Exception exception, String string) {
        this.exception = exception;
        this.ip = string;
    }

    private DataServiceRequest(XmlElement xmlElement, String string) {
        this.ip = string;
        try {
            this.element = xmlElement;
            this.requestType = Constants.DataServiceRequestType.valueOf(new SimpleNameFormat(xmlElement.getText("request-type")).getUpperCase());
            if (this.requestType == null) {
                throw new UnrecognizedRequestTypeException(xmlElement.getText("request-type"));
            }
            this.systemIdentifier = xmlElement.getOptionalText("system", RequestDirector.getInstance().getDefaultSystemIdentifier());
            this.sessionId = xmlElement.getOptionalText("session-id", null);
            if (xmlElement.hasElement("tickets")) {
                for (String string2 : xmlElement.getText("tickets").split(",")) {
                    this.tickets.add(string2);
                }
            }
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    static DataServiceRequest createInstance(HttpServletRequest httpServletRequest) {
        DataServiceRequest dataServiceRequest = null;
        HttpRequestBodyReader.Results results = null;
        Exception exception = null;
        try {
            results = new HttpRequestBodyReader(httpServletRequest, readerConfig).execute();
            if (results.hasException()) {
                exception = results.getException();
            } else {
                dataServiceRequest = new DataServiceRequest(XmlElementFactory.load(results.getBytes(), IllegalRequestFormatException.class), httpServletRequest.getRemoteHost());
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (dataServiceRequest == null) {
            dataServiceRequest = new DataServiceRequest(exception, httpServletRequest.getRemoteHost());
        }
        return dataServiceRequest;
    }

    static DataServiceRequest createInstance(HttpServletRequest httpServletRequest, Exception exception) {
        DataServiceRequest dataServiceRequest = null;
        dataServiceRequest = new DataServiceRequest(exception, httpServletRequest.getRemoteHost());
        return dataServiceRequest;
    }

    static DataServiceRequest createInstance(XmlElement xmlElement) {
        DataServiceRequest dataServiceRequest = null;
        dataServiceRequest = new DataServiceRequest(xmlElement, null);
        dataServiceRequest.ip = "000.000.000.000";
        return dataServiceRequest;
    }

    XmlElement getElement() {
        return this.element;
    }

    boolean isNewSessionRequest() {
        return this.requestType == Constants.DataServiceRequestType.NEW_SESSION;
    }

    boolean isEndSessionRequest() {
        return this.requestType == Constants.DataServiceRequestType.END_SESSION;
    }

    boolean isDataServiceRequest() {
        return this.requestType == Constants.DataServiceRequestType.DATA_SERVICE;
    }

    String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    String getIp() {
        return this.ip;
    }

    String getSessionId() {
        return this.sessionId;
    }

    Set<String> getInteractionTickets() {
        return this.tickets;
    }

    boolean hasException() {
        return this.exception != null;
    }

    Exception getException() {
        return this.exception;
    }

    static {
        DataServiceRequest.readerConfig.maxHttpRequestLength = 2048000;
        DataServiceRequest.readerConfig.bytesPerSecond = 3400;
        DataServiceRequest.readerConfig.maxHttpRequestLength = 18000;
    }
}

