/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines;

import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.webappengines.exceptions.UnrecognizedRequestPathException;

public class Constants
extends com.jronimo.util.Constants {
    public static final String WEB_APP_ROOT_NOT_FOUND_ERROR_MESSAGE = "FATAL ERROR: The web application's external root directory was not found. This indicates that the directory that should have been placed on this web application's classpath was not placed on the classpath. This web application relies on this directory being on the classpath. This is a FATAL error.";

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CookieKeys {
        SYSTEM_URL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeKeys {
        REQUEST_PATH_PORTIONS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        HTML("html", "text/html;charset=UTF-8"),
        CSS("css", "text/css;charset=UTF-8"),
        JS("js", "text/txt;charset=UTF-8"),
        TEXT("txt", "text/txt;charset=UTF-8"),
        XML("xml", "text/xml;charset=UTF-8");

        private String extension;
        private String contentType;

        private ContentType(String string2, String string3) {
            this.extension = string2;
            this.contentType = string3;
        }

        public static ContentType get(String string) {
            ContentType contentType = null;
            for (ContentType contentType2 : ContentType.values()) {
                if (!contentType2.extension.equals(string)) continue;
                contentType = contentType2;
                break;
            }
            return contentType;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourcePath {
        INDEX("/index.html", new HttpMethod[]{HttpMethod.GET}),
        SYSTEM_CORE_URL("/systemCoreUrl", new HttpMethod[]{HttpMethod.GET}),
        APPLET("/applet.html", new HttpMethod[]{HttpMethod.GET}),
        STATE("/state", new HttpMethod[]{HttpMethod.GET}),
        FILE_SERVICE_VERSION_CHECK("/fileservice-versioncheck", new HttpMethod[]{HttpMethod.GET}),
        FILE_SERVICE_FILE_REQUEST("/fileservice-file", new HttpMethod[]{HttpMethod.GET}),
        DATA_SERVICE_GET("/dataservice-get", new HttpMethod[]{HttpMethod.GET}),
        DATA_SERVICE_POST("/dataservice-post", new HttpMethod[]{HttpMethod.POST}),
        DATA_SERVICE_WS("/dataservice-ws", new HttpMethod[]{HttpMethod.POST});

        private String identifier;
        private HttpMethod[] supportedMethods;

        private ResourcePath(String string2, HttpMethod[] httpMethodArray) {
            this.identifier = string2;
            this.supportedMethods = httpMethodArray;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isSupportedMethod(String string) {
            boolean bl = false;
            HttpMethod httpMethod = null;
            httpMethod = HttpMethod.valueOf(new SimpleNameFormat(string).getUpperCase());
            if (httpMethod != null) {
                for (HttpMethod httpMethod2 : this.supportedMethods) {
                    if (httpMethod != httpMethod2) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public static ResourcePath get(String string) {
            ResourcePath resourcePath = null;
            for (ResourcePath resourcePath2 : ResourcePath.values()) {
                if (!resourcePath2.identifier.equals(string)) continue;
                resourcePath = resourcePath2;
                break;
            }
            if (resourcePath == null) {
                throw new UnrecognizedRequestPathException(string);
            }
            return resourcePath;
        }

        public String toString() {
            return this.identifier;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethod {
        GET,
        POST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SystemEnvironment {
        DEVELOPMENT,
        BUILD,
        SYSTEM_TEST,
        UAT,
        STAGING,
        PRODUCTION;

    }
}

