/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webapp;

import com.jronimo.webapp.RequestHandler;
import com.jronimo.webapp.exceptions.RequestHandlerInvocationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RequestHandlerInvoker {
    private static Map<String, Constructor> constructors = new HashMap<String, Constructor>();

    protected RequestHandlerInvoker() {
    }

    public static void invoke(String string, ServletContext servletContext, HttpServlet httpServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Constructor constructor = null;
        RequestHandler requestHandler = null;
        try {
            constructor = constructors.get(string);
            if (constructor == null) {
                constructor = RequestHandlerInvoker.getConstructor(string);
            }
            requestHandler = (RequestHandler)constructor.newInstance(servletContext, httpServlet, httpServletRequest, httpServletResponse);
            requestHandler.execute();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RequestHandlerInvocationException(invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RequestHandlerInvocationException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RequestHandlerInvocationException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RequestHandlerInvocationException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RequestHandlerInvocationException(instantiationException);
        }
    }

    private static final synchronized Constructor getConstructor(String string) throws ClassNotFoundException, NoSuchMethodException {
        Constructor<?> constructor = null;
        Class<?> clazz = null;
        constructor = constructors.get(string);
        if (constructor == null) {
            clazz = Class.forName(string);
            constructor = clazz.getConstructor(ServletContext.class, HttpServlet.class, HttpServletRequest.class, HttpServletResponse.class);
            constructors.put(string, constructor);
        }
        return constructor;
    }
}

