/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util.ranges;

import com.jronimo.util.StringWrapper;
import com.jronimo.util.ranges.Range;
import com.jronimo.util.ranges.RangeConfig;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ranges {
    private RangeConfig rangeConfig;
    private Collection<Range> ranges = new ArrayList<Range>();
    private String startString = null;
    private String endString = null;
    private Integer nextIndex = 0;

    public Ranges(RangeConfig rangeConfig, String string) {
        this.rangeConfig = rangeConfig;
        this.startString = this.rangeConfig.getStartsWith();
        this.endString = this.rangeConfig.getEndsWith();
        this.init(new StringWrapper(string));
    }

    private void init(StringWrapper stringWrapper) {
        Range range = null;
        do {
            if ((range = this.findRange(stringWrapper)) == null) continue;
            this.ranges.add(range);
        } while (range != null && this.nextIndex != null);
    }

    private Range findRange(StringWrapper stringWrapper) {
        Range range = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        n = this.findIndex(stringWrapper, this.startString, this.nextIndex);
        if (n != null) {
            n2 = this.findIndex(stringWrapper, this.endString, n + this.startString.length());
            n3 = n2 == null ? null : Integer.valueOf(n2 + this.endString.length());
            range = new Range(n, n3);
            this.nextIndex = n2 == null ? null : n3;
        }
        return range;
    }

    private Integer findIndex(StringWrapper stringWrapper, String string, int n) {
        Integer n2 = null;
        n2 = this.rangeConfig.getEscapes() ? Integer.valueOf(stringWrapper.indexOfNotEscaped(string, n)) : Integer.valueOf(stringWrapper.indexOf(string, n));
        if (n2 < 0) {
            n2 = null;
        }
        return n2;
    }

    public RangeConfig getRangeConfig() {
        return this.rangeConfig;
    }

    public Collection<Range> getRanges() {
        return this.ranges;
    }

    public boolean contains(int n) {
        boolean bl = false;
        for (Range range : this.ranges) {
            if (!range.hasStartIndex() || n < range.getStartIndex()) continue;
            if (range.hasEndIndex()) {
                bl = n < range.getEndIndex();
                continue;
            }
            bl = true;
        }
        return bl;
    }
}

