/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util.permutate;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Groups {
    private static final Logger logger = Logger.getLogger(Groups.class);
    private List<Column> columns;
    private Set<Group> groups;

    public Groups() {
        this.columns = new ArrayList<Column>(1);
        this.groups = CollectionUtils.getOrderedSet(new HashSet(this.getMaxReturnSize()));
    }

    public Groups(Column ... columnArray) {
        Assert.errorParam(columnArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "columns"));
        this.columns = new ArrayList<Column>(columnArray.length);
        for (Column column : columnArray) {
            this.columns.add(column);
        }
        this.groups = CollectionUtils.getOrderedSet(new HashSet(this.getMaxReturnSize()));
        if (!this.columns.isEmpty()) {
            this.load(0, new Group());
        }
    }

    private void load(int n, Group group) {
        boolean bl = false;
        Column column = null;
        if (n == this.columns.size() - 1) {
            bl = true;
        }
        if ((column = this.columns.get(n)).isOptional()) {
            if (bl) {
                this.groups.add(group.spawn());
            } else {
                this.load(n + 1, group.spawn());
            }
        }
        for (Object e : column.getElements()) {
            if (bl) {
                this.groups.add(group.spawn(e));
                continue;
            }
            this.load(n + 1, group.spawn(e));
        }
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public int size() {
        return this.groups.size();
    }

    public void append(Groups groups) {
        this.groups.addAll(groups.getGroups());
    }

    public String toString() {
        StringBuilder stringBuilder = null;
        stringBuilder = new StringBuilder();
        for (Group group : this.groups) {
            stringBuilder.append("\n");
            stringBuilder.append(group);
        }
        return stringBuilder.toString();
    }

    private int getMaxReturnSize() {
        int n = 1;
        for (Column column : this.columns) {
            n *= column.getElements().size() + 1;
        }
        return n;
    }

    public class Group {
        private List elements;

        Group() {
            this.elements = new ArrayList(1);
        }

        Group(Object object) {
            this.elements = new ArrayList(1);
            this.elements.add(object);
        }

        private Group(Group group) {
            this.elements = new ArrayList(group.getElements());
        }

        private Group(Group group, Object object) {
            this.elements = new ArrayList(group.getElements());
            this.elements.add(object);
        }

        public List getElements() {
            return this.elements;
        }

        public Object get(int n) {
            return this.elements.get(n);
        }

        public Object getFromLast(int n) {
            return this.elements.get(this.size() - (n + 1));
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        public int size() {
            return this.elements.size();
        }

        Group spawn() {
            return new Group(this);
        }

        Group spawn(Object object) {
            return new Group(this, object);
        }

        public int hashCode() {
            return ((Object)this.elements).hashCode();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            Group group = null;
            int n = -1;
            Object var5_5 = null;
            boolean bl2 = false;
            if (object instanceof Group) {
                group = (Group)object;
                if (this.elements.size() == group.elements.size()) {
                    bl = true;
                    for (Object e : group.elements) {
                        bl2 = false;
                        var5_5 = this.elements.get(++n);
                        if (e == null && var5_5 == null) {
                            bl2 = true;
                        } else if (e != null && e.equals(var5_5)) {
                            bl2 = true;
                        }
                        if (bl2) continue;
                        bl = false;
                        break;
                    }
                }
            }
            return bl;
        }

        public String toString(String string, Method method) {
            StringBuilder stringBuilder = null;
            if (string == null) {
                string = "";
            }
            stringBuilder = new StringBuilder();
            for (Object e : this.elements) {
                stringBuilder.append(this.getElementString(e, method));
                stringBuilder.append(string);
            }
            if (stringBuilder.length() >= string.length()) {
                stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
            }
            return stringBuilder.toString();
        }

        public String toString(String string) {
            return this.toString(string, null);
        }

        public String toString() {
            return this.toString(", ");
        }

        private String getElementString(Object object, Method method) {
            String string = null;
            if (method == null) {
                string = object.toString();
            } else {
                try {
                    string = Methods.executeViaReflection(method, object, false, new Object[0]).toString();
                }
                catch (Exception exception) {
                    logger.warning(exception);
                    string = object.toString();
                }
            }
            return string;
        }
    }

    public static class Column {
        private boolean optional;
        private List elements;

        public Column(boolean bl, Object ... objectArray) {
            Assert.errorParam(objectArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "elements"));
            Assert.errorParam(!bl && objectArray.length == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "elements"));
            this.optional = bl;
            this.elements = new ArrayList(objectArray.length);
            for (Object object : objectArray) {
                this.elements.add(object);
            }
        }

        public boolean isOptional() {
            return this.optional;
        }

        public List getElements() {
            return this.elements;
        }
    }
}

