/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.hidden.impl.ListIterator;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringIteratorWithVoidRegions;
import java.awt.Point;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringWrapperWithVoidRegions
implements Comparable<Object>,
Iterable<String> {
    private static final Logger logger = Logger.getLogger(StringWrapperWithVoidRegions.class);
    private boolean canHaveVoidRegions;
    private StringWrapperWithVoidRegions voidCharacters;
    private String voidSubString;
    private Point voidRange;
    protected StringBuilder string;
    protected OperationResult operationResult;

    public StringWrapperWithVoidRegions() {
        this.string = new StringBuilder();
    }

    public StringWrapperWithVoidRegions(Object object) {
        Assert.errorParamMustNotBeNull("object", object);
        this.string = new StringBuilder(object.toString());
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    private OperationResult clearOperationResult() {
        this.operationResult = new OperationResult();
        return this.operationResult;
    }

    public int capacity() {
        return this.string.capacity();
    }

    public void ensureCapacity(int n) {
        this.string.ensureCapacity(n);
    }

    public void trimToSize() {
        this.string.trimToSize();
    }

    public int length() {
        return this.string.length();
    }

    public int indexOf(String string) {
        Assert.errorParamMustNotBeNull("string", string);
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2;
        block2: {
            n2 = -1;
            int n3 = 0;
            Assert.errorParamMustNotBeNull("substring", string);
            n3 = n - 1;
            block0: while (true) {
                ++n3;
                if ((n3 = this.string.indexOf(string, n3)) < 0) break block2;
                int n4 = n3 + string.length();
                for (int i = n3; i < n4; ++i) {
                    if (!this.isAccessibleIndex(i)) continue block0;
                }
                break;
            }
            n2 = n3;
        }
        return n2;
    }

    public int lastIndexOf(String string) {
        Assert.errorParamMustNotBeNull("string", string);
        return this.lastIndexOf(string, this.length());
    }

    public int lastIndexOf(String string, int n) {
        int n2;
        block2: {
            n2 = -1;
            int n3 = 0;
            Assert.errorParamMustNotBeNull("substring", string);
            n3 = n + 1;
            block0: while (true) {
                --n3;
                if ((n3 = this.string.lastIndexOf(string, n3)) < 0) break block2;
                int n4 = n3 + string.length();
                for (int i = n3; i < n4; ++i) {
                    if (!this.isAccessibleIndex(i)) continue block0;
                }
                break;
            }
            n2 = n3;
        }
        return n2;
    }

    public String substring(int n) {
        return this.substring(n, this.length());
    }

    public String substring(int n, int n2) {
        return this.substring(n, n2, false);
    }

    public String substring(int n, boolean bl) {
        return this.substring(n, this.length(), bl);
    }

    public String substring(int n, int n2, boolean bl) {
        String string = null;
        Assert.errorState(!this.isAccessibleIndex(n) && !this.isFirstCharacterOfVoidRegion(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        Assert.errorState(!this.isAccessibleIndex(n2) && !this.isFirstCharacterOfVoidRegion(n2), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n2));
        string = this.string.substring(n, n2);
        if (bl) {
            this.delete(n, n2);
        }
        return string;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean startsWith(String string, int n) {
        Assert.errorParamMustNotBeNull("substring", string);
        return this.indexOf(string, n) == n;
    }

    public boolean endsWith(String string) {
        boolean bl = false;
        int n = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        bl = string.length() == 0 ? true : (n = this.lastIndexOf(string)) >= 0 && n == this.length() - string.length();
        return bl;
    }

    public StringWrapperWithVoidRegions append(Object object) {
        String string = null;
        string = String.valueOf(object);
        if (string.length() > 0) {
            this.string.append(string);
            this.updated();
        }
        return this;
    }

    public StringWrapperWithVoidRegions insert(int n, Object object) {
        String string = null;
        Assert.errorState(!this.isAccessibleIndex(n) && !this.isFirstCharacterOfVoidRegion(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        string = String.valueOf(object);
        if (string.length() > 0) {
            this.string.insert(n, object);
            this.updated();
        }
        return this;
    }

    public StringWrapperWithVoidRegions delete(int n) {
        this.delete(n, this.length());
        return this;
    }

    public StringWrapperWithVoidRegions delete(int n, int n2) {
        Assert.errorState(!this.isAccessibleIndex(n) && !this.isFirstCharacterOfVoidRegion(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        Assert.errorState(!this.isAccessibleIndex(n2) && !this.isFirstCharacterOfVoidRegion(n2), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n2));
        this.string.delete(n, n2);
        this.updated();
        return this;
    }

    public StringWrapperWithVoidRegions deleteCharAt(int n) {
        Assert.errorState(!this.isAccessibleIndex(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        this.string.deleteCharAt(n);
        this.updated();
        return this;
    }

    public StringWrapperWithVoidRegions replace(int n, int n2, String string) {
        Assert.errorParamMustNotBeNull("string", string);
        Assert.errorState(!this.isAccessibleIndex(n) && !this.isFirstCharacterOfVoidRegion(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        Assert.errorState(!this.isAccessibleIndex(n2) && !this.isFirstCharacterOfVoidRegion(n2), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n2));
        this.string.replace(n, n2, string);
        this.updated();
        return this;
    }

    public StringWrapperWithVoidRegions reverse() {
        this.string.reverse();
        this.updated();
        return this;
    }

    public StringWrapperWithVoidRegions toLowerCase() {
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        String string = null;
        stringIteratorWithVoidRegions = this.iterator();
        while (stringIteratorWithVoidRegions.hasNext()) {
            string = stringIteratorWithVoidRegions.next();
            stringIteratorWithVoidRegions.replace(string.toLowerCase());
        }
        return this;
    }

    public StringWrapperWithVoidRegions toUpperCase() {
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        String string = null;
        stringIteratorWithVoidRegions = this.iterator();
        while (stringIteratorWithVoidRegions.hasNext()) {
            string = stringIteratorWithVoidRegions.next();
            stringIteratorWithVoidRegions.replace(string.toUpperCase());
        }
        return this;
    }

    @Override
    public int compareTo(Object object) {
        int n = 0;
        int n2 = n = object == null ? 1 : this.toString().compareTo(object.toString());
        n = n < 0 ? -1 : (n > 0 ? 1 : n);
        return n;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equalsIgnoreCase(Object object) {
        return this.toString().equalsIgnoreCase(String.valueOf(object));
    }

    public boolean equals(Object object) {
        return object == null ? false : this.toString().equals(object.toString());
    }

    public String toString() {
        return this.string.toString();
    }

    public boolean isWhiteSpace() {
        return this.hasVoidRegion() ? false : (this.length() == 0 ? false : this.toString().trim().length() == 0);
    }

    public int indexOfWhiteSpace() {
        return this.indexOfWhiteSpace(0);
    }

    public int indexOfWhiteSpace(int n) {
        int n2 = -1;
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        stringIteratorWithVoidRegions = this.iterator(this.getNextAccessibleIndex(n, false, false));
        while (stringIteratorWithVoidRegions.hasNext()) {
            if (stringIteratorWithVoidRegions.next().trim().length() != 0) continue;
            n2 = stringIteratorWithVoidRegions.indexOfLastReturned();
            break;
        }
        return n2;
    }

    public int indexOfNonWhiteSpace() {
        return this.indexOfNonWhiteSpace(0);
    }

    public int indexOfNonWhiteSpace(int n) {
        int n2 = -1;
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        int n3 = -1;
        String string = null;
        this.assertInBounds(n, true);
        Assert.errorState(!this.isAccessibleIndex(n) && !this.isFirstCharacterOfVoidRegion(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        if (!this.isEmpty() && this.inBounds(n, false)) {
            if (this.isFirstCharacterOfVoidRegion(n)) {
                n2 = n;
            } else {
                stringIteratorWithVoidRegions = this.iterator(n);
                n3 = n - 1;
                while (stringIteratorWithVoidRegions.hasNext()) {
                    string = stringIteratorWithVoidRegions.next();
                    if (++n3 != stringIteratorWithVoidRegions.indexOfLastReturned()) {
                        n2 = n3;
                        break;
                    }
                    if (string.trim().length() != 1) continue;
                    n2 = stringIteratorWithVoidRegions.indexOfLastReturned();
                    break;
                }
                if (n2 == -1 && this.isFirstCharacterOfVoidRegion(++n3)) {
                    n2 = n3;
                }
            }
        }
        return n2;
    }

    public int lastIndexOfNonWhiteSpace() {
        return this.lastIndexOfNonWhiteSpace(this.length() == 0 ? 0 : this.length() - 1);
    }

    public int lastIndexOfNonWhiteSpace(int n) {
        int n2 = -1;
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        int n3 = -1;
        String string = null;
        this.assertInBounds(n, true);
        Assert.errorState(!this.isAccessibleIndex(n) && !this.isLastCharacterOfVoidRegion(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        if (!this.isEmpty() && this.inBounds(n, false)) {
            if (this.isLastCharacterOfVoidRegion(n)) {
                n2 = n;
            } else {
                stringIteratorWithVoidRegions = this.iterator(0, n + 1);
                n3 = n + 1;
                while (stringIteratorWithVoidRegions.hasPrevious()) {
                    string = stringIteratorWithVoidRegions.previous();
                    if (--n3 != stringIteratorWithVoidRegions.indexOfLastReturned()) {
                        n2 = n3;
                        break;
                    }
                    if (string.trim().length() != 1) continue;
                    n2 = stringIteratorWithVoidRegions.indexOfLastReturned();
                    break;
                }
            }
        }
        return n2;
    }

    public boolean containsWhiteSpace() {
        return this.indexOfWhiteSpace() >= 0;
    }

    public String getLeadingWhiteSpace() {
        String string = null;
        int n = 0;
        n = this.indexOfNonWhiteSpace();
        if (n < 0) {
            n = this.length();
        }
        string = this.getFirst(n);
        return string;
    }

    public String getTrailingWhiteSpace() {
        String string = null;
        int n = 0;
        n = this.lastIndexOfNonWhiteSpace();
        n = n >= 0 ? n + 1 : this.length();
        string = this.substring(n);
        return string;
    }

    public boolean hasLeadingWhiteSpace() {
        boolean bl = false;
        bl = this.getLeadingWhiteSpace().length() > 0;
        return bl;
    }

    public boolean hasTrailingWhiteSpace() {
        boolean bl = false;
        bl = this.getTrailingWhiteSpace().length() > 0;
        return bl;
    }

    public StringWrapperWithVoidRegions trim() {
        if (this.length() > 0) {
            this.leftTrim();
            this.rightTrim();
        }
        return this;
    }

    public StringWrapperWithVoidRegions leftTrim() {
        this.deleteFirst(this.getLeadingWhiteSpace().length());
        return this;
    }

    public StringWrapperWithVoidRegions rightTrim() {
        this.deleteLast(this.getTrailingWhiteSpace().length());
        return this;
    }

    public StringWrapperWithVoidRegions removeWhiteSpace() {
        return this.removeWhiteSpace("");
    }

    public StringWrapperWithVoidRegions removeWhiteSpace(String string) {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        String string2 = null;
        boolean bl = false;
        Assert.errorParamMustNotBeNull("exceptions", string);
        if (this.length() > 0) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            stringIteratorWithVoidRegions = this.iterator();
            while (stringIteratorWithVoidRegions.hasNext()) {
                string2 = stringIteratorWithVoidRegions.next();
                if (string2.trim().length() != 0 || stringWrapperWithVoidRegions.contains(string2)) continue;
                stringIteratorWithVoidRegions.remove();
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions reduceConsecutiveSpaces() {
        return this.reduceConsecutiveSubstrings(" ");
    }

    public StringWrapperWithVoidRegions replaceWhiteSpaceCharacters(String string) {
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        String string2 = null;
        Assert.errorParamMustNotBeNull("substring", string);
        stringIteratorWithVoidRegions = this.iterator();
        while (stringIteratorWithVoidRegions.hasNext()) {
            string2 = stringIteratorWithVoidRegions.next();
            if (string2.trim().length() != 0) continue;
            stringIteratorWithVoidRegions.replace(string);
        }
        return this;
    }

    public StringWrapperWithVoidRegions replaceWhiteSpace(String string) {
        int n = 0;
        String string2 = null;
        Integer n2 = null;
        Integer n3 = null;
        while (n < this.length()) {
            if (this.isAccessibleIndex(n)) {
                string2 = this.substring(n, n + 1);
            }
            if (!this.isAccessibleIndex(n) || string2.trim().length() == 1) {
                if (n2 == null) {
                    ++n;
                } else {
                    n3 = n;
                    this.replace(n2, n3, string);
                    n += string.length() - (n3 - n2) + 1;
                    n2 = null;
                    n3 = null;
                }
            } else {
                if (n2 == null) {
                    n2 = n;
                } else {
                    n3 = n;
                }
                ++n;
            }
            if (n != this.length() || n2 == null) continue;
            this.replace(n2, this.length(), string);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public NullFreeMutableSet<Integer> allIndexesOf(String string) {
        return this.allIndexesOf(string, 0);
    }

    public NullFreeMutableSet<Integer> allIndexesOf(String string, int n) {
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        nullFreeMutableSet = new NullFreeMutableSet<Integer>();
        if (this.length() > 0 && string.length() > 0 && n >= 0 && n < this.length()) {
            n2 = n;
            while ((n2 = this.indexOf(string, n2)) >= 0) {
                nullFreeMutableSet.add(n2);
                n2 += string.length();
            }
        }
        return nullFreeMutableSet;
    }

    public NullFreeMutableSet<Integer> allIndexesOfNumbers() {
        return this.allIndexesOfNumbers(ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS), 0);
    }

    public NullFreeMutableSet<Integer> allIndexesOfNumbers(int n) {
        return this.allIndexesOfNumbers(ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS), n);
    }

    public NullFreeMutableSet<Integer> allIndexesOfNumbers(String string, int n) {
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        String string2 = null;
        boolean bl = false;
        Assert.errorParamMustNotBeNull("digits", string);
        nullFreeMutableSet = new NullFreeMutableSet<Integer>();
        if (this.length() > 0 && string.length() > 0 && this.inBounds(n, false)) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            stringIteratorWithVoidRegions = this.iterator(n);
            while (stringIteratorWithVoidRegions.hasNext()) {
                string2 = stringIteratorWithVoidRegions.next();
                if (stringWrapperWithVoidRegions.contains(string2)) {
                    if (bl) continue;
                    bl = true;
                    nullFreeMutableSet.add(stringIteratorWithVoidRegions.indexOfLastReturned());
                    continue;
                }
                bl = false;
            }
        }
        return nullFreeMutableSet;
    }

    public NullFreeMutableSet<Integer> allIndexesOfUpperCase() {
        return this.allIndexesOfUpperCase(0);
    }

    public NullFreeMutableSet<Integer> allIndexesOfUpperCase(int n) {
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
        String string = null;
        nullFreeMutableSet = new NullFreeMutableSet<Integer>();
        if (this.length() > 0 && this.inBounds(n, false)) {
            stringIteratorWithVoidRegions = this.iterator(n);
            while (stringIteratorWithVoidRegions.hasNext()) {
                string = stringIteratorWithVoidRegions.next();
                if (string.equals(string.toLowerCase())) continue;
                nullFreeMutableSet.add(stringIteratorWithVoidRegions.indexOfLastReturned());
            }
        }
        return nullFreeMutableSet;
    }

    public int substringCount(String string) {
        return this.substringCount(string, 0);
    }

    public int substringCount(String string, int n) {
        return this.allIndexesOf(string, n).size();
    }

    public boolean contains(String string) {
        Assert.errorParamMustNotBeNull("substring", string);
        return this.indexOf(string) >= 0;
    }

    public boolean containsAll(String ... stringArray) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("substrings", stringArray);
        if (stringArray.length > 0) {
            bl = true;
            for (String string : stringArray) {
                if (this.contains(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean containsAny(String ... stringArray) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("substrings", stringArray);
        for (String string : stringArray) {
            if (!this.contains(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean containsOnlyLetters() {
        return this.containsOnlyCharacters(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean containsOnlyLetters(String string) {
        return this.containsOnlyCharacters(string);
    }

    public boolean containsOnlyUpperCaseLetters() {
        return this.containsOnlyCharacters(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean containsOnlyUpperCaseLetters(String string) {
        return this.containsOnlyCharacters(string);
    }

    public boolean containsOnlyLowerCaseLetters() {
        return this.containsOnlyCharacters(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE));
    }

    public boolean containsOnlyLowerCaseLetters(String string) {
        return this.containsOnlyCharacters(string);
    }

    public boolean containsOnlyDigits() {
        return this.containsOnlyCharacters(ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS));
    }

    public boolean containsOnlyDigits(String string) {
        return this.containsOnlyCharacters(string);
    }

    public boolean containsOnlyCharacters(String string) {
        boolean bl = false;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        Assert.errorParamMustNotBeEmpty("characters", string);
        if (this.length() > 0) {
            bl = true;
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            for (String string2 : this) {
                if (stringWrapperWithVoidRegions.contains(string2)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean containsAnyCharacters(String string) {
        boolean bl = false;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0 && string.length() > 0) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            for (String string2 : this) {
                if (!stringWrapperWithVoidRegions.contains(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean containsAllCharacters(String string) {
        boolean bl = true;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        Assert.errorParamMustNotBeEmpty("characters", string);
        if (this.length() > 0 && string.length() > 0) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            for (String string2 : this) {
                stringWrapperWithVoidRegions.remove(string2);
                if (!stringWrapperWithVoidRegions.isEmpty()) continue;
                break;
            }
            bl = stringWrapperWithVoidRegions.isEmpty();
        }
        return bl;
    }

    public boolean startsWithLetter() {
        return this.startsWithLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean startsWithLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.startsWithCharacter(string);
    }

    public boolean startsWithUpperCaseLetter() {
        return this.startsWithUpperCaseLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean startsWithUpperCaseLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.startsWithCharacter(string);
    }

    public boolean startsWithLowerCaseLetter() {
        return this.startsWithLowerCaseLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE));
    }

    public boolean startsWithLowerCaseLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.startsWithCharacter(string);
    }

    public boolean startsWithCharacter(String string) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0 && string.length() > 0 && this.isAccessibleIndex(0)) {
            bl = new StringWrapperWithVoidRegions(string).contains(this.getFirst());
        }
        return bl;
    }

    public boolean endsWithCharacter(String string) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0 && string.length() > 0 && this.isAccessibleIndex(this.length() - 1)) {
            bl = new StringWrapperWithVoidRegions(string).contains(this.getLast());
        }
        return bl;
    }

    public boolean isAllUpperCase() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.length() > 0) {
            bl = true;
            for (String string : this) {
                bl2 = true;
                if (string.equals(string.toUpperCase())) continue;
                bl = false;
                break;
            }
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    public boolean isAllLowerCase() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.length() > 0) {
            bl = true;
            for (String string : this) {
                bl2 = true;
                if (string.equals(string.toLowerCase())) continue;
                bl = false;
                break;
            }
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    public boolean isFirstCharacterUpperCase() {
        boolean bl = false;
        String string = null;
        if (this.length() > 0 && this.isAccessibleIndex(0)) {
            string = this.substring(0, 1);
            bl = string.equals(string.toUpperCase());
        }
        return bl;
    }

    public boolean isFirstCharacterLowerCase() {
        boolean bl = false;
        String string = null;
        if (this.length() > 0 && this.isAccessibleIndex(0)) {
            string = this.substring(0, 1);
            bl = string.equals(string.toLowerCase());
        }
        return bl;
    }

    public String getFirst() {
        return this.getFirst(1);
    }

    public String getFirst(int n) {
        String string = null;
        if (this.length() > 0 && n > 0) {
            n = (n = this.getPreviousAccessibleIndex(n, true, false)) < 0 ? 0 : (n > this.length() ? this.length() : n);
            string = this.substring(0, n);
        } else {
            string = "";
        }
        return string;
    }

    public String getLast() {
        return this.getLast(1);
    }

    public String getLast(int n) {
        String string = null;
        if (this.length() > 0 && n > 0) {
            n = this.length() - this.getNextAccessibleIndex(this.length() - n, true, false);
            n = n < 0 ? 0 : (n > this.length() ? this.length() : n);
            string = this.substring(this.length() - n);
        } else {
            string = "";
        }
        return string;
    }

    public String from(String string, boolean bl, boolean bl2) {
        return this.from(string, 0, bl, bl2);
    }

    public String from(String string, int n, boolean bl, boolean bl2) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            if (bl && n2 > 0) {
                n2 = this.lastIndexOfNonWhiteSpace(n2 - 1) + 1;
            }
            string2 = this.substring(n2);
            if (bl2) {
                this.delete(n2);
            }
        }
        return string2;
    }

    public String after(String string, boolean bl) {
        return this.after(string, 0, bl);
    }

    public String after(String string, int n, boolean bl) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            string2 = this.substring(n2 += string.length());
            if (bl) {
                this.delete(n2);
            }
        }
        return string2;
    }

    public String to(String string, boolean bl) {
        return this.to(string, 0, bl);
    }

    public String to(String string, int n, boolean bl) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            string2 = this.getFirst(n2 += string.length());
            if (bl) {
                this.deleteFirst(n2);
            }
        }
        return string2;
    }

    public String before(String string, boolean bl, boolean bl2) {
        return this.before(string, 0, bl, bl2);
    }

    public String before(String string, int n, boolean bl, boolean bl2) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            if (bl && n2 > 0) {
                n2 = this.lastIndexOfNonWhiteSpace(n2 - 1) + 1;
            }
            string2 = this.getFirst(n2);
            if (bl2) {
                this.deleteFirst(n2);
            }
        }
        return string2;
    }

    public String between(String string, String string2) {
        return this.between(string, string2, 0);
    }

    public String between(String string, String string2, int n) {
        return this.between(string, string2, n, false);
    }

    public String between(String string, String string2, boolean bl) {
        return this.between(string, string2, 0, bl);
    }

    public String between(String string, String string2, int n, boolean bl) {
        String string3 = null;
        int n2 = -1;
        int n3 = -1;
        Assert.errorParamMustNotBeEmpty("startString", string);
        Assert.errorParamMustNotBeEmpty("endString", string2);
        if (this.inBounds(n, false)) {
            n2 = this.indexOf(string, n);
            if (n2 >= 0) {
                n3 = this.indexOf(string2, n2 += string.length());
            }
            if (n3 >= 0) {
                string3 = this.substring(n2, n3);
                if (bl) {
                    this.delete(n2, n3);
                }
            }
        }
        return string3;
    }

    public String between(String string, int n) {
        return this.between(string, n, 0);
    }

    public String between(String string, int n, int n2) {
        return this.between(string, n, n2, false);
    }

    public String between(String string, int n, boolean bl) {
        return this.between(string, n, 0, bl);
    }

    public String between(String string, int n, int n2, boolean bl) {
        String string2 = null;
        int n3 = -1;
        Assert.errorParamMustNotBeEmpty("startString", string);
        this.assertInBounds(n, true);
        this.assertInBounds(n2, true);
        if (this.length() >= string.length()) {
            n = this.getPreviousAccessibleIndex(n, true, false);
            if ((n2 = this.getNextAccessibleIndex(n2, false, false)) >= 0 && n2 <= n - string.length() && (n3 = this.indexOf(string, n2)) >= 0 && (n3 += string.length()) <= n) {
                string2 = this.substring(n3, n);
                if (bl) {
                    this.delete(n3, n);
                }
            }
        }
        return string2;
    }

    public String substring(int n, String string) {
        return this.substring(n, string, n + 1, false);
    }

    public String substring(int n, String string, int n2) {
        return this.substring(n, string, n2, false);
    }

    public String substring(int n, String string, boolean bl) {
        return this.substring(n, string, n + 1, bl);
    }

    public String substring(int n, String string, int n2, boolean bl) {
        String string2 = null;
        int n3 = -1;
        this.assertInBounds(n, true);
        Assert.errorParamMustNotBeEmpty("endString", string);
        Assert.errorState(!this.isAccessibleIndex(n) && !this.isFirstCharacterOfVoidRegion(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.STRING_WRAPPER_NOT_ACCESSIBLE_INDEX, n));
        if (this.inBounds(n2, false) && (n3 = this.indexOf(string, n2)) >= 0 && n <= n3) {
            string2 = this.substring(n, n3);
            if (bl) {
                this.delete(n, n3);
            }
        }
        return string2;
    }

    public boolean surrounded(String string) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("substring", string);
        if (string.length() > 0 && this.length() >= string.length() * 2 && !this.equals(string)) {
            bl = this.startsWith(string) && this.endsWith(string);
        }
        return bl;
    }

    public NullFreeMutableList<String> split(String string) {
        return this.split(string, false, false, false);
    }

    public NullFreeMutableList<String> split(String string, boolean bl, boolean bl2, boolean bl3) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        int n = -1;
        int n2 = 0;
        boolean bl4 = false;
        Assert.errorParamMustNotBeEmpty("delimiter", string);
        nullFreeMutableList = new NullFreeMutableList<String>();
        nullFreeMutableSet = this.allIndexesOf(string);
        if (nullFreeMutableSet.isEmpty()) {
            nullFreeMutableList.add(this.toString());
        } else {
            if ((Integer)nullFreeMutableSet.getFirst() == 0) {
                if (bl2) {
                    nullFreeMutableList.add("");
                }
            } else {
                nullFreeMutableList.add(this.substring(0, (Integer)nullFreeMutableSet.getFirst()));
            }
            for (Integer n3 : nullFreeMutableSet) {
                n3 = n3 + string.length();
                if (nullFreeMutableSet.isLastIndex(++n)) {
                    if (n3.intValue() == this.length()) {
                        if (!bl3) continue;
                        nullFreeMutableList.add("");
                        continue;
                    }
                    nullFreeMutableList.add(this.substring(n3));
                    continue;
                }
                n2 = (Integer)nullFreeMutableSet.get(n + 1);
                if (n3 == n2) {
                    if (!bl) continue;
                    nullFreeMutableList.add("");
                    continue;
                }
                nullFreeMutableList.add(this.substring((int)n3, n2));
            }
        }
        return nullFreeMutableList;
    }

    public NullFreeMutableList<String> getLines(boolean bl, boolean bl2, boolean bl3) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        java.util.ListIterator listIterator = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        if (this.isEmpty()) {
            nullFreeMutableList = new NullFreeMutableList<String>("");
        } else {
            nullFreeMutableList = new NullFreeMutableList<String>((Collection<String>)this.split("\n", true, true, true));
            listIterator = nullFreeMutableList.listIterator();
            while (((ListIterator)listIterator).hasNext()) {
                stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(((ListIterator)listIterator).next());
                if (bl2 && bl3) {
                    stringWrapperWithVoidRegions.trim();
                } else if (bl2) {
                    stringWrapperWithVoidRegions.leftTrim();
                } else if (bl3) {
                    stringWrapperWithVoidRegions.rightTrim();
                }
                if (bl || !stringWrapperWithVoidRegions.isEmpty()) {
                    ((ListIterator)listIterator).set(stringWrapperWithVoidRegions.toString());
                    continue;
                }
                ((ListIterator)listIterator).remove();
            }
        }
        return nullFreeMutableList;
    }

    public int getConsecutiveCountBefore(int n, String string) {
        int n2;
        block7: {
            n2 = 0;
            StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
            int n3 = 0;
            String string2 = null;
            StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
            if (this.inBounds(n, true) && this.isAccessibleIndex(n)) {
                if (!this.isEmpty() && string.length() > 0 && n > 0) {
                    stringIteratorWithVoidRegions = this.iterator(0, n);
                    n3 = n;
                    stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions();
                    while (stringIteratorWithVoidRegions.hasPrevious()) {
                        stringWrapperWithVoidRegions.clear();
                        while (stringIteratorWithVoidRegions.hasPrevious()) {
                            string2 = stringIteratorWithVoidRegions.previous();
                            if (--n3 == stringIteratorWithVoidRegions.indexOfLastReturned()) {
                                stringWrapperWithVoidRegions.insert(0, string2);
                                if (stringWrapperWithVoidRegions.length() != string.length()) continue;
                            }
                            break block7;
                        }
                        if (stringWrapperWithVoidRegions.equals(string)) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                n2 = -1;
            }
        }
        return n2;
    }

    public int getConsecutiveCountFrom(int n, String string) {
        int n2;
        block7: {
            n2 = 0;
            StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
            int n3 = 0;
            String string2 = null;
            StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
            if (this.inBounds(n, true) && this.isAccessibleIndex(n)) {
                if (!this.isEmpty() && string.length() > 0 && n < this.length()) {
                    stringIteratorWithVoidRegions = this.iterator(n);
                    n3 = n - 1;
                    stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions();
                    while (stringIteratorWithVoidRegions.hasNext()) {
                        stringWrapperWithVoidRegions.clear();
                        while (stringIteratorWithVoidRegions.hasNext()) {
                            string2 = stringIteratorWithVoidRegions.next();
                            if (++n3 == stringIteratorWithVoidRegions.indexOfLastReturned()) {
                                stringWrapperWithVoidRegions.append(string2);
                                if (stringWrapperWithVoidRegions.length() != string.length()) continue;
                            }
                            break block7;
                        }
                        if (stringWrapperWithVoidRegions.equals(string)) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                n2 = -1;
            }
        }
        return n2;
    }

    public boolean isEscaped(int n) {
        boolean bl = false;
        this.assertInBounds(n, false);
        bl = this.getConsecutiveCountBefore(n, "\\") % 2 == 1;
        return bl;
    }

    public int indexOfNotEscaped(String string, int n) {
        int n2 = -1;
        int n3 = 0;
        while ((n3 = this.indexOf(string, n)) >= 0) {
            if (this.isEscaped(n3)) {
                ++n;
                continue;
            }
            n2 = n3;
            break;
        }
        return n2;
    }

    public boolean inBounds(int n, boolean bl) {
        return n >= 0 && n <= (bl ? this.length() : this.length() - 1);
    }

    public StringWrapperWithVoidRegions clear() {
        this.string.delete(0, this.string.length());
        this.updated();
        return this;
    }

    public StringWrapperWithVoidRegions replaceContent(Object object) {
        this.string.delete(0, this.string.length());
        this.string.append(object);
        this.updated();
        return this;
    }

    public StringWrapperWithVoidRegions replace(String string, String string2) {
        int n = 0;
        Assert.errorParamMustNotBeNull("key", string);
        Assert.errorParamMustNotBeNull("value", string2);
        if (!this.isEmpty() && string.length() > 0) {
            n = this.indexOf(string);
            int n2 = string.length();
            for (int i = 1; i < n2; ++i) {
                if (this.isAccessibleIndex(n + i)) continue;
                n = -1;
                break;
            }
            if (n >= 0) {
                this.string.replace(n, n + string.length(), string2);
                this.updated();
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions replaceAll(String string, String string2) {
        int n = 0;
        Assert.errorParamMustNotBeNull("key", string);
        Assert.errorParamMustNotBeNull("value", string2);
        if (!this.isEmpty() && string.length() > 0) {
            while ((n = this.indexOf(string, n)) >= 0) {
                this.replace(n, n + string.length(), string2);
                n += string2.length();
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions replaceAll(Map<String, String> map) {
        Assert.errorParamMustNotBeNull("replacementMap", map);
        for (String string : map.keySet()) {
            this.replaceAll(string, map.get(string));
        }
        return this;
    }

    public StringWrapperWithVoidRegions remove(String string) {
        this.replace(string, "");
        return this;
    }

    public StringWrapperWithVoidRegions removeAll(String string) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (!this.isEmpty() && string.length() > 0) {
            this.replaceAll(string, "");
        }
        return this;
    }

    public StringWrapperWithVoidRegions reduceConsecutiveSubstrings(String string) {
        String string2 = null;
        Assert.errorParamMustNotBeEmpty("substring", string);
        if (this.length() >= string.length() * 2) {
            string2 = string + string;
            int n = this.indexOf(string2);
            while (this.indexOf(string2) >= 0) {
                this.replaceAll(string2, string);
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions retainAllCharacters(String string) {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        int n = 0;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            while (n < this.length()) {
                if (!this.isAccessibleIndex(n)) {
                    ++n;
                    continue;
                }
                if (stringWrapperWithVoidRegions.contains(this.substring(n, n + 1))) {
                    ++n;
                    continue;
                }
                this.string.deleteCharAt(n);
                this.updated();
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions removeAllCharacters(String string) {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        int n = 0;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0 && string.length() > 0) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            while (n < this.length()) {
                if (!this.isAccessibleIndex(n)) {
                    ++n;
                    continue;
                }
                if (stringWrapperWithVoidRegions.contains(this.substring(n, n + 1))) {
                    this.string.deleteCharAt(n);
                    this.updated();
                    continue;
                }
                ++n;
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions removeLeadingNonLetters() {
        while (this.length() > 0 && this.isAccessibleIndex(0) && !this.startsWithLetter()) {
            this.string.deleteCharAt(0);
            this.updated();
        }
        return this;
    }

    public StringWrapperWithVoidRegions removeLeadingNonLetters(String string) {
        Assert.errorParamMustNotBeNull("letters", string);
        if (string.length() > 0) {
            while (this.length() > 0 && !this.startsWithLetter(string) && this.isAccessibleIndex(0)) {
                this.string.deleteCharAt(0);
                this.updated();
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions removeTrailingCharacters(String string) {
        Assert.errorParamMustNotBeNull("characters", string);
        if (string.length() > 0) {
            while (this.length() > 0 && this.endsWithCharacter(string) && this.isAccessibleIndex(this.length() - 1)) {
                this.string.deleteCharAt(this.length() - 1);
                this.updated();
            }
        }
        return this;
    }

    public StringWrapperWithVoidRegions replaceFirst(String string) {
        return this.replaceFirst(1, string);
    }

    public StringWrapperWithVoidRegions replaceFirst(int n, String string) {
        Assert.errorParamMustBeGreaterThanOrEqualTo("quantity", n, 0L);
        Assert.errorParamMustNotBeNull("string", string);
        n = this.getPreviousAccessibleIndex(n, true, false);
        n = n < 0 ? 0 : (n > this.length() ? this.length() : n);
        this.replace(0, n, string);
        return this;
    }

    public StringWrapperWithVoidRegions replaceLast(String string) {
        return this.replaceLast(1, string);
    }

    public StringWrapperWithVoidRegions replaceLast(int n, String string) {
        Assert.errorParamMustNotBeNull("string", string);
        n = this.length() - this.getNextAccessibleIndex(this.length() - n, true, false);
        n = n < 0 ? 0 : (n > this.length() ? this.length() : n);
        this.replace(this.length() - n, this.length(), string);
        return this;
    }

    public StringWrapperWithVoidRegions deleteFirst() {
        this.deleteFirst(1);
        return this;
    }

    public StringWrapperWithVoidRegions deleteFirst(int n) {
        Assert.errorParamMustBeGreaterThanOrEqualTo("quantity", n, 0L);
        this.replaceFirst(n, "");
        return this;
    }

    public StringWrapperWithVoidRegions deleteFirst(String string) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (string.length() > 0 && this.startsWith(string)) {
            this.deleteFirst(string.length());
        }
        return this;
    }

    public StringWrapperWithVoidRegions deleteLast() {
        this.deleteLast(1);
        return this;
    }

    public StringWrapperWithVoidRegions deleteLast(int n) {
        Assert.errorParamMustBeGreaterThanOrEqualTo("quantity", n, 0L);
        this.replaceLast(n, "");
        return this;
    }

    public StringWrapperWithVoidRegions deleteLast(String string) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (string.length() > 0 && this.endsWith(string)) {
            this.deleteLast(string.length());
        }
        return this;
    }

    public StringWrapperWithVoidRegions deleteBefore(String string, boolean bl) {
        this.deleteBefore(string, 0, bl);
        return this;
    }

    public StringWrapperWithVoidRegions deleteBefore(String string, int n, boolean bl) {
        this.before(string, n, bl, true);
        return this;
    }

    public StringWrapperWithVoidRegions deleteTo(String string) {
        this.deleteTo(string, 0);
        return this;
    }

    public StringWrapperWithVoidRegions deleteTo(String string, int n) {
        this.to(string, n, true);
        return this;
    }

    public StringWrapperWithVoidRegions deleteFrom(String string, boolean bl) {
        this.deleteFrom(string, 0, bl);
        return this;
    }

    public StringWrapperWithVoidRegions deleteFrom(String string, int n, boolean bl) {
        this.from(string, n, bl, true);
        return this;
    }

    public StringWrapperWithVoidRegions deleteAfter(String string) {
        this.deleteAfter(string, 0);
        return this;
    }

    public StringWrapperWithVoidRegions deleteAfter(String string, int n) {
        this.after(string, n, true);
        return this;
    }

    public StringWrapperWithVoidRegions truncateRight(int n) {
        if (n >= 0 && n < this.length()) {
            this.deleteLast(this.length() - n);
        }
        return this;
    }

    public StringWrapperWithVoidRegions truncateLeft(int n) {
        if (n >= 0 && n < this.length()) {
            this.deleteFirst(this.length() - n);
        }
        return this;
    }

    public StringWrapperWithVoidRegions reverseByDelimiter(String string) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        StringBuilder stringBuilder = null;
        Assert.errorParamMustNotBeEmpty("delimiter", string);
        if (this.length() > string.length() && this.contains(string)) {
            nullFreeMutableList = this.split(string, true, true, true);
            nullFreeMutableList.reverse();
            stringBuilder = new StringBuilder();
            for (String string2 : nullFreeMutableList) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
            }
            this.string = stringBuilder;
            this.updated();
        }
        return this;
    }

    public StringWrapperWithVoidRegions pad(int n, String string, boolean bl) {
        Assert.errorParamMustNotBeEmpty("paddingChar", string);
        while (this.length() < n) {
            if (bl) {
                this.string.append(string);
            } else {
                this.string.insert(0, string);
            }
            this.updated();
        }
        return this;
    }

    public StringWrapperWithVoidRegions firstCharacterToLowerCase() {
        this.replace(0, 1, this.substring(0, 1).toLowerCase());
        return this;
    }

    public StringWrapperWithVoidRegions firstCharacterToUpperCase() {
        this.replace(0, 1, this.substring(0, 1).toUpperCase());
        return this;
    }

    public StringWrapperWithVoidRegions sqlEscape() {
        this.replaceAll("'", "''");
        return this;
    }

    public StringWrapperWithVoidRegions jsEscape() {
        this.replaceAll("'", "\\'");
        return this;
    }

    public StringWrapperWithVoidRegions unescapeHtml() {
        NullFreeMutableSet<VoidRegion> nullFreeMutableSet = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        int n = 0;
        VoidRegion voidRegion = null;
        int n2 = 0;
        nullFreeMutableSet = this.getVoidRegions();
        if (nullFreeMutableSet.isEmpty()) {
            this.string = new StringBuilder(StringEscapeUtils.unescapeHtml((String)this.toString()));
        } else {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions();
            for (VoidRegion voidRegion2 : nullFreeMutableSet) {
                ++n;
                n2 = voidRegion == null ? 0 : voidRegion.getStartIndex() + voidRegion.getLength();
                stringWrapperWithVoidRegions.append(StringEscapeUtils.unescapeHtml((String)this.string.substring(n2, voidRegion2.getStartIndex())));
                stringWrapperWithVoidRegions.append(voidRegion2.getText());
                if (n == nullFreeMutableSet.size()) {
                    stringWrapperWithVoidRegions.append(StringEscapeUtils.unescapeHtml((String)this.string.substring(voidRegion2.getStartIndex() + voidRegion2.getLength())));
                }
                voidRegion = voidRegion2;
            }
            this.string = new StringBuilder(stringWrapperWithVoidRegions.toString());
        }
        this.updated();
        return this;
    }

    public StringWrapperWithVoidRegions surround(String string) {
        return this.surround(string, false);
    }

    public StringWrapperWithVoidRegions surround(String string, boolean bl) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (!(string.length() <= 0 || bl && this.surrounded(string))) {
            this.string.insert(0, string).append(string);
            this.updated();
        }
        return this;
    }

    public StringWrapperWithVoidRegions repeat(int n) {
        return this.repeat(n, "");
    }

    public StringWrapperWithVoidRegions repeat(int n, String string) {
        String string2 = null;
        Assert.errorParamMustNotBeNull("delimiter", string);
        if (n > 0) {
            for (int i = 1; i <= n; ++i) {
                string2 = this.toString();
                this.string.append(string);
                this.string.append(string2);
            }
            this.updated();
        }
        return this;
    }

    public StringWrapperWithVoidRegions repeatOriginal(int n) {
        return this.repeatOriginal(n, "");
    }

    public StringWrapperWithVoidRegions repeatOriginal(int n, String string) {
        String string2 = null;
        Assert.errorParamMustNotBeNull("delimiter", string);
        if (n > 0) {
            string2 = this.toString();
            for (int i = 1; i <= n; ++i) {
                this.string.append(string);
                this.string.append(string2);
            }
            this.updated();
        }
        return this;
    }

    public StringIteratorWithVoidRegions iterator() {
        return this.iterator(0, this.length());
    }

    public StringIteratorWithVoidRegions iterator(int n) {
        return this.iterator(n, this.length());
    }

    public StringIteratorWithVoidRegions iterator(int n, int n2) {
        return new StringIteratorWithVoidRegions(this, n, n2);
    }

    public NullFreeMutableList<String> getPlainWords() {
        NullFreeMutableList<String> nullFreeMutableList = null;
        Words words = null;
        words = this.getWords();
        nullFreeMutableList = new NullFreeMutableList<String>(words.getCollection().size());
        for (Word word : words) {
            nullFreeMutableList.add(word.toString());
        }
        return nullFreeMutableList;
    }

    public Words getWords() {
        Words words = null;
        words = new Words(this);
        return words;
    }

    public StringWrapperWithVoidRegions deleteWord(String string, boolean bl, boolean bl2) {
        Word word = null;
        word = this.getWords().getWord(string);
        if (word != null) {
            this.delete(word.getStartIndex(bl), word.getEndIndex(bl2));
        }
        return this;
    }

    public StringWrapperWithVoidRegions spawn() {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(this);
        stringWrapperWithVoidRegions.voidCharacters = this.voidCharacters;
        stringWrapperWithVoidRegions.voidSubString = this.voidSubString;
        stringWrapperWithVoidRegions.voidRange = this.voidRange;
        stringWrapperWithVoidRegions.canHaveVoidRegions = this.canHaveVoidRegions;
        return stringWrapperWithVoidRegions;
    }

    public NullFreeMutableSet<VoidRegion> getVoidRegions() {
        NullFreeMutableSet<VoidRegion> nullFreeMutableSet = null;
        Integer n = null;
        nullFreeMutableSet = new NullFreeMutableSet<VoidRegion>();
        int n2 = this.string.length();
        for (int i = 0; i < n2; ++i) {
            if (this.isAccessibleIndex(i)) {
                if (n != null) {
                    nullFreeMutableSet.add(new VoidRegion(n, i - n, this.string.substring(n, i)));
                    n = null;
                }
            } else if (n == null) {
                n = i;
            }
            if (i != this.string.length() - 1 || n == null) continue;
            nullFreeMutableSet.add(new VoidRegion(n, this.string.length() - n, this.string.substring(n)));
        }
        return nullFreeMutableSet;
    }

    public StringWrapperWithVoidRegions deleteVoidRegions() {
        NullFreeMutableSet<VoidRegion> nullFreeMutableSet = null;
        ListIterator listIterator = null;
        boolean bl = false;
        VoidRegion voidRegion = null;
        nullFreeMutableSet = this.getVoidRegions();
        listIterator = nullFreeMutableSet.listIterator();
        bl = listIterator.hasPrevious();
        while (listIterator.hasPrevious()) {
            voidRegion = (VoidRegion)listIterator.previous();
            this.delete(voidRegion.getStartIndex(), voidRegion.getStartIndex() + voidRegion.getLength());
        }
        if (bl) {
            this.updated();
        }
        return this;
    }

    public boolean isAccessibleIndex(int n) {
        boolean bl = true;
        if (this.canHaveVoidRegions) {
            if (this.voidCharacters != null && this.inBounds(n, false)) {
                bl = !this.voidCharacters.contains(this.string.substring(n, n + 1));
            } else if (this.voidSubString != null && this.inBounds(n, false)) {
                int n2 = 0;
                n2 = this.string.indexOf(this.voidSubString);
                if (n2 >= 0) {
                    bl = n < n2 || n >= n2 + this.voidSubString.length();
                }
            } else if (this.voidRange != null && this.inBounds(n, false)) {
                bl = n < this.voidRange.x || n > this.voidRange.y;
            }
        }
        return bl;
    }

    protected void updated() {
    }

    StringWrapperWithVoidRegions setVoidCharacters(String string) {
        this.voidSubString = null;
        this.voidRange = null;
        this.voidCharacters = string == null ? null : new StringWrapperWithVoidRegions(string);
        this.canHaveVoidRegions = this.voidCharacters != null;
        return this;
    }

    StringWrapperWithVoidRegions setVoidSubString(String string) {
        this.voidCharacters = null;
        this.voidRange = null;
        this.voidSubString = string;
        this.canHaveVoidRegions = this.voidSubString != null;
        return this;
    }

    StringWrapperWithVoidRegions setVoidRange(Point point) {
        this.voidCharacters = null;
        this.voidSubString = null;
        this.voidRange = point;
        this.canHaveVoidRegions = this.voidRange != null;
        return this;
    }

    public boolean hasVoidRegion() {
        boolean bl = false;
        int n = this.string.length();
        for (int i = 0; i < n; ++i) {
            if (this.isAccessibleIndex(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isFirstCharacterOfVoidRegion(int n) {
        return !this.isAccessibleIndex(n) && this.isAccessibleIndex(n - 1);
    }

    public boolean isLastCharacterOfVoidRegion(int n) {
        return !this.isAccessibleIndex(n) && this.isAccessibleIndex(n + 1);
    }

    private int getPreviousAccessibleIndex(int n, boolean bl, boolean bl2) {
        int n2 = 0;
        n2 = n;
        while (!(this.isAccessibleIndex(n2) || bl && this.isFirstCharacterOfVoidRegion(n2) || bl2 && this.isLastCharacterOfVoidRegion(n2))) {
            --n2;
        }
        return n2;
    }

    private int getNextAccessibleIndex(int n, boolean bl, boolean bl2) {
        int n2 = 0;
        n2 = n;
        while (!(this.isAccessibleIndex(n2) || bl && this.isFirstCharacterOfVoidRegion(n2) || bl2 && this.isLastCharacterOfVoidRegion(n2))) {
            ++n2;
        }
        return n2;
    }

    private void assertInBounds(int n, boolean bl) {
        if (!this.inBounds(n, bl)) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static class Word {
        private String word;
        private int index;
        private String leadingWhiteSpace;
        private String trailingWhiteSpace;

        private Word(String string, int n, String string2, String string3) {
            this.word = string;
            this.index = n;
            this.leadingWhiteSpace = string2;
            this.trailingWhiteSpace = string3;
        }

        public String getText(boolean bl, boolean bl2) {
            return (bl ? this.leadingWhiteSpace : "") + this.word + (bl2 ? this.trailingWhiteSpace : "");
        }

        public int getStartIndex() {
            return this.getStartIndex(false);
        }

        public int getStartIndex(boolean bl) {
            return bl ? this.index - this.leadingWhiteSpace.length() : this.index;
        }

        public int getEndIndex() {
            return this.getEndIndex(false);
        }

        public int getEndIndex(boolean bl) {
            int n = 0;
            n = this.index + this.word.length();
            if (bl) {
                n += this.trailingWhiteSpace.length();
            }
            return n;
        }

        public String getLeadingWhiteSpace() {
            return this.leadingWhiteSpace;
        }

        public String getTrailingWhiteSpace() {
            return this.trailingWhiteSpace;
        }

        public boolean hasLeadingWhiteSpace() {
            return this.leadingWhiteSpace.length() > 0;
        }

        public boolean hasTrailingWhiteSpace() {
            return this.trailingWhiteSpace.length() > 0;
        }

        public boolean equals(Object object) {
            return object == null ? false : this.toString().equals(object.toString());
        }

        public String toString() {
            return this.word;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Words
    implements Iterable<Word> {
        private NullFreeMutableList<Word> words = new NullFreeMutableList();

        public Words(String string) {
            this(new StringWrapperWithVoidRegions(string));
        }

        public Words(StringWrapperWithVoidRegions stringWrapperWithVoidRegions) {
            Assert.errorParamMustNotBeNull("string", stringWrapperWithVoidRegions);
            this.load(stringWrapperWithVoidRegions.spawn());
        }

        private void load(StringWrapperWithVoidRegions stringWrapperWithVoidRegions) {
            StringWrapperWithVoidRegions stringWrapperWithVoidRegions2 = null;
            StringWrapperWithVoidRegions stringWrapperWithVoidRegions3 = null;
            StringWrapperWithVoidRegions stringWrapperWithVoidRegions4 = null;
            boolean bl = true;
            StringIteratorWithVoidRegions stringIteratorWithVoidRegions = null;
            int n = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            String string = null;
            boolean bl4 = false;
            StringContext stringContext = null;
            int n2 = 0;
            if (!stringWrapperWithVoidRegions.isEmpty() && !stringWrapperWithVoidRegions.isWhiteSpace()) {
                stringWrapperWithVoidRegions2 = new StringWrapperWithVoidRegions();
                stringWrapperWithVoidRegions3 = new StringWrapperWithVoidRegions();
                stringWrapperWithVoidRegions4 = new StringWrapperWithVoidRegions();
                stringIteratorWithVoidRegions = stringWrapperWithVoidRegions.iterator();
                while (stringIteratorWithVoidRegions.hasNext()) {
                    string = stringIteratorWithVoidRegions.next();
                    bl2 = ++n != stringIteratorWithVoidRegions.indexOfLastReturned();
                    bl3 = false;
                    boolean bl5 = bl4 = string.trim().length() == 0;
                    if (bl2) {
                        if (!stringWrapperWithVoidRegions2.isEmpty()) {
                            n2 = n - stringWrapperWithVoidRegions4.length() - stringWrapperWithVoidRegions2.length();
                            this.words.add(new Word(stringWrapperWithVoidRegions2.toString(), n2, stringWrapperWithVoidRegions3.toString(), stringWrapperWithVoidRegions4.toString()));
                            bl3 = true;
                        }
                        n = stringIteratorWithVoidRegions.indexOfLastReturned();
                        stringWrapperWithVoidRegions3.clear();
                        stringWrapperWithVoidRegions2.clear();
                        stringWrapperWithVoidRegions4.clear();
                        bl = true;
                    }
                    if (bl) {
                        if (bl4) {
                            stringContext = StringContext.LEADING_WHITE_SPACE;
                            stringWrapperWithVoidRegions3.append(string);
                        } else {
                            stringContext = StringContext.WORD;
                            stringWrapperWithVoidRegions2.append(string);
                        }
                        bl = false;
                    } else if (bl4) {
                        if (stringContext.isWord()) {
                            stringContext = StringContext.TRAILING_WHITE_SPACE;
                            stringWrapperWithVoidRegions4.append(string);
                        } else if (stringContext.isTrailingWhiteSpace()) {
                            stringWrapperWithVoidRegions4.append(string);
                        } else if (stringContext.isLeadingWhiteSpace()) {
                            stringWrapperWithVoidRegions3.append(string);
                        }
                    } else if (stringContext.isTrailingWhiteSpace()) {
                        n2 = n - stringWrapperWithVoidRegions4.length() - stringWrapperWithVoidRegions2.length();
                        this.words.add(new Word(stringWrapperWithVoidRegions2.toString(), n2, stringWrapperWithVoidRegions3.toString(), stringWrapperWithVoidRegions4.toString()));
                        bl3 = true;
                        stringWrapperWithVoidRegions3.replaceContent(stringWrapperWithVoidRegions4);
                        stringWrapperWithVoidRegions2.clear();
                        stringWrapperWithVoidRegions4.clear();
                        stringContext = StringContext.WORD;
                        stringWrapperWithVoidRegions2.append(string);
                    } else if (stringContext.isLeadingWhiteSpace()) {
                        stringContext = StringContext.WORD;
                        stringWrapperWithVoidRegions2.append(string);
                    } else if (stringContext.isWord()) {
                        stringWrapperWithVoidRegions2.append(string);
                    }
                    if (stringIteratorWithVoidRegions.hasNext() || bl3) continue;
                    n2 = n + 1 - stringWrapperWithVoidRegions4.length() - stringWrapperWithVoidRegions2.length();
                    this.words.add(new Word(stringWrapperWithVoidRegions2.toString(), n2, stringWrapperWithVoidRegions3.toString(), stringWrapperWithVoidRegions4.toString()));
                }
            }
        }

        public boolean contains(String string) {
            return this.getPlainWords().contains(string);
        }

        public Word getWord(String string) {
            return this.getWord(string, 0);
        }

        public Word getWord(String string, int n) {
            Word word = null;
            NullFreeMutableList<String> nullFreeMutableList = null;
            int n2 = 0;
            int n3 = 0;
            nullFreeMutableList = this.getPlainWords();
            while ((n2 = nullFreeMutableList.indexOf(string, n2)) >= 0) {
                if (++n3 > n) {
                    word = (Word)this.words.get(n2);
                    break;
                }
                ++n2;
            }
            return word;
        }

        public Word getWordFromLast(String string) {
            return this.getWordFromLast(string, 0);
        }

        public Word getWordFromLast(String string, int n) {
            Word word = null;
            NullFreeMutableList<String> nullFreeMutableList = null;
            int n2 = 0;
            nullFreeMutableList = this.getPlainWords();
            for (int i = 0; i < nullFreeMutableList.size(); ++i) {
                if (!((String)nullFreeMutableList.getFromLast(i)).equals(string) || ++n2 <= n) continue;
                word = (Word)this.words.getFromLast(i);
                break;
            }
            return word;
        }

        public Word getMinWord(String ... stringArray) {
            Word word = null;
            Word word2 = null;
            if (stringArray != null && stringArray.length > 0) {
                for (String string : stringArray) {
                    word2 = this.getWord(string);
                    if (word2 == null) continue;
                    if (word == null) {
                        word = word2;
                        continue;
                    }
                    if (word2.getStartIndex() >= word.getStartIndex()) continue;
                    word = word2;
                }
            }
            return word;
        }

        public Word getMaxWord(String ... stringArray) {
            Word word = null;
            Word word2 = null;
            if (stringArray != null && stringArray.length > 0) {
                for (String string : stringArray) {
                    word2 = this.getWordFromLast(string);
                    if (word2 == null) continue;
                    if (word == null) {
                        word = word2;
                        continue;
                    }
                    if (word2.getStartIndex() <= word.getStartIndex()) continue;
                    word = word2;
                }
            }
            return word;
        }

        public NullFreeMutableList<String> getPlainWords() {
            NullFreeMutableList<String> nullFreeMutableList = null;
            nullFreeMutableList = new NullFreeMutableList<String>(this.words.size());
            for (Word word : this.words) {
                nullFreeMutableList.add(word.toString());
            }
            return nullFreeMutableList;
        }

        public NullFreeMutableList<Word> getCollection() {
            return new NullFreeMutableList<Word>((Collection<Word>)this.words);
        }

        @Override
        public Iterator<Word> iterator() {
            return new NullFreeMutableList<Word>((Collection<Word>)this.words).iterator();
        }

        public int size() {
            return this.words.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum StringContext {
            WORD,
            LEADING_WHITE_SPACE,
            TRAILING_WHITE_SPACE;


            public boolean isWord() {
                return this == WORD;
            }

            public boolean isLeadingWhiteSpace() {
                return this == LEADING_WHITE_SPACE;
            }

            public boolean isTrailingWhiteSpace() {
                return this == TRAILING_WHITE_SPACE;
            }
        }
    }

    public class VoidRegion {
        private int startIndex;
        private int length;
        private String text;

        private VoidRegion(int n, int n2, String string) {
            this.startIndex = n;
            this.length = n2;
            this.text = string;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getLength() {
            return this.length;
        }

        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OperationResult {
        private boolean changed;
        private int count;
        private String removed;
        private NullFreeMutableList<String> removeds;

        private OperationResult() {
        }

        public boolean changed() {
            return this.changed;
        }

        public int getCount() {
            return this.count;
        }

        public String getRemoved() {
            return this.removed;
        }

        public NullFreeMutableList<String> getRemoveds() {
            return this.removeds;
        }
    }
}

