/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringIterator
implements Iterator<String> {
    private static final Logger logger = Logger.getLogger(StringIterator.class);
    private StringWrapper string;
    private int fromIndex;
    private int toIndex;
    private int indexOfLastReturned = -1;
    private boolean addRemoveCalledAfterNextPrevious;
    private LastCall lastCall;

    public StringIterator(String string) {
        this(new StringWrapper(string), 0, string.length());
    }

    public StringIterator(String string, int n) {
        this(new StringWrapper(string), n, string.length());
    }

    public StringIterator(String string, int n, int n2) {
        this(new StringWrapper(string), n, n2);
    }

    public StringIterator(StringWrapper stringWrapper) {
        this(stringWrapper, 0, stringWrapper.length());
    }

    public StringIterator(StringWrapper stringWrapper, int n) {
        this(stringWrapper, n, stringWrapper.length());
    }

    public StringIterator(StringWrapper stringWrapper, int n, int n2) {
        Assert.errorParamMustNotBeNull("string", stringWrapper);
        int n3 = n < 0 ? 0 : (n = n > stringWrapper.length() ? stringWrapper.length() : n);
        int n4 = n2 < 0 ? 0 : (n2 = n2 > stringWrapper.length() ? stringWrapper.length() : n2);
        if (n2 < n) {
            n2 = n;
        }
        this.string = stringWrapper;
        this.fromIndex = n;
        this.toIndex = n2;
        this.indexOfLastReturned = n - 1;
    }

    public String toString() {
        return this.string.toString();
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getToIndex() {
        return this.toIndex;
    }

    public int indexOfLastReturned() {
        return this.indexOfLastReturned;
    }

    public int previousIndex() {
        int n = 0;
        if (this.lastCall == null) {
            n = this.getPreviousAccessibleIndex(this.toIndex);
        } else if (this.lastCall == LastCall.PREVIOUS) {
            n = this.getPreviousAccessibleIndex(this.indexOfLastReturned);
        } else if (this.lastCall == LastCall.NEXT) {
            n = this.indexOfLastReturned;
        }
        return n;
    }

    public int nextIndex() {
        int n = 0;
        if (this.lastCall == null) {
            n = this.getNextAccessibleIndex(this.indexOfLastReturned);
        } else if (this.lastCall == LastCall.PREVIOUS) {
            n = this.indexOfLastReturned;
        } else if (this.lastCall == LastCall.NEXT) {
            n = this.getNextAccessibleIndex(this.indexOfLastReturned);
        }
        return n;
    }

    public boolean hasPrevious() {
        boolean bl = false;
        int n = 0;
        n = this.previousIndex();
        bl = n >= this.fromIndex && n < this.toIndex;
        return bl;
    }

    @Override
    public boolean hasNext() {
        boolean bl = false;
        int n = 0;
        n = this.nextIndex();
        bl = n >= this.fromIndex && n < this.toIndex;
        return bl;
    }

    public String previous() {
        String string = null;
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.indexOfLastReturned = this.previousIndex();
        string = this.string.substring(this.indexOfLastReturned, this.indexOfLastReturned + 1);
        this.addRemoveCalledAfterNextPrevious = false;
        this.lastCall = LastCall.PREVIOUS;
        return string;
    }

    @Override
    public String next() {
        String string = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.indexOfLastReturned = this.nextIndex();
        string = this.string.substring(this.indexOfLastReturned, this.indexOfLastReturned + 1);
        this.addRemoveCalledAfterNextPrevious = false;
        this.lastCall = LastCall.NEXT;
        return string;
    }

    public void replace(Object object) {
        String string = null;
        this.checkReplaceRemoveState();
        string = String.valueOf(object);
        if (string.length() == 0) {
            this.remove();
        } else {
            this.string.replace(this.indexOfLastReturned, this.indexOfLastReturned + 1, string);
            this.toIndex += string.length() - 1;
        }
    }

    public void add(Object object) {
        String string = null;
        int n = 0;
        string = String.valueOf(object);
        n = this.nextIndex();
        if (n < 0) {
            n = this.toIndex;
        }
        this.indexOfLastReturned = n;
        this.string.insert(n, string);
        this.toIndex += string.length();
        if (this.lastCall == LastCall.PREVIOUS) {
            this.indexOfLastReturned = this.getNextAccessibleIndex(this.indexOfLastReturned);
        }
        this.addRemoveCalledAfterNextPrevious = true;
    }

    @Override
    public void remove() {
        this.checkReplaceRemoveState();
        this.string.deleteCharAt(this.indexOfLastReturned);
        --this.toIndex;
        if (this.lastCall == LastCall.NEXT) {
            this.indexOfLastReturned = this.getPreviousAccessibleIndex(this.indexOfLastReturned);
        }
        this.addRemoveCalledAfterNextPrevious = true;
    }

    private int getPreviousAccessibleIndex(int n) {
        return n - 1;
    }

    private int getNextAccessibleIndex(int n) {
        return n + 1;
    }

    private void checkReplaceRemoveState() {
        Assert.errorState(this.lastCall == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.ITERATOR_NEXT_PREVIOUS));
        Assert.errorState(this.addRemoveCalledAfterNextPrevious, new ResourceTextPointer((Object)ResourceTextIdentifiers.ITERATOR_ADD_REMOVE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LastCall {
        NEXT,
        PREVIOUS;

    }
}

