/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public final class MultiStdOut
extends OutputStream {
    private boolean writeToStdOut = false;
    private List<Byte> bytes = null;
    private List<DestinationFile> destinationFiles = null;
    private PrintStream stdOut = System.out;

    private MultiStdOut(boolean bl) {
        this.writeToStdOut = bl;
        this.bytes = new ArrayList<Byte>();
        this.destinationFiles = new ArrayList<DestinationFile>();
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.write(byArray[i]);
        }
    }

    public synchronized void write(int n) {
        this.bytes.add(new Byte((byte)n));
    }

    public synchronized void flush() {
        int n;
        byte[] byArray = null;
        String string = null;
        DestinationFile destinationFile = null;
        byArray = new byte[this.bytes.size()];
        int n2 = this.bytes.size();
        for (n = 0; n < n2; ++n) {
            byArray[n] = this.bytes.get(n);
        }
        this.bytes.clear();
        string = new String(byArray);
        if (this.writeToStdOut) {
            this.stdOut.print(string);
        }
        n2 = this.destinationFiles.size();
        for (n = 0; n < n2; ++n) {
            destinationFile = this.destinationFiles.get(n);
            destinationFile.write(string);
        }
    }

    public synchronized void close() {
        DestinationFile destinationFile = null;
        int n = this.destinationFiles.size();
        for (int i = 0; i < n; ++i) {
            destinationFile = this.destinationFiles.get(i);
            destinationFile.close();
        }
    }

    public synchronized void addDestination(File file, boolean bl) throws IOException {
        this.destinationFiles.add(new DestinationFile(file, bl));
    }

    public static MultiStdOut setStandardOut() {
        MultiStdOut multiStdOut = null;
        PrintStream printStream = null;
        try {
            multiStdOut = new MultiStdOut(true);
            printStream = new PrintStream(multiStdOut, true);
            System.setOut(printStream);
            System.setErr(printStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return multiStdOut;
    }

    private class DestinationFile {
        private FileWriter fileWriter = null;

        DestinationFile(File file, boolean bl) throws IOException {
            if (!bl) {
                file.delete();
            }
            this.fileWriter = new FileWriter(file.getPath(), bl);
        }

        void write(String string) {
            if (this.fileWriter != null) {
                try {
                    this.fileWriter.write(string);
                    this.fileWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        void close() {
            this.write("\n\n");
            try {
                this.fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

