/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.MutableList;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.exceptions.FileSystemException;
import com.jronimo.exceptions.ReflectionException;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Methods {
    private static final Logger logger = Logger.getLogger(Methods.class);
    private static final Class<?>[] ARRAY_PRIMITIVE_TYPES = new Class[]{int[].class, float[].class, double[].class, boolean[].class, byte[].class, short[].class, long[].class, char[].class};

    protected Methods() {
    }

    public static Object[] getObjectArray(Object object) {
        Object[] objectArray = null;
        Class<?> clazz = object.getClass();
        int n = 0;
        if (object != null) {
            for (Class<?> clazz2 : ARRAY_PRIMITIVE_TYPES) {
                if (!clazz.isAssignableFrom(clazz2)) continue;
                n = Array.getLength(object);
                objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = Array.get(object, i);
                }
                break;
            }
            if (objectArray == null) {
                objectArray = (Object[])object;
            }
        }
        return objectArray;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static boolean allNull(Object ... objectArray) {
        boolean bl = true;
        Assert.errorParamMustNotBeNull("objects", objectArray);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean anyNull(Object ... objectArray) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("objects", objectArray);
        for (Object object : objectArray) {
            if (object != null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean anyEmpty(String ... stringArray) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("values", stringArray);
        for (String string : stringArray) {
            if (string != null && string.length() != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.size() == 0;
    }

    public static long getRandomNumber(long l, long l2) {
        long l3 = 0L;
        boolean bl = true;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        if (l < l2) {
            l4 = l;
            l5 = l2;
        } else if (l == l2) {
            l3 = l;
            bl = false;
        } else {
            l4 = l2;
            l5 = l;
        }
        if (bl) {
            l6 = l4 - 1L;
            l4 = 1L;
            l5 = l5 - l6 + 1L;
            while ((l3 = Math.round(Math.random() * (double)l5)) < 1L || l3 > l5 - 1L) {
            }
            l3 += l6;
        }
        return l3;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File getClassPathResourceAsFile(Class clazz, String string) {
        File file = null;
        try {
            file = new File(Methods.getClassPathResourceAsURL(clazz, string).toURI());
        }
        catch (Exception exception) {
            throw new FileSystemException(exception);
        }
        return file;
    }

    public static URL getClassPathResourceAsURL(Class clazz, String string) {
        URL uRL = null;
        Methods.getClassPathResourceAssertCommonParams(clazz, string);
        uRL = clazz.getResource(string);
        return uRL;
    }

    public static InputStream getClassPathResourceAsStream(Class clazz, String string) {
        InputStream inputStream = null;
        Methods.getClassPathResourceAssertCommonParams(clazz, string);
        inputStream = clazz.getResourceAsStream(string);
        return inputStream;
    }

    private static void getClassPathResourceAssertCommonParams(Class clazz, String string) {
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "packageElementClass"));
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "resourceName"));
        Assert.errorParam(string.length() == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "resourceName"));
    }

    public static Object instantiateViaReflection(Class clazz) {
        Object object = null;
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "clazz"));
        object = Methods.instantiateViaReflection(clazz, (Class[])null, null);
        return object;
    }

    public static Object instantiateViaReflection(Class clazz, Class clazz2, Object object) {
        Object object2 = null;
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "clazz"));
        object2 = Methods.instantiateViaReflection(clazz, new Class[]{clazz2}, new Object[]{object});
        return object2;
    }

    public static Object instantiateViaReflection(Class clazz, Class[] classArray, Object[] objectArray) {
        Object var3_3 = null;
        Constructor constructor = null;
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "clazz"));
        try {
            constructor = clazz.getConstructor(classArray);
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException(invocationTargetException);
        }
        return var3_3;
    }

    public static Object executeViaReflection(Class clazz, Object object, String string, boolean bl, Class clazz2, Object object2) {
        return Methods.executeViaReflection(Methods.getMethodViaReflection(clazz, string, bl, clazz2), object, bl, object2);
    }

    public static Object executeViaReflection(Class clazz, Object object, String string, boolean bl, Class[] classArray, Object[] objectArray) {
        return Methods.executeViaReflection(Methods.getMethodViaReflection(clazz, string, bl, classArray), object, bl, objectArray);
    }

    public static Object executeViaReflection(Method method, Object object, boolean bl, Object ... objectArray) {
        Object object2 = null;
        Assert.errorParam(method == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "method"));
        try {
            if (bl && !method.isAccessible()) {
                method.setAccessible(true);
            }
            object2 = method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException(invocationTargetException);
        }
        return object2;
    }

    public static Method getMethodViaReflection(Class clazz, String string, boolean bl, Class ... classArray) {
        Method method = null;
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "clazz"));
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "methodName"));
        Assert.errorParam(string.length() == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "methodName"));
        try {
            method = clazz.getDeclaredMethod(string, classArray);
            if (bl && !method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        return method;
    }

    public static Field getFieldViaReflection(Class clazz, String string) {
        Field field = null;
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "clazz"));
        Assert.errorParam(Methods.isEmpty(string), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "fieldName"));
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionException(noSuchFieldException);
        }
        return field;
    }

    public static Object getFieldValueViaReflection(Class clazz, Object object, String string) {
        Object object2 = null;
        try {
            object2 = Methods.getFieldViaReflection(clazz, string).get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        return object2;
    }

    public static Class getPrimitiveClass(String string) {
        Class<Comparable<Byte>> clazz = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "typeName"));
        if (string.equals("byte")) {
            clazz = Byte.TYPE;
        } else if (string.equals("short")) {
            clazz = Short.TYPE;
        } else if (string.equals("int")) {
            clazz = Integer.TYPE;
        } else if (string.equals("long")) {
            clazz = Long.TYPE;
        } else if (string.equals("float")) {
            clazz = Float.TYPE;
        } else if (string.equals("double")) {
            clazz = Double.TYPE;
        } else if (string.equals("boolean")) {
            clazz = Boolean.TYPE;
        } else if (string.equals("char")) {
            clazz = Character.TYPE;
        }
        return clazz;
    }

    public static Class getPrimitiveArrayClass(String string, int n) {
        Class clazz = null;
        clazz = Methods.getArrayClass(Methods.getPrimitiveClass(string), n);
        return clazz;
    }

    public static Class getArrayClass(Class clazz, int n) {
        Class<?> clazz2 = null;
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "clazz"));
        Assert.errorParam(n <= 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN, "depth", String.valueOf(n), new ResourceTextPointer((Object)ResourceTextIdentifiers.ZERO_ALC)));
        clazz2 = clazz;
        for (int i = 1; i <= n; ++i) {
            clazz2 = Array.newInstance(clazz2, 0).getClass();
        }
        return clazz2;
    }

    public static boolean isPrimitiveType(String string) {
        boolean bl = false;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "type"));
        if (string.equals("int") || string.equals("boolean") || string.equals("long") || string.equals("byte") || string.equals("float") || string.equals("double") || string.equals("short") || string.equals("char")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPrimitiveWrapperType(String string) {
        boolean bl = false;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "type"));
        if (string.equals("java.lang.Integer") || string.equals("java.lang.Boolean") || string.equals("java.lang.Long") || string.equals("java.lang.Byte") || string.equals("java.lang.Float") || string.equals("java.lang.Double") || string.equals("java.lang.Short") || string.equals("java.lang.Character")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStringType(String string) {
        boolean bl = false;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "type"));
        if (string.equals("java.lang.String")) {
            bl = true;
        }
        return bl;
    }

    public static String ensureNotNullAsString(Object object) {
        String string = null;
        string = object == null ? "" : object.toString();
        return string;
    }

    public static String getString(Object object) {
        return Methods.getString(object, "");
    }

    public static String getString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static Long getLong(String string, Long l) {
        Long l2 = null;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l2 == null) {
            l2 = l;
        }
        return l2;
    }

    public static boolean bothEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static String getConnectionIsolation(Connection connection) throws Exception {
        String string = null;
        switch (connection.getTransactionIsolation()) {
            case 0: {
                string = "TRANSACTION_NONE";
                break;
            }
            case 2: {
                string = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 1: {
                string = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 4: {
                string = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                string = "TRANSACTION_SERIALIZABLE";
            }
        }
        logger.debug("Connection.getTransactionIsolation(): " + string);
        return string;
    }

    public static boolean isEqualTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.errorParam(bigDecimal == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueOne"));
        Assert.errorParam(bigDecimal2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueTwo"));
        return bigDecimal.compareTo(bigDecimal2) == 0;
    }

    public static boolean isNotEqualTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.errorParam(bigDecimal == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueOne"));
        Assert.errorParam(bigDecimal2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueTwo"));
        return bigDecimal.compareTo(bigDecimal2) != 0;
    }

    public static boolean isLessThan(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.errorParam(bigDecimal == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueOne"));
        Assert.errorParam(bigDecimal2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueTwo"));
        return bigDecimal.compareTo(bigDecimal2) < 0;
    }

    public static boolean isLessThanOrEqualTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.errorParam(bigDecimal == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueOne"));
        Assert.errorParam(bigDecimal2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueTwo"));
        return bigDecimal.compareTo(bigDecimal2) <= 0;
    }

    public static boolean isGreaterThan(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.errorParam(bigDecimal == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueOne"));
        Assert.errorParam(bigDecimal2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueTwo"));
        return bigDecimal.compareTo(bigDecimal2) > 0;
    }

    public static boolean isGreaterThanOrEqualTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.errorParam(bigDecimal == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueOne"));
        Assert.errorParam(bigDecimal2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "valueTwo"));
        return bigDecimal.compareTo(bigDecimal2) >= 0;
    }

    public static Long getLongValue(Object object) {
        Long l = null;
        if (object != null) {
            l = Long.valueOf(object.toString());
        }
        return l;
    }

    public static Collection<Long> getLongValues(Collection collection) {
        MutableList<Long> mutableList = null;
        if (collection != null) {
            mutableList = new MutableList<Long>(collection.size());
            for (Object e : collection) {
                mutableList.add(Methods.getLongValue(e));
            }
        }
        return mutableList;
    }

    public static BigDecimal getBigDecimalValue(Object object) {
        BigDecimal bigDecimal = null;
        if (object != null) {
            bigDecimal = new BigDecimal(object.toString());
        }
        return bigDecimal;
    }

    public static Collection<BigDecimal> getBigDecimalValues(Collection collection) {
        MutableList<BigDecimal> mutableList = null;
        if (collection != null) {
            mutableList = new MutableList<BigDecimal>(collection.size());
            for (Object e : collection) {
                mutableList.add(Methods.getBigDecimalValue(e));
            }
        }
        return mutableList;
    }

    public static Boolean getBooleanValue(Object object) {
        Boolean bl = null;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object instanceof String) {
            bl = Boolean.valueOf((String)object);
        }
        return bl;
    }

    public static Collection<Boolean> getBooleanValues(Collection collection) {
        MutableList<Boolean> mutableList = null;
        if (collection != null) {
            mutableList = new MutableList<Boolean>(collection.size());
            for (Object e : collection) {
                mutableList.add(Methods.getBooleanValue(e));
            }
        }
        return mutableList;
    }

    public static Date getDateValue(Object object) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof String) {
            date = new Date((String)object);
        }
        return date;
    }

    public static Collection<Date> getDateValues(Collection<Object> collection) {
        MutableList<Date> mutableList = null;
        if (collection != null) {
            mutableList = new MutableList<Date>(collection.size());
            for (Object object : collection) {
                mutableList.add(Methods.getDateValue(object));
            }
        }
        return mutableList;
    }

    public static DateTime getDateTimeValue(Object object) {
        DateTime dateTime = null;
        if (object instanceof DateTime) {
            dateTime = (DateTime)object;
        } else if (object instanceof String) {
            dateTime = new DateTime((String)object);
        }
        return dateTime;
    }

    public static Collection<DateTime> getDateTimeValues(Collection<Object> collection) {
        MutableList<DateTime> mutableList = null;
        if (collection != null) {
            mutableList = new MutableList<DateTime>(collection.size());
            for (Object object : collection) {
                mutableList.add(Methods.getDateTimeValue(object));
            }
        }
        return mutableList;
    }

    public static TimeOfDay getTimeOfDayValue(Object object) {
        TimeOfDay timeOfDay = null;
        if (object instanceof TimeOfDay) {
            timeOfDay = (TimeOfDay)object;
        } else if (object instanceof String) {
            timeOfDay = new TimeOfDay((String)object);
        }
        return timeOfDay;
    }

    public static Collection<TimeOfDay> getTimeOfDayValues(Collection<Object> collection) {
        MutableList<TimeOfDay> mutableList = null;
        if (collection != null) {
            mutableList = new MutableList<TimeOfDay>(collection.size());
            for (Object object : collection) {
                mutableList.add(Methods.getTimeOfDayValue(object));
            }
        }
        return mutableList;
    }

    public static Time getTimeValue(Object object) {
        Time time = null;
        if (object instanceof Time) {
            time = (Time)object;
        } else if (object instanceof String) {
            time = new Time((String)object);
        }
        return time;
    }

    public static Collection<Time> getTimeValues(Collection<Object> collection) {
        MutableList<Time> mutableList = null;
        if (collection != null) {
            mutableList = new MutableList<Time>(collection.size());
            for (Object object : collection) {
                mutableList.add(Methods.getTimeValue(object));
            }
        }
        return mutableList;
    }

    public static String getRandomString(int n) {
        return Methods.getRandomString(n, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static String getRandomString(int n, String string) {
        StringBuilder stringBuilder = null;
        int n2 = 0;
        stringBuilder = new StringBuilder(n);
        for (int i = 1; i <= n; ++i) {
            n2 = (int)Methods.getRandomNumber(0L, string.length() - 1);
            stringBuilder.append(string.substring(n2, n2 + 1));
        }
        return stringBuilder.toString();
    }

    public static String zipper(String string, String string2) {
        StringBuilder stringBuilder = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "stringOne"));
        Assert.errorParam(string2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "stringTwo"));
        n = Math.min(string.length(), string2.length());
        n2 = Math.max(string.length(), string2.length());
        stringBuilder = new StringBuilder(string.length() + string2.length());
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.substring(i, i + 1));
            stringBuilder.append(string2.substring(i, i + 1));
        }
        if (n != n2) {
            string3 = string.length() == n ? string : string2;
            stringBuilder.append(string3.substring(n));
        }
        return stringBuilder.toString();
    }

    public static boolean hasSuperClass(Class clazz, Class clazz2) {
        boolean bl = false;
        Class clazz3 = null;
        Class clazz4 = null;
        while ((clazz3 = clazz.getSuperclass()) != null && !clazz3.equals(clazz4)) {
            if (clazz3.equals(clazz2)) {
                bl = true;
                break;
            }
            clazz4 = clazz3;
        }
        return bl;
    }

    public static ImageIcon getImageIcon(Class clazz, String string) {
        return Methods.getImageIcon(Methods.getClassPathResourceAsURL(clazz, string));
    }

    public static ImageIcon getImageIcon(File file) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = Methods.getImageIcon(file.toURL());
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return imageIcon;
    }

    public static ImageIcon getImageIcon(URL uRL) {
        return new ImageIcon(uRL);
    }

    public static boolean isEmptyString(String string) {
        boolean bl = false;
        bl = string != null && string.length() == 0;
        return bl;
    }

    public static Class safeClassForName(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new ReflectionException(exception);
        }
        return clazz;
    }

    public static Constructor safeGetConstructor(Class clazz, Class ... classArray) {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            throw new ReflectionException(exception);
        }
        return constructor;
    }

    public static Object safeNewInstance(String string) {
        return Methods.safeNewInstance(Methods.safeClassForName(string));
    }

    public static Object safeNewInstance(Class clazz) {
        Object var1_1 = null;
        try {
            var1_1 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ReflectionException(exception);
        }
        return var1_1;
    }

    public static Object safeNewInstance(Constructor constructor, Object ... objectArray) {
        Object var2_2 = null;
        try {
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ReflectionException(exception);
        }
        return var2_2;
    }

    public static boolean between(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static Integer min(int ... nArray) {
        return Methods.min(null, null, nArray);
    }

    public static Integer min(Integer n, Integer n2, int ... nArray) {
        Integer n3 = null;
        Assert.errorParam(nArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "numbers"));
        for (int n4 : nArray) {
            if (n != null && n4 < n || n2 != null && n4 > n2) continue;
            n3 = n3 == null ? n4 : Math.min(n3, n4);
        }
        return n3;
    }

    public static Integer min(Integer n, Integer n2, NullFreeCollection<Integer> nullFreeCollection) {
        Integer n3 = null;
        Assert.errorParam(nullFreeCollection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "numbers"));
        Iterator iterator = nullFreeCollection.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            if (n != null && n4 < n || n2 != null && n4 > n2) continue;
            n3 = n3 == null ? n4 : Math.min(n3, n4);
        }
        return n3;
    }

    public static Integer max(int ... nArray) {
        return Methods.max(null, null, nArray);
    }

    public static Integer max(Integer n, Integer n2, int ... nArray) {
        Integer n3 = null;
        Assert.errorParam(nArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "numbers"));
        for (int n4 : nArray) {
            if (n != null && n4 < n || n2 != null && n4 > n2) continue;
            n3 = n3 == null ? n4 : Math.max(n3, n4);
        }
        return n3;
    }

    public static String readFromInputStream(InputStream inputStream) {
        return Methods.readFromInputStream(inputStream, "UTF-8");
    }

    public static String readFromInputStream(InputStream inputStream, String string) {
        StringWrapper stringWrapper = new StringWrapper();
        LineNumberReader lineNumberReader = null;
        String string2 = null;
        try {
            lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, string));
            while ((string2 = lineNumberReader.readLine()) != null) {
                stringWrapper.append(string2);
                stringWrapper.append("\n");
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return stringWrapper.toString();
    }

    public static boolean validateEmailAddress(String string) {
        boolean bl = false;
        StringWrapper stringWrapper = null;
        if (string != null) {
            stringWrapper = new StringWrapper(string);
            boolean bl2 = bl = stringWrapper.contains("@") && !stringWrapper.startsWith("@", ".") && !stringWrapper.endsWithAny("@", ".");
            if (bl) {
                stringWrapper.deleteTo("@");
                bl = stringWrapper.contains(".") && !stringWrapper.startsWith(".");
            }
        }
        return bl;
    }

    public static Component getFocusOwner(Component component) {
        Component component2 = null;
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component instanceof Window) {
            component2 = ((Window)component).getFocusOwner();
        }
        return component2;
    }

    public static boolean hasFocusOwner(Component component) {
        return Methods.getFocusOwner(component) != null;
    }
}

