/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Assert;
import com.jronimo.util.EncryptionUtils;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.util.StringWrapper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMethods {
    private static final Logger logger = Logger.getLogger(FileMethods.class);

    protected FileMethods() {
    }

    public static long getChecksum(File file) {
        long l = 0L;
        try {
            l = EncryptionUtils.getChecksum(FileMethods.readBinaryFile(file));
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return l;
    }

    public static String extractNameFromFilename(String string) {
        return string.substring(0, string.lastIndexOf("."));
    }

    public static String extractExtensionFromFilename(String string) {
        return string.substring(string.lastIndexOf("."));
    }

    public static File getUserDefaultDirectory() {
        return FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public static File getUserHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public static NullFreeMutableList<String> readTextFileLines(URL uRL) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        try {
            nullFreeMutableList = FileMethods.readTextFileLines(new File(uRL.toURI()));
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return nullFreeMutableList;
    }

    public static NullFreeMutableList<String> readTextFileLines(File file) {
        return FileMethods.readTextFileLines(file, false, true, true);
    }

    public static NullFreeMutableList<String> readTextFileLines(File file, boolean bl, boolean bl2, boolean bl3) {
        return new StringWrapper(FileMethods.readTextFile(file)).getLines(bl, bl2, bl3);
    }

    public static List<String> readTextFileLines(Class clazz, String string, boolean bl) {
        List list = null;
        String string2 = null;
        InputStream inputStream = null;
        try {
            if (bl) {
                string2 = "UTF-8";
            }
            string2 = "UTF-8";
            inputStream = Methods.getClassPathResourceAsStream(clazz, string);
            list = IOUtils.readLines((InputStream)inputStream, (String)string2);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return list;
    }

    public static String readTextFile(URL uRL) {
        String string = null;
        try {
            string = FileMethods.readTextFile(new File(uRL.toURI()));
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return string;
    }

    public static String readTextFileFromClassPath(Class clazz, String string) {
        return FileMethods.readTextFile(Methods.getClassPathResourceAsFile(clazz, string));
    }

    public static String readTextFile(File file) {
        String string = null;
        boolean bl = false;
        try {
            bl = !file.getName().endsWith(".java");
            string = FileMethods.readTextFile(file, bl);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return string;
    }

    public static String readTextFile(File file, boolean bl) {
        String string = null;
        String string2 = null;
        try {
            if (bl) {
                string2 = "UTF-8";
            }
            string2 = "UTF-8";
            string = FileUtils.readFileToString((File)file, (String)string2);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return string;
    }

    public static String readTextFile(Class clazz, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (String string2 : FileMethods.readTextFileLines(clazz, string, bl)) {
                stringBuilder.append(string2).append("\n");
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> readProperties(URL uRL) throws Exception {
        Map<String, String> map = null;
        map = FileMethods.readProperties(new File(uRL.toURI()));
        return map;
    }

    public static Map<String, String> readProperties(File file) throws Exception {
        HashMap<String, String> hashMap = null;
        NullFreeMutableList<String> nullFreeMutableList = null;
        int n = 0;
        nullFreeMutableList = FileMethods.readTextFileLines(file, false, true, true);
        hashMap = new HashMap<String, String>(nullFreeMutableList.size());
        for (String string : nullFreeMutableList) {
            n = string.indexOf("=");
            hashMap.put(string.substring(0, n), string.substring(n + 1));
        }
        return hashMap;
    }

    public static void writeTextFile(File file, StringBuilder stringBuilder) throws Exception {
        FileMethods.writeTextFile(file, stringBuilder.toString());
    }

    public static void writeTextFile(File file, String string) {
        boolean bl = false;
        bl = !file.getName().endsWith(".java");
        FileMethods.writeTextFile(file, string, bl, false);
    }

    public static void writeTextFile(File file, String string, boolean bl, boolean bl2) {
        String string2 = null;
        try {
            if (bl) {
                string2 = "UTF-8";
            }
            FileUtils.writeStringToFile((File)file, (String)string, (String)string2, (boolean)bl2);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public static void writeBinaryFile(File file, byte[] byArray) {
        FileMethods.writeBinaryFile(file, byArray, false);
    }

    public static void writeBinaryFile(File file, byte[] byArray, boolean bl) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])byArray, (boolean)bl);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public static byte[] readBinaryFile(File file) {
        byte[] byArray = null;
        try {
            byArray = FileMethods.readBinaryFile(file, 0L, (int)file.length());
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryFile(File file, long l, int n) throws Exception {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        try {
            byArray = new byte[n];
            fileInputStream = new FileInputStream(file);
            fileInputStream.skip(l);
            fileInputStream.read(byArray);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static int getNumberOfFiles(File file, String[] stringArray) {
        int n = 0;
        File file2 = null;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            file2 = new File(file, stringArray[i]);
            if (!file2.exists() || !file2.isFile()) continue;
            ++n;
        }
        return n;
    }

    public static void deleteFolderContents(File file, boolean bl) {
        FileMethods.deleteFolderContents(file, bl, true, true, true);
    }

    public static NullFreeImmutableSet<File> listFiles(File file, boolean bl) {
        return FileMethods.listFiles(file, bl, false);
    }

    public static NullFreeImmutableSet<File> listFiles(File file, boolean bl, boolean bl2) {
        return FileMethods.listFiles(file, bl, bl2, new EmptyFileFilter());
    }

    public static NullFreeImmutableSet<File> listFiles(File file, boolean bl, boolean bl2, FileFilter fileFilter) {
        NullFreeImmutableSet<File> nullFreeImmutableSet = null;
        NullFreeMutableSet<File> nullFreeMutableSet = null;
        Assert.errorParamMustNotBeNull("fileFilter", fileFilter);
        nullFreeMutableSet = new NullFreeMutableSet<File>(20);
        FileMethods.listFiles(file, bl, bl2, fileFilter, nullFreeMutableSet);
        nullFreeImmutableSet = new NullFreeImmutableSet<File>((Collection<File>)nullFreeMutableSet);
        return nullFreeImmutableSet;
    }

    private static void listFiles(File file, boolean bl, boolean bl2, FileFilter fileFilter, NullFreeMutableSet<File> nullFreeMutableSet) {
        for (File file2 : file.listFiles(fileFilter)) {
            if (file2.isDirectory()) {
                if (bl) {
                    nullFreeMutableSet.add(file2);
                }
                if (!bl2) continue;
                FileMethods.listFiles(file2, bl, bl2, fileFilter, nullFreeMutableSet);
                continue;
            }
            nullFreeMutableSet.add(file2);
        }
    }

    public static void deleteFolderContents(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        File[] fileArray = null;
        File file22 = null;
        if (!file.exists()) {
            return;
        }
        for (File file22 : file.listFiles()) {
            if (file22.isDirectory()) {
                if (bl4 && !file22.getName().equals(".svn")) {
                    FileMethods.deleteFolderContents(file22, bl3, bl2, bl3, bl4);
                    continue;
                }
                if (!bl3 || file22.getName().equals(".svn") || file22.listFiles().length != 0) continue;
                file22.delete();
                continue;
            }
            if (!bl2) continue;
            boolean bl5 = file22.delete();
        }
        if (bl && file.listFiles().length == 0) {
            file.delete();
        }
    }

    public static void deleteEmptyDirectories(File file) {
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            if (FileMethods.listFiles(file2, false, true).isEmpty()) {
                FileMethods.deleteFolderContents(file2, true);
                continue;
            }
            FileMethods.deleteEmptyDirectories(file2);
        }
    }

    public static void copyFileTo(File file, File file2) {
        FileMethods.copyFileTo(file, file2, 1024000);
    }

    public static void copyFileTo(File file, File file2, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        try {
            if (file2.exists()) {
                file2.delete();
            }
            file2.getParentFile().mkdirs();
            file2.createNewFile();
            n2 = (int)file.length();
            if (n <= 0 || n2 == 0 || n2 < n) {
                byArray = FileMethods.readBinaryFile(file);
                FileMethods.writeBinaryFile(file2, byArray, false);
            } else {
                n3 = (int)Math.floor(n2 / n);
                n4 = n2 - n3 * n;
                for (int i = 0; i < n3; ++i) {
                    byArray = FileMethods.readBinaryFile(file, i * n, n);
                    FileMethods.writeBinaryFile(file2, byArray, true);
                }
                if (n4 > 0) {
                    byArray = FileMethods.readBinaryFile(file, n3 * n, n4);
                    FileMethods.writeBinaryFile(file2, byArray, true);
                }
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public static String compareTextFiles(File file, File file2) {
        String string = null;
        NullFreeMutableList<String> nullFreeMutableList = null;
        NullFreeMutableList<String> nullFreeMutableList2 = null;
        int n = 0;
        try {
            nullFreeMutableList = FileMethods.readTextFileLines(file);
            nullFreeMutableList2 = FileMethods.readTextFileLines(file2);
            if (Methods.isEmpty(nullFreeMutableList) && Methods.isEmpty(nullFreeMutableList2)) {
                string = "Both files are empty.";
            } else if (Methods.isEmpty(nullFreeMutableList)) {
                string = "file1 is empty.";
            } else if (Methods.isEmpty(nullFreeMutableList2)) {
                string = "file2 is empty.";
            } else {
                n = Math.min(nullFreeMutableList.size(), nullFreeMutableList2.size());
                for (int i = 0; i < n; ++i) {
                    if (((String)nullFreeMutableList.get(i)).equals(nullFreeMutableList2.get(i))) continue;
                    string = "Mismatch on line: " + (i + 1);
                    break;
                }
                if (string == null && FileMethods.getChecksum(file) != FileMethods.getChecksum(file2)) {
                    string = "The files have different checksums.";
                }
            }
            if (string == null) {
                string = "The files match.";
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return string;
    }

    public static void copyDirectoryContentsTo(File file, File file2) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public static void copyDirectoryContentsTo(File file, File file2, FileFilter fileFilter) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2, (FileFilter)fileFilter);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public static void moveDirectory(File file, File file2) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2);
            FileUtils.deleteDirectory((File)file);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public static void deleteSvnDirectories(File file) {
        File file2 = null;
        file2 = new File(file, ".svn");
        if (file2.exists() && file2.isDirectory()) {
            FileMethods.deleteFolderContents(file2, true);
        }
        for (File file3 : file.listFiles()) {
            if (!file3.isDirectory()) continue;
            FileMethods.deleteSvnDirectories(file3);
        }
    }

    public static File findFile(String string, Collection<File> collection) {
        File file = null;
        File file2 = null;
        if (collection != null && !collection.isEmpty()) {
            for (File file3 : collection) {
                file2 = new File(file3, string);
                if (!file2.exists()) continue;
                file = file2;
                break;
            }
        }
        return file;
    }

    public static class EmptyFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return true;
        }
    }
}

