/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.util.Logger;
import com.jronimo.util.MethodInvoker;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventFirer {
    private static final Logger logger = Logger.getLogger(EventFirer.class);
    private Collection<Object> listeners;
    private MethodInvoker methodInvoker;
    private Collection<Throwable> exceptions = new ArrayList<Throwable>(1);

    public EventFirer(Collection<Object> collection, MethodInvoker methodInvoker) {
        this.listeners = CollectionUtils.collectionToList(collection);
        this.methodInvoker = methodInvoker;
    }

    public void execute() {
        for (Object object : this.listeners) {
            try {
                this.methodInvoker.invoke(object);
            }
            catch (Exception exception) {
                logger.debug("EXCEPTION - EventFirer: " + exception.getMessage());
                this.exceptions.add(exception);
            }
        }
    }

    public void execute(boolean bl) {
        for (Object object : this.listeners) {
            this.executeWithThread(object, bl);
        }
    }

    private void executeWithThread(final Object object, boolean bl) {
        Thread thread = null;
        thread = new Thread(new Runnable(){

            public void run() {
                try {
                    EventFirer.this.methodInvoker.invoke(object);
                }
                catch (Exception exception) {
                    logger.debug("EXCEPTION - EventFirer: " + exception.getMessage());
                    EventFirer.this.exceptions.add(exception);
                }
            }
        });
        if (bl) {
            SwingUtilities.invokeLater(thread);
        } else {
            thread.start();
        }
    }

    public boolean hasExceptions() {
        return this.exceptions.size() > 0;
    }

    public Collection<Throwable> getExceptions() {
        return this.exceptions;
    }
}

