/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Assert;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptionUtils {
    private static final Logger logger = Logger.getLogger(EncryptionUtils.class);

    protected EncryptionUtils() {
    }

    public static long getChecksum(byte[] byArray) throws Exception {
        long l = 0L;
        CRC32 cRC32 = null;
        cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        l = cRC32.getValue();
        return l;
    }

    public static String hash(String string) {
        return EncryptionUtils.hash(string, Encoding.BASE_64);
    }

    public static String hash(String string, Encoding encoding) {
        String string2 = null;
        DigestStruct digestStruct = null;
        Assert.errorParamMustNotBeNull("string", string);
        digestStruct = new DigestStruct();
        digestStruct.string = string;
        digestStruct.encoding = encoding;
        string2 = EncryptionUtils.createDigest(digestStruct);
        return string2;
    }

    public static String createDigest(DigestStruct digestStruct) {
        String string = null;
        MessageDigest messageDigest = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        Assert.errorParamMustNotBeNull("struct", digestStruct);
        try {
            byArray = digestStruct.bytes == null ? digestStruct.string.getBytes("UTF-8") : digestStruct.bytes;
            for (int i = 1; i <= digestStruct.depth; ++i) {
                messageDigest = MessageDigest.getInstance(digestStruct.hash.getName());
                messageDigest.update(byArray);
                byArray2 = messageDigest.digest();
                switch (digestStruct.encoding) {
                    case BASE_64: {
                        string = new BASE64Encoder().encode(byArray2);
                        break;
                    }
                    case HEX: {
                        string = new String(Hex.encodeHex((byte[])byArray2));
                    }
                }
                if (i >= digestStruct.depth) continue;
                byArray = string.getBytes("UTF-8");
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return string;
    }

    public static KeyPair createKeyPair() {
        KeyPair keyPair = null;
        SecureRandom secureRandom = null;
        KeyPairGenerator keyPairGenerator = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyPairGenerator = KeyPairGenerator.getInstance("DSA", "SUN");
            keyPairGenerator.initialize(1024, secureRandom);
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException);
        }
        return keyPair;
    }

    public static void createKeyPair(File file, File file2) {
        KeyPair keyPair = null;
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        keyPair = EncryptionUtils.createKeyPair();
        privateKey = keyPair.getPrivate();
        publicKey = keyPair.getPublic();
        FileMethods.writeBinaryFile(file, privateKey.getEncoded());
        FileMethods.writeBinaryFile(file2, publicKey.getEncoded());
    }

    public static PrivateKey getPrivateKey(File file) {
        PrivateKey privateKey = null;
        byte[] byArray = null;
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = null;
        KeyFactory keyFactory = null;
        try {
            byArray = FileMethods.readBinaryFile(file);
            pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            keyFactory = KeyFactory.getInstance("DSA", "SUN");
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CryptoException(invalidKeySpecException);
        }
        return privateKey;
    }

    public static PublicKey getPublicKey(File file) {
        PublicKey publicKey = null;
        byte[] byArray = null;
        X509EncodedKeySpec x509EncodedKeySpec = null;
        KeyFactory keyFactory = null;
        try {
            byArray = FileMethods.readBinaryFile(file);
            x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            keyFactory = KeyFactory.getInstance("DSA", "SUN");
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CryptoException(invalidKeySpecException);
        }
        return publicKey;
    }

    public static String signText(PrivateKey privateKey, String string) {
        String string2 = null;
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA1withDSA", "SUN");
            signature.initSign(privateKey);
            signature.update(string.getBytes());
            string2 = URLEncoder.encode(new String(signature.sign()), "UTF-8");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new CryptoException(signatureException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CryptoException(unsupportedEncodingException);
        }
        return string2;
    }

    public static boolean verifySignature(PublicKey publicKey, String string, String string2) {
        boolean bl = false;
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA1withDSA", "SUN");
            signature.initVerify(publicKey);
            signature.update(string.getBytes());
            bl = signature.verify(URLDecoder.decode(string2, "UTF-8").getBytes());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new CryptoException(signatureException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CryptoException(unsupportedEncodingException);
        }
        return bl;
    }

    public static String passphraseEncrypt(String string, String string2) {
        String string3 = null;
        SecretKeySpec secretKeySpec = null;
        Cipher cipher = null;
        byte[] byArray = null;
        try {
            secretKeySpec = new SecretKeySpec(string2.getBytes(), EncryptionAlgorithm.AES.getName());
            cipher = Cipher.getInstance(EncryptionAlgorithm.AES.getName());
            cipher.init(1, secretKeySpec);
            byArray = cipher.doFinal(string.getBytes());
            string3 = new BASE64Encoder().encode(byArray);
        }
        catch (Exception exception) {
            throw new CryptoException(exception);
        }
        return string3;
    }

    public static String passphraseDecrypt(String string, String string2) {
        String string3 = null;
        SecretKeySpec secretKeySpec = null;
        Cipher cipher = null;
        byte[] byArray = null;
        try {
            secretKeySpec = new SecretKeySpec(string2.getBytes(), EncryptionAlgorithm.AES.getName());
            cipher = Cipher.getInstance(EncryptionAlgorithm.AES.getName());
            cipher.init(2, secretKeySpec);
            byArray = new BASE64Decoder().decodeBuffer(string);
            byArray = cipher.doFinal(byArray);
            string3 = new String(byArray);
        }
        catch (Exception exception) {
            throw new CryptoException(exception);
        }
        return string3;
    }

    public static class CryptoException
    extends RuntimeException {
        private Throwable wrappedException = null;

        public CryptoException(Throwable throwable) {
            this.wrappedException = throwable;
        }

        public Throwable getWrappedException() {
            return this.wrappedException;
        }

        public String getMessage() {
            return this.wrappedException == null ? "" : this.wrappedException.getMessage();
        }
    }

    public static class EncryptionStruct {
        public EncryptionAlgorithm algorithm = EncryptionAlgorithm.AES;
        public Encoding encoding = Encoding.BASE_64;
        public String passphrase;
        public String text;
    }

    public static class DigestStruct {
        public HashAlgorithm hash = HashAlgorithm.MD5;
        public Encoding encoding = Encoding.BASE_64;
        public int depth = 1;
        public String string;
        public byte[] bytes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Encoding {
        BASE_64,
        HEX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EncryptionAlgorithm {
        AES("AES");

        private String name;

        private EncryptionAlgorithm(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HashAlgorithm {
        MD5("MD5"),
        SHA_1("SHA-1");

        private String name;

        private HashAlgorithm(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

